/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2003-2004 by CHUO ELECTRIC WORKS Co.,LTD. JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 */
/*
 *  ()ITRONSH1CPUܡ
 *  ϡɥ񸻤
 */

#ifndef _ZUNDA_SH1_H_
#define _ZUNDA_SH1_H_

/* ӣãɥͥ룰 */
#if 0 /* sh1sci2.cƤ */
#define SCI_SMR0	((VH *)0x5fffec0)	/* ꥢ뎥⡼Ɏ쥸 */
#define SCI_BRR0	((VH *)0x5fffec1)	/* ӥåȥ졼Ȏ쥸 */
#define SCI_SCR0	((VH *)0x5fffec2)	/* ꥢ뎥ȥ뎥쥸 */
#define SCI_TDR0	((VH *)0x5fffec3)	/* ȥ󥹥ߥåȎǡ쥸 */
#define SCI_SSR0	((VH *)0x5fffec4)	/* ꥢ뎥ơ쥸 */
#define SCI_RDR0	((VH *)0x5fffec5)	/* 쥷֎ǡ쥸 */

/* ӣãɥͥ룱 */
#define SCI_SMR1	((VH *)0x5fffec8)	/* ꥢ뎥⡼Ɏ쥸 */
#define SCI_BRR1	((VH *)0x5fffec9)	/* ӥåȥ졼Ȏ쥸 */
#define SCI_SCR1	((VH *)0x5fffeca)	/* ꥢ뎥ȥ뎥쥸 */
#define SCI_TDR1	((VH *)0x5fffecb)	/* ȥ󥹥ߥåȎǡ쥸 */
#define SCI_SSR1	((VH *)0x5fffecc)	/* ꥢ뎥ơ쥸 */
#define SCI_RDR1	((VH *)0x5fffecd)	/* 쥷֎ǡ쥸 */
#endif	/* sh1sci2.c */

#define PBCR1_TD1_RD1_MASK	~0xf0u		/*  TxD1,RxD1üѥޥ	*/
#define PBCR1_TD1 		0x80u		/*  TxD1üѥޥ  	*/
#define PBCR1_RD1 		0x20u		/*  RxD1üѥޥ  	*/

/*  */
#define AD_DRAH		((VH *)0x5fffee0)	/* A/D ǡ쥸 Hʎˎގ92*/
#define AD_DRAL		((VH *)0x5fffee1)	/* A/D ǡ쥸 Lʎˎގ10*/
#define AD_DRBH		((VH *)0x5fffee2)	/* A/D ǡ쥸 Hʎˎގ92*/
#define AD_DRBL		((VH *)0x5fffee3)	/* A/D ǡ쥸 Lʎˎގ10*/
#define AD_DRCH		((VH *)0x5fffee4)	/* A/D ǡ쥸 Hʎˎގ92*/
#define AD_DRCL		((VH *)0x5fffee5)	/* A/D ǡ쥸 Lʎˎގ10*/
#define AD_DRDH		((VH *)0x5fffee6)	/* A/D ǡ쥸 Hʎˎގ92*/
#define AD_DRDL		((VH *)0x5fffee7)	/* A/D ǡ쥸 Lʎˎގ10*/
#define AD_CSR		((VH *)0x5fffee8)	/* A/D ȥ롿ơ쥸 */
#define AD_CR		((VH *)0x5fffee9)	/* A/D ȥ뎥쥸 		 */
#define	ADF			0x80		/* ADF				*/
#define	ADST			0x20		/* A/D start			*/

#if 0 /* sh1itu.hƤ */
/* ɣԣն */
#define ITU_TSTR	((VH *)0x5ffff00)	/* ގȎ쥸 */
#define ITU_TSNC	((VH *)0x5ffff01)	/* ގ󥯥펥쥸 */
#define ITU_TMDR	((VH *)0x5ffff02)	/* ގ⡼Ɏ쥸 	*/
#define ITU_TFCR	((VH *)0x5ffff03)	/* ގե󥯥󎥥ȥ뎥쥸 */
#define ITU_TOER	((VH *)0x5ffff31)	/* ގȥץåȎޥ֥͡뎥쥸 */

/* ɣԣեͥ룰 */
#define ITU_TCR0	((VH *)0x5ffff04)	/* ގȥ뎥쥸0 		*/
#define ITU_TIOR0	((VH *)0x5ffff05)	/* ޣɡϥȥ뎥쥸0 	*/
#define ITU_TIER0	((VH *)0x5ffff06)	/* ގ󥿥ץȎ֥͡뎥쥸0 */
#define ITU_TSR0	((VH *)0x5ffff07)	/* ގơ쥸0 */
#define ITU_TCNT0	((VH *)0x5ffff08)	/* ގ0 */
#define ITU_GRA0	((VH *)0x5ffff0a)	/* ͥ뎥쥸0 */
#define ITU_GRB0	((VH *)0x5ffff0c)	/* ͥ뎥쥸0 */
#endif /* sh1itu.h */

/* ɣԣեͥ룱 */
#define ITU_TCR1	((VH *)0x5ffff0e)	/* ގȥ뎥쥸1 */
#define ITU_TIOR1	((VH *)0x5ffff0f)	/* ޣɡϥȥ뎥쥸1 */
#define ITU_TIER1	((VH *)0x5ffff10)	/* ގ󥿥ץȎ֥͡뎥쥸1 */
#define ITU_TSR1	((VH *)0x5ffff11)	/* ގơ쥸1 */
#define ITU_TCNT1	((VH *)0x5ffff12)	/* ގ1 */
#define ITU_GRA1	((VH *)0x5ffff14)	/* ͥ뎥쥸1 */
#define ITU_GRB1	((VH *)0x5ffff16)	/* ͥ뎥쥸1 */

/* ɣԣեͥ룲 */
#define ITU_TCR2	((VH *)0x5ffff18)	/* ގȥ뎥쥸2  */
#define ITU_TIOR2	((VH *)0x5ffff19)	/* ޣɡϥȥ뎥쥸2  */
#define ITU_TIER2	((VH *)0x5ffff1a)	/* ގ󥿥ץȎ֥͡뎥쥸2  */
#define ITU_TSR2	((VH *)0x5ffff1b)	/* ގơ쥸2  */
#define ITU_TCNT2	((VH *)0x5ffff1c)	/* ގ2  */
#define ITU_GRA2	((VH *)0x5ffff1e)	/* ͥ뎥쥸2 */
#define ITU_GRB2	((VH *)0x5ffff20)	/* ͥ뎥쥸2 */

/* ɣԣեͥ룳 */
#define ITU_TCR3	((VH *)0x5ffff22)	/* ގȥ뎥쥸3 */
#define ITU_TIOR3	((VH *)0x5ffff23)	/* ޣɡϥȥ뎥쥸3 */
#define ITU_TIER3	((VH *)0x5ffff24)	/* ގ󥿥ץȎ֥͡뎥쥸3 */
#define ITU_TSR3	((VH *)0x5ffff25)	/* ގơ쥸3 */
#define ITU_TCNT3	((VH *)0x5ffff26)	/* ގ3 */
#define ITU_GRA3	((VH *)0x5ffff28)	/* ͥ뎥쥸3 */
#define ITU_GRB3	((VH *)0x5ffff2a)	/* ͥ뎥쥸3 */
#define ITU_BRA3	((VH *)0x5ffff2c)	/* Хåե쥸3 */
#define ITU_BRB3	((VH *)0x5ffff2e)	/* Хåե쥸3 */

/* ɣԣեͥ룴 */
#define ITU_TCR4	((VH *)0x5ffff32)	/* ގȥ뎥쥸4 */
#define ITU_TIOR4	((VH *)0x5ffff33)	/* ޣɡϥȥ뎥쥸4 */
#define ITU_TIER4	((VH *)0x5ffff34)	/* ގ󥿥ץȎ֥͡뎥쥸4 */
#define ITU_TSR4	((VH *)0x5ffff35)	/* ގơ쥸4 */
#define ITU_TCNT4	((VH *)0x5ffff36)	/* ގ4 */
#define ITU_GRA4	((VH *)0x5ffff38)	/* ͥ뎥쥸4 */
#define ITU_GRB4	((VH *)0x5ffff3a)	/* ͥ뎥쥸4 */
#define ITU_BRA4	((VH *)0x5ffff3c)	/* Хåե쥸4 */
#define ITU_BRB4	((VH *)0x5ffff3e)	/* Хåե쥸4 */

/* ɣԣ */
#if 0 /* sh1itu.hƤ */
#ifndef	TSR_IMFA
#define TSR_IMFA	0x0001			/* GRAݎ͎ߎώ/ݎ̎ߎĎ̎ߎ̎׎A */
#endif
#endif /* sh1itu.h */

#ifndef	TSR_IMFB
#define TSR_IMFB	0x0002			/* GRBݎ͎ߎώ/ݎ̎ߎĎ̎ߎ̎׎B */
#endif
#define TSR_OVF	 	0x0004				/* ʎގ̎ێ̎׎ */

/* ģͣö */
#define DMAC_DMAOR	((VH *)0x5ffff48)		/* DMA ڥ졼󎥥쥸 */

/* ģͣåͥ룰 */
#define DMAC_SAR0	((VH *)0x5ffff40)	/* DMA ɥ쥹쥸0 */
#define DMAC_DAR0	((VH *)0x5ffff44)	/* DMA ǥƥ͡󎥥ɥ쥹쥸0 */
#define DMAC_TCR0	((VH *)0x5ffff4a)	/* DMA ȥ󥹥եȎ쥸0 */
#define DMAC_CHCR0	((VH *)0x5ffff4e)		/* DMA ͥ뎥ȥ뎥쥸0 */

/* ģͣåͥ룱 */
#define DMAC_SAR1	((VH *)0x5ffff50)	/* DMA ɥ쥹쥸1 */
#define DMAC_DAR1	((VH *)0x5ffff54)	/* DMA ǥƥ͡󎥥ɥ쥹쥸1 */
#define DMAC_TCR1	((VH *)0x5ffff5a)	/* DMA ȥ󥹥եȎ쥸1 */
#define DMAC_CHCR1	((VH *)0x5ffff5e)		/* DMA ͥ뎥ȥ뎥쥸1 */
/* ģͣåͥ룲 */

#define DMAC_SAR2	((VH *)0x5ffff60)	/* DMA ɥ쥹쥸2 */
#define DMAC_DAR2	((VH *)0x5ffff64)	/* DMA ǥƥ͡󎥥ɥ쥹쥸2 */
#define DMAC_TCR2	((VH *)0x5ffff6a)	/* DMA ȥ󥹥եȎ쥸2 */
#define DMAC_CHCR2	((VH *)0x5ffff6e)		/* DMA ͥ뎥ȥ뎥쥸2 */

/* ģͣåͥ룳 */
#define DMAC_SAR3	((VH *)0x5ffff70)	/* DMA ɥ쥹쥸3 */
#define DMAC_DAR3	((VH *)0x5ffff74)	/* DMA ǥƥ͡󎥥ɥ쥹쥸3 */
#define DMAC_TCR3	((VH *)0x5ffff7a)	/* DMA ȥ󥹥եȎ쥸3 */
#define DMAC_CHCR3	((VH *)0x5ffff7e)		/* DMA ͥ뎥ȥ뎥쥸3 */

/* ߥȥ */
#define INTC_IPRA	((VH *)0x5ffff84)	/* ͥ٥쥸 */
#define INTC_IPRB	((VH *)0x5ffff86)	/* ͥ٥쥸 */
#define INTC_IPRC	((VH *)0x5ffff88)	/* ͥ٥쥸 */
#define INTC_IPRD	((VH *)0x5ffff8a)	/* ͥ٥쥸 */
#define INTC_IPRE	((VH *)0x5ffff8c)	/* ͥ٥쥸 */
#define INTC_ICR	((VH *)0x5ffff8e)	/* ߥȥ쥸 */

/* 桼֥졼ȥ */
#define UBC_BARH	((VH *)0x5ffff90)	/* ֥졼ɥ쥹쥸 */
#define UBC_BARL	((VH *)0x5ffff92)	/* ֥졼ɥ쥹쥸 */
#define UBC_BAMRH	((VH *)0x5ffff94)	/* ֥졼ɥ쥹ޥ쥸 */
#define UBC_BAMRL	((VH *)0x5ffff96)	/* ֥졼ɥ쥹ޥ쥸 */
#define UBC_BBR		((VH *)0x5ffff98)	/* ֥졼Х뎥쥸 */

/* Хȥ */
#define BSC_BCR		((VH *)0x5ffffa0)	/* Хȥ뎥쥸 */
#define BSC_WCR1	((VH *)0x5ffffa2)	/* Ȏơ쥸1 */
#define BSC_WCR2	((VH *)0x5ffffa4)	/* Ȏơ쥸2 */
#define BSC_WCR3	((VH *)0x5ffffa6)	/* Ȏơ쥸3 */
#define BSC_DCR		((VH *)0x5ffffa8)	/* DRAM ꥢȥ뎥쥸 */
#define BSC_PCR		((VH *)0x5ffffaa)	/* DRAM ѥƥȥ뎥쥸 */
#define BSC_RCR		((VH *)0x5ffffac)	/* ե쎯厥ȥ뎥쥸 */
#define BSC_RTCSR	((VH *)0x5ffffae)	/* ե쎯ގȥ펰/Ǝ쥸 */
#define BSC_RTCNT	((VH *)0x5ffffb0)	/* ե쎯厥ގ */
#define BSC_RTCOR	((VH *)0x5ffffb2)	/* ե쎯厥ॳ󥹥Ȏ쥸 */

/* ףģ */
#define WDT_TCSR	((VH *)0x5ffffb8)	/* ގȥ롿ơ쥸 */
#define WDT_TCNT	((VH *)0x5ffffb8)	/* ގ󥿡ʎ׎ġ*/
#define WDT_TCNT_R	((VH *)0x5ffffb9)	/* ގ󥿡ʎ؎Ďޡ*/
#define WDT_RSTCSR	((VH *)0x5ffffba)	/* ꥻȎȥ펰/Ǝ쥸ʎ׎ġ*/
#define WDT_RSTCSR_R	((VH *)0x5ffffbb)		/* ꥻȎȥ펰/Ǝ쥸ʎ؎Ďޡ*/

/*  */
#define SYS_SBYCR	((VH *)0x5ffffbc)	/* Хȥ뎥쥸 */

/* ݡȣ */
#define PA_DR		((VH *)0x5ffffc0)	/* ݡȣ ǡ쥸 */
#define PB_DR		((VH *)0x5ffffc2)	/* ݡȣ ǡ쥸 */
#define PC_DR		((VH *)0x5ffffd0)	/* ݡȣ ǡ쥸 */

#define PB_RTS0		(1<<2)  		/* RTS0 üҡPB2*/
#define PB_CTS0		(1<<3)  		/* CTS0 üҡPB3*/
#define PB_TXE1		(1<<5)  		/* TXE1 üҡPB5*/
#define PB_RXD0		(1<<8)  		/* RxD0 üҡPB8*/
#define PB_TXD0		(1<<9)  		/* TxD0 üҡPB9*/
#define PB_RXD1		(1<<10) 		/* RxD1 üҡPB10*/
#define PB_TXD1		(1<<11)			/* TxD1 üҡPB11*/

/* ԥ󎥥ե󥯥󎥥ȥ */
#define PFC_PAIOR	((VH *)0x5ffffc4)	/* ݡȣ ɣϥ쥸 */
#define PFC_PBIOR	((VH *)0x5ffffc6)	/* ݡȣ ɣϥ쥸 */
#define PFC_PACR1	((VH *)0x5ffffc8)	/* ݡȣ ȥ뎥쥸1 */
#define PFC_PACR2	((VH *)0x5ffffca)	/* ݡȣ ȥ뎥쥸2 */
#define PFC_PBCR1	((VH *)0x5ffffcc)	/* ݡȣ ȥ뎥쥸1 */
#define PFC_PBCR2	((VH *)0x5ffffce)	/* ݡȣ ȥ뎥쥸2 */
#define PFC_CASCR	((VH *)0x5ffffee)	/* ॢɥ쥹ȥ펰֎ԥ󎥥Ďێَ쥸 */

/* ԣУ */
#define TPC_TPMR	((VH *)0x5fffff0)	/* TPC ϥ⡼Ɏ쥸 */
#define TPC_TPCR	((VH *)0x5fffff1)	/* TPC ϥȥ뎥쥸 */
#define TPC_NDERB	((VH *)0x5fffff2)	/* ͥȎǡ֥͡뎥쥸 */
#define TPC_NDERA	((VH *)0x5fffff3)	/* ͥȎǡ֥͡뎥쥸 */
#define TPC_NDRB	((VH *)0x5fffff4)	/* ͥȎǡ쥸 */
#define TPC_NDRA	((VH *)0x5fffff5)	/* ͥȎǡ쥸 */
#define TPC_NDRB_2	((VH *)0x5fffff6)	/* ͥȎǡ쥸¡ʽώĎ؎ްۤʤ*/
#define TPC_NDRA_2	((VH *)0x5fffff7)	/* ͥȎǡ쥸ʽώĎ؎ްۤʤ*/

/* ߥ٥ֹ */
#define INT_NMI		11		/* NMI */
#define INT_UB		12		/* 桼֥졼 */
#define INT_IRQ0	64		/* ü IRQ0 */
#define INT_IRQ1	65		/* ü IRQ1 */
#define INT_IRQ2	66		/* ü IRQ2 */
#define INT_IRQ3	67		/* ü IRQ3 */
#define INT_IRQ4	68		/* ü IRQ4 */
#define INT_IRQ5	69		/* ü IRQ5 */
#define INT_IRQ6	70		/* ü IRQ6 */
#define INT_IRQ7	71		/* ü IRQ7 */
#define INT_DEI0	72		/* DMAC ͥ0 */
#define INT_DEI1	74		/* DMAC ͥ1 */
#define INT_DEI2	76		/* DMAC ͥ2 */
#define INT_DEI3	78		/* DMAC ͥ3 */
#define INT_IMIA0	80		/* ITU ͥ0 ڥގ/׎ĥץA0 */
#define INT_IMIB0	81		/* ITU ͥ0 ڥގ/׎ĥץB0 */
#define INT_OVI0	82		/* ITU ͥ0 Хե0 */
#define INT_IMIA1	84		/* ITU ͥ1 ڥގ/׎ĥץA1 */
#define INT_IMIB1	85		/* ITU ͥ1 ڥގ/׎ĥץB1 */
#define INT_OVI1	86		/* ITU ͥ1 Хե1 */
#define INT_IMIA2	88		/* ITU ͥ2 ڥގ/׎ĥץA2 */
#define INT_IMIB2	89		/* ITU ͥ2 ڥގ/׎ĥץB2 */
#define INT_OVI2	90		/* ITU ͥ2 Хե2 */
#define INT_IMIA3	92		/* ITU ͥ3 ڥގ/׎ĥץA3 */
#define INT_IMIB3	93		/* ITU ͥ3 ڥގ/׎ĥץB3 */
#define INT_OVI3	94		/* ITU ͥ3 Хե3 */
#define INT_IMIA4	96		/* ITU ͥ4 ڥގ/׎ĥץA4 */
#define INT_IMIB4	97		/* ITU ͥ4 ڥގ/׎ĥץB4 */
#define INT_OVI4	98		/* ITU ͥ4 Хե4 */
#define INT_ERI0	100		/* SCI ͥ0 顼 */
#define INT_RXI0	101	 	/* SCI ͥ0 λ */
#define INT_TXI0	102		/* SCI ͥ0 ǡץƥ */
#define INT_TEI0	103		/* SCI ͥ0 λ */
#define INT_ERI1	104		/* SCI ͥ1 顼 */
#define INT_RXI1	105		/* SCI ͥ1 λ */
#define INT_TXI1	106		/* SCI ͥ1 ǡץƥ */
#define INT_TEI1	107		/* SCI ͥ1 λ */
#define INT_PEI		108		/* ѥƥ */
#define INT_ADI		109		/* A/D  */
#define INT_ITI		112		/* åɥåޡʥ󥿡Х뎥ޡ*/
#define INT_CMI		113		/* եå女ȥ鎥ڥޥå */

/*
 *  GDB STUBƽФ롼
 */
#ifndef _MACRO_ONLY
#ifdef GDB_STUB

#define zunda_sh1_exit	gdb_stub_exit
#define zunda_sh1_putc	gdb_stub_putc

Inline void
gdb_stub_exit(void)
{
	Asm("trapa #0xff"::);		/*  ̤  */
}

/*
 *  gdb stubˤ
 */
Inline int
gdb_stub_putc(int c)
{
	Asm("mov   #0x00,r0
	     mov   %0,r4
	     trapa #0x21"
               : /* no output */
               : "r"(c)
               : "r0","r4");
	return(c);
}

/*
 *  ROMξ
 */
#else /* GDB_STUB */

Inline void
zunda_sh1_exit(void)
{
	while(1);
}

extern void	sh1sci_putc_pol(char c);	/*  sh1sci2.c  */

Inline void 
zunda_sh1_putc(char c)
{
	sh1sci_putc_pol(c);
}

#endif /* GDB_STUB */
#endif /* _MACRO_ONLY */
#endif /* _ZUNDA_SH1_H_ */
