/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_config.h,v 1.18 2005/11/14 08:00:44 honda Exp $
 */

/*
 *	ץå¸⥸塼SH1ѡ
 *ͥǻѤ
 *ǡޥؿΥץȥ
 *
 *  Υ󥯥롼ɥեϡt_config.h Τߤ饤󥯥롼ɤ롥
 *  ¾Υե뤫ľܥ󥯥롼ɤƤϤʤʤ
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

/*
 *  ͥ̾Υ͡
 */
#include <cpu_rename.h>

/*
 *  SH1ץå쥸
 */
#include <sh1.h>

/*
 *  ͥǡʸѥޥ
 */
#include <util.h>

/*
 *  桼
 */
#include <user_config.h>

/*
 *  ǽʺǹͥ
 */
#ifdef GDB_STUB
#define MAX_IPM  0xe	/* ֤ξͥ14CPUå   */
#else
#define MAX_IPM  0xf	/* ֤ʤξϺǹͥ٤CPUå */
#endif /*  GDB_STUB  */

#define str_MAX_IPM  		TO_STRING(MAX_IPM)

/*
 *  ץåü̿Υ饤ؿ
 */
#ifndef _MACRO_ONLY
#include <cpu_insn.h>
#endif /* _MACRO_ONLY */

/*
 *  TCB ΥեɤΥӥå
 *
 *  cpu_context.h 쥬ȤȤΰ¸δطǡ
 *  cpu_context.h ˤʤ
 */
#define	TBIT_TCB_TSTAT		8	/* tstat եɤΥӥå */
#define	TBIT_TCB_PRIORITY	8	/* priority եɤΥӥå */

#ifndef _MACRO_ONLY
/*
 *  ƥȥ֥å
 *  
 *  spUW *ȤƤΤ4ХȶռƤ뤿
 *  
 */
typedef struct task_context_block {
        UW 	*sp;            /* åݥ */
        FP	pc;             /* ץ५ */
} CTXB;

/*
 *  ߥޥ饤֥
 *
 *  ߥޥintmaskˤϡIPMInterrupt Priority Maskˤ4ӥå
 *  ˥եȤΤǤ롥
 */

/*
 *  ߤγߥޥɽФ
 */
Inline UW
current_intmask(void)
{
	return(current_sr() & 0x000000f0u);
}

/*
 *  ߥޥ
 */
Inline void
set_intmask(UW intmask)
{
	set_sr((current_sr() & ~0x000000f0u) | intmask);
}


/*
 *  ߡCPU㳰ͥȥ
 */
extern UW	intnest;

/*
 *  ƥֻ
 */


/*
 *  ƥȻ
 *
 *  ߥͥȥ󥿤ɤ߽Фľ˳ߤȯƤ⡢
 *  äȤˤϥƥȤ⸵äƤ
 */
Inline BOOL
sense_context(void)
{
	return(intnest > 0);
}

Inline BOOL
sense_lock(void)
{
	return(current_intmask() == (MAX_IPM << 4));
}

#define t_sense_lock	sense_lock
#define i_sense_lock	sense_lock

/*
 *  CPUåȤβʥƥѡ
 *
 *  task_intmask ϡchg_ipm 򥵥ݡȤ뤿ѿchg_ipm 򥵥ݡ
 *  Ȥʤˤϡtask_intmask  0 ˤʤäƤȹͤФ褤
 */

#ifdef SUPPORT_CHG_IPM
extern UW	task_intmask;	/* ƥȤǤγߥޥ */
#endif /* SUPPORT_CHG_IPM */

Inline void
t_lock_cpu(viod)
{
	disint();		/*  cpu_insn.h  */
}

Inline void
t_unlock_cpu(void)
{
#ifdef SUPPORT_CHG_IPM
	/*
	 *  t_unlock_cpu ƤӽФΤ CPUå֤ΤߤǤ뤿
	 *  ᡤ task_intmask 񤭴뤳ȤϤʤ
	 */
	set_intmask(task_intmask);
#else /* SUPPORT_CHG_IPM */
	enaint();		/*  cpu_insn.h  */
#endif /* SUPPORT_CHG_IPM */
}

/*
 *  CPUåȤβ󥿥ƥѡ
 */

extern UW	int_intmask;	/* 󥿥ƥȤǤγߥޥ */

Inline void
i_lock_cpu(void)
{
	UW	intmask;

	/*
	 *  ѿ intmask ȤäƤΤϡcurrent_intmask() 
	 *  ľ˳ߤȯư줿ߥϥɥ
	 *  int_intmask ѹǽ뤿Ǥ롥
	 */
	intmask = current_intmask();
	disint();
	int_intmask = intmask;
}

Inline void
i_unlock_cpu(void)
{
	set_intmask(int_intmask);
}

/*
 *  ǥѥå
 */

/*
 *  ǹ̥ͥؤΥǥѥåcpu_support.S
 *
 *  dispatch ϡƥȤƤӽФ줿ӥ
 *  ǡCPUå֤ǸƤӽФʤФʤʤ
 */
extern void	dispatch(void);

/*
 *  ߤΥƥȤΤƤƥǥѥåcpu_support.S
 *
 *  exit_and_dispatch ϡCPUå֤ǸƤӽФʤФʤʤ
 */
extern void	exit_and_dispatch(void);

#endif /* _MACRO_ONLY */

/*
 *  ߥϥɥ顿CPU㳰ϥɥ
 */

/*
 *  㳰٥ơ֥
 *  ޥ
 *  KERNEL_HAS_A_VECTOR_TABLE
 *  ͥ뤬㳰٥ơ֥
 *  SIO_RESERVED
 *  ꥢǥХǥХåˤäƻѤƤ
 */
#ifndef _MACRO_ONLY

#ifdef KERNEL_HAS_A_VECTOR_TABLE
extern FP vector_table[];	/*  㳰٥ơ֥  */
#endif /* KERNEL_HAS_A_VECTOR_TABLE */


/*
 *  ߥϥɥ
 *
 *  ٥ȥֹ inhno γߥϥɥεưϤ inthdr ꤹ롥
 */
Inline void
define_inh(INHNO inhno, FP inthdr)
{
#ifdef GDB_STUB
	/*  ָƤӽФ  */
	Asm("mov   #0x08,r0;	\
	     mov   %0,r4;	\
	     mov   %1,r5;	\
	     trapa #0x21"
               : /* no output */
               : "r"(inhno),"r"(inthdr)
               : "r0","r4","r5");

#else	/*  GDB_STUB  */

#ifdef KERNEL_HAS_A_VECTOR_TABLE

#ifdef SIO_RESERVED	/*  ꥢߤ򤱤  */
	if ((inhno != RXI0) && (inhno != TXI0))
#endif /* SIO_RESERVED */
		vector_table[inhno] = inthdr;

#endif /* KERNEL_HAS_A_VECTOR_TABLE */

#endif	/*  GDB_STUB  */
}

/*
 *  CPU㳰ϥɥ
 *
 *  ٥ȥֹ excno CPU㳰ϥɥεưϤ exchdr ꤹ롥
 */
extern void define_exc(EXCNO excno, FP exchdr)  throw();


/*
 *  ߥϥɥ顿CPU㳰ϥɥ
 */

/*  C롼δؿ̾Υ٥  
 *     kernel_cfg.cǻ
 */
#define	INT_ENTRY(inthdr)	_kernel_##inthdr##_entry
#define	EXC_ENTRY(exchdr)	_kernel_##exchdr##_entry

/*
 *  ߥϥɥ顿CPU㳰ϥɥζʬ
 *
 *	SH1ǤϡߤCPU㳰ΰۤȤƱʤΤǡ
 *	Υޥⶦ̤Ƥ
 *
 *
 *	labelΥ٥
 *	inthdrC롼Ƭɥ쥹
 *	common_routinecpu_support.Sʬ襢ɥ쥹
 *			interrupt_entryߤξ
 *			cpu_exception_entryCPU㳰ξ
 *
 *쥸
 *r1߼ľSRΥԡ
 *r0interrupt_entry
 *r2C롼Ƭɥ쥹
 *
 *	ߤCPU㳰
 *	CPU㳰ϥɥ˰Ϳ
 *	CPU㳰Ǥϡ㳰ȯIPMƱͤǳߤĤ
 *		CPU㳰ˤꡢIPMѲʤ
 *
 *	ߥϥɥξ				
 *	  	߼ջ˥ϡɥIPMꤹ	
 *	  	ߵĤˤϤIPMͤѤ		
 *	CPU㳰ϥɥξ				
 *	  	CPU㳰ջIPMͤѲʤ		
 *	  	ߵĤˤCPU㳰ȯIPMͤѤ	
 */
#define	HANDLER_ENTRY_PROC(label, handler, common_routine)		   \
asm(".text;								  "\
"	.align 2;							  "\
"	.global _"#label";						  "\
"_"#label":;								  "\
			/*  ɬ׺Ǿ¤Υ쥸򥹥å  */	   \
"	mov.l	r0,@-r15;						  "\
"	mov.l	r1,@-r15;						  "\
				/*  ߶ػߤSRν  		*/ \
"	stc	sr,r1;							  "\
	/*  ߶ػ  						*/ \
	/*     ߤػߤ̤γߤä 	*/ \
	/*     cpu_suppourt.Sret_int򻲾 				*/ \
"	mov.l	_mask_ipm_"#handler",r0;				  "\
"	ldc	r0,sr;							  "\
"	mov.l	r2,@-r15;						  "\
"	mov.l	_common_routine_"#handler",r0;				  "\
"	mov.l	_c_routine_"#handler",r2;" /* C롼Ƭɥ쥹*/\
"	jmp	@r0;		"/*  interrupt_entryإ 		*/ \
"	nop;				"	/*  ٱ䥹å  	*/ \
	/*  							*/ \
	/* ٱ䥹åȤPCХɥå󥰤Υ̿ 		*/ \
	/* ȸư롣 					*/ \
	/*  ʥå̿㳰ȯʤΤȯ񤷤 	*/ \
									   \
"	.align 2;							  "\
"_mask_ipm_"#handler":;	    "	/*  ߶ػѥޥ  		*/ \
"	.long  "str_MAX_IPM" << 4; "	/*  ipmʳΥӥåȤϥɤ	*/ \
"_c_routine_"#handler":;	    					  "\
"	.long  _"#handler";   "	/* C롼Ƭɥ쥹  	*/ \
"_common_routine_"#handler":; "	/* cpu_support.Sʬ襢ɥ쥹	*/ \
"	.long  __kernel_"#common_routine"; "		  		   \
)

/*
 *  ߥϥɥޥ
 *
 */
#define INTHDR_ENTRY(inthdr)	INTHDR_ENTRY2(INT_ENTRY(inthdr), inthdr)

#define INTHDR_ENTRY2(entry, inthdr)					\
	extern void entry(void);					\
	HANDLER_ENTRY_PROC(entry, inthdr, interrupt_entry)


/*
 *  CPU㳰ϥɥޥ
 */
#define	EXCHDR_ENTRY(exchdr)	EXCHDR_ENTRY2(EXC_ENTRY(exchdr), exchdr)

#define EXCHDR_ENTRY2(entry, exchdr)					\
	extern void entry(void);					\
	HANDLER_ENTRY_PROC(entry, exchdr, cpu_exception_entry)
	/*
	 *  void entry()ñʤ륨ȥΥ٥ʤΤǡ
	 *  դʤ
	 */

/*
 *  CPU㳰ȯΥƥ֤λ
 */

/*
 *  CPU㳰ȯΥƥȤλ
 */
Inline BOOL
exc_sense_context(VP p_excinf)
{
	/* 
	 *  ӤΤϡ߼¹CPU㳰ʬ
	 *  ߥͥȥ󥿤󥯥ȤƤ뤿 	
	 *  
	 *  CPU㳰̤CPU㳰ȯʤȲ
	 *  Ƥ
	 */
	return(intnest > 1);
}

/*
 *  CPU㳰ȯCPUå֤λ
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
	UW sr = *(UW *)p_excinf; 
	return((sr& 0x00000f0u) == (MAX_IPM << 4));
}

/*
 *  ץå¸ν
 */
extern void	cpu_initialize(void);

/*
 *  ץå¸νλ
 */
extern void	cpu_terminate(void);


/*
 *  ΥϻΥå¤
 */
typedef struct exc_stack {
	VW	r0;
	VW	r1;
	VW	r2;
	VW	r3;
	VW	r4;
	VW	r5;
	VW	r6;
	VW	r7;
	VW	r8;
	VW	r9;
	VW	r10;
	VW	r11;
	VW	r12;
	VW	r13;
	VW	r14;
	VW	r15;
	VW	pr;	/*  ץ㡦쥸  	*/
	VW	pc;	/*  ץࡦ  	*/
	VW	sr;	/*  ơ쥸  	*/
} EXCSTACK;


/*
 * 㳰ȯΥ (cpu_config.c, cpu_support.S)
 */
extern void     cpu_experr(EXCSTACK *);

#endif /* _MACRO_ONLY */


/*
 *  㳰٥ꤹǥեȤ
 *  	ʲ㳰װǥǥեȤȤϰۤʤ㳰٥
 *	ϡsys_config.hǳޥ롣
 */
#define RESET_VECTOR 	start		/*  ꥻåȥ٥  */
#define INIT_STACK  	STACKTOP	/*  åݥ󥿤ν  */

#define RESERVED_VECTOR	RESET_VECTOR	/*  ƥͽΥꥻåȥ٥  */
					/*  ºݤˤϻѤʤ  */

#ifndef GII_VECTOR	/*  ̿  */
#define GII_VECTOR	RESET_VECTOR
#endif /* GII_VECTOR */

#ifndef SII_VECTOR	/*  å̿  */
#define SII_VECTOR	RESET_VECTOR
#endif /* SII_VECTOR */

#ifndef CAE_VECTOR	/*  CPUɥ쥹顼  */
#define CAE_VECTOR	RESET_VECTOR
#endif /* CAE_VECTOR */

#ifndef DAE_VECTOR	/*  DMAɥ쥹顼  */
#define DAE_VECTOR	RESET_VECTOR
#endif /* DAE_VECTOR */

#ifndef NMI_VECTOR	/*  NMI  */
#define NMI_VECTOR	RESET_VECTOR
#endif /* NMI_VECTOR */


#endif /* _CPU_CONFIG_H_ */
