/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  Copyright (C) 2004 by SEIKO EPSON Corp, JAPAN
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 */

/*
 *  ץå˰¸(S1C33)
 */

#ifndef _CPU_DEFS_H_
#define _CPU_DEFS_H_

#define S1C33

/*
 *  CPU ΥХȽ˴ؤ
 */

#define SIL_ENDIAN		SIL_ENDIAN_LITTLE

#ifndef _MACRO_ONLY

typedef UINT	INHNO;		/* ߥϥɥֹ	*/
typedef UINT	EXCNO;		/* CPU㳰ϥɥֹ	*/
typedef UINT	ILEVNO;		/* ߥ٥		*/

/*
 *  ߥ٥ѹ
 */
extern	ER	chg_ilv(ILEVNO ilevno);
extern	ER	get_ilv(ILEVNO *p_ilevno);

/*
 *  ߵġػ߽
 */
typedef UINT	INTNO;		/* ֹ		*/

/*
 *  ¸طˤꤳǥ͡
 */
#define ena_int		_kernel_ena_int
#define dis_int		_kernel_dis_int

#ifdef LABEL_ASM
#define _ena_int	__kernel_ena_int
#define _dis_int	__kernel_dis_int
#endif /* LABEL_ASM */

extern	ER	ena_int(INTNO intno);
extern	ER	dis_int(INTNO intno);

/*
 *  ߤγߵĥե饰ɽФ
 */
Inline UW
_current_intflag_(void)
{
	UW	psr;

	Asm("ld.w %0, %%psr" : "=r"(psr));
	return(psr & 0x00000010);
}

/*
 *  NMI٤Ƥγߤػ
 */
Inline void
_disint_(void)
{
	UW	psr;

	Asm("ld.w %0, %%psr" : "=r"(psr));
	psr &= 0xffffffef;
	Asm("ld.w %%psr, %0" : : "r"(psr));
}

/*
 *  ߵĥե饰
 */
Inline void
_enaint_(UW intmask)
{
	UW	psr;

	Asm("ld.w %0, %%psr" : "=r"(psr));
	psr |= intmask;
	Asm("ld.w %%psr, %0" : : "r"(psr));
}

/*
 *  ߥå֤
 */
#define SIL_PRE_LOC	UW _intmask_ = _current_intflag_()
#define SIL_LOC_INT()	_disint_()
#define SIL_UNL_INT()	_enaint_(_intmask_)

#define OMIT_VGET_TIM

typedef	UW  SYSUTIM;		/* ǽɾѥƥ */

extern ER	vxget_tim(SYSUTIM *p_sysutim) throw();

/*
 *  ƥǽ
 */

Inline void
kernel_abort (void)
{
	while (1){
		;
	}
}

#endif /* _MACRO_ONLY */
#endif /* _CPU_DEFS_H_ */
