/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2005 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN    
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: nios2.c,v 1.6 2005/07/17 14:24:04 honda Exp $
 */

/*
 * Nios2 ɸڥեѥɥ饤
 */
#include <s_services.h>
#include <nios2.h>


/*
 * UART  ʰץɥ饤
 */

/*                                                                       
 * ꥢI/OݡȽ֥å                                         
 */
const SIOPINIB siopinib_table[TNUM_SIOP] = {{}};

/*                                                                      
 *  ꥢI/Oݡȴ֥åΥꥢ                                
 */
SIOPCB  siopcb_table[TNUM_SIOP];

/*                                                                          
 *  ꥢI/OݡID֥åФΥޥ                  
 */
#define INDEX_SIOP(siopid)  ((UINT)((siopid) - 1))
#define get_siopcb(siopid)  (&(siopcb_table[INDEX_SIOP(siopid)]))

#ifdef USE_JTAG_UART
/*
 *  JTAG_UART ϥơȥǡƱ˼뤿ᡤơ
 *  åȥǡɤ߹ǤޤΤᡤuart_getready()
 *  ¹ԤΥǡ롥  
 */ 
UB jtag_uart_buf = -1;
#endif /* USE_JTAG_UART */

/*
 * ʸ?                                                       
 */
Inline BOOL
uart_getready(SIOPCB *siopcb)
{
#ifndef USE_JTAG_UART
	return((sil_rew_mem((VP)UART_STATUS) &
			UART_STATUS_RRDY) != 0);
#else
	UW tmp = sil_rew_mem((VP)JTAG_UART_DATA);
	jtag_uart_buf = (UB)tmp;	
	return ((tmp & JTAG_UART_DATA_RVALID) != 0);
#endif /* USE_JTAG_UART	*/	
}

/*                                                                             
 * ʸǤ뤫?                                                         
 */
Inline BOOL
uart_putready(SIOPCB *siopcb)
{
#ifndef USE_JTAG_UART		
	return((sil_rew_mem((VP)UART_STATUS) & UART_STATUS_TRDY) != 0);
#else
	return((sil_rew_mem(
		(VP)JTAG_UART_CONTROL) & JTAG_UART_CONTROL_WSAPCE) > 0);
#endif /* USE_JTAG_UART	*/
}

/*                                                                             
 *  ʸμФ                                                     
 */
Inline UB
uart_getchar(SIOPCB *siopcb)
{
#ifndef USE_JTAG_UART
	return((UB)(sil_rew_mem((VP)UART_RXDATA)));
#else
	return((UB)(sil_rew_mem((VP)JTAG_UART_DATA)));
#endif /* USE_JTAG_UART	*/
}

/*                                                                            
 *  ʸν񤭹                                                    
 */
Inline void
uart_putchar(SIOPCB *siopcb, UB c)
{
#ifndef USE_JTAG_UART
	sil_wrw_mem((VP)UART_TXDATA, c);
#else
	sil_wrw_mem((VP)JTAG_UART_DATA,c);
#endif /* USE_JTAG_UART	*/
}

/*
 * ؿ
 */
/*                                                                             
 *  ߵ                                                             
 */
Inline void
uart_enable_send(SIOPCB *siopcb)
{
#ifndef USE_JTAG_UART
	sil_wrw_mem((VP)UART_CONTROL,
				sil_rew_mem((VP)UART_CONTROL)|UART_CONTROL_ITRD);
#else
	sil_wrw_mem((VP)JTAG_UART_CONTROL,
				sil_rew_mem((VP)JTAG_UART_CONTROL)|JTAG_UART_CONTROL_WIE);
#endif /* USE_JTAG_UART	*/	
}

/*                                                                             
 *  ߶ػ                                                             
 */
Inline void
uart_disable_send(SIOPCB *siopcb)
{
#ifndef USE_JTAG_UART
	sil_wrw_mem((VP)UART_CONTROL,
				sil_rew_mem((VP)UART_CONTROL)&~UART_CONTROL_ITRD);
#else
	sil_wrw_mem((VP)JTAG_UART_CONTROL,
				sil_rew_mem((VP)JTAG_UART_CONTROL)&~JTAG_UART_CONTROL_WIE);
#endif /* USE_JTAG_UART	*/
}

/*
 * ؿ
 */
/*                                                                             
 *  ߵ                                                             
 */
Inline void
uart_enable_rcv(SIOPCB *siopcb)
{
#ifndef USE_JTAG_UART
	sil_wrw_mem((VP)UART_CONTROL,
				sil_rew_mem((VP)UART_CONTROL)|UART_STATUS_RRDY);
#else
	sil_wrw_mem((VP)JTAG_UART_CONTROL,
				sil_rew_mem((VP)JTAG_UART_CONTROL)|JTAG_UART_CONTROL_RIE);
#endif /* USE_JTAG_UART	*/
}

/*                                                                             
 *  ߶ػ                                                             
 */
Inline void
uart_disable_rcv(SIOPCB *siopcb)
{
#ifndef USE_JTAG_UART	
	sil_wrw_mem((VP)UART_CONTROL,
				sil_rew_mem((VP)UART_CONTROL)&~UART_STATUS_RRDY);
#else
	sil_wrw_mem((VP)JTAG_UART_CONTROL,
				sil_rew_mem((VP)JTAG_UART_CONTROL)&~JTAG_UART_CONTROL_RIE);
#endif /* USE_JTAG_UART	*/	
}


/*                                                                             
 *  SIOɥ饤Фν롼                                                
 *  1ݡȤʤᡤޤ̣Ϥʤ                                      
 */
void
uart_initialize()
{
    SIOPCB  *siopcb;
    UINT    i;

    /*                                                                         
     *  ꥢI/Oݡȴ֥åν                                  
     */
    for (siopcb = siopcb_table, i = 0; i < TNUM_SIOP; siopcb++, i++) {
        siopcb->siopinib = &(siopinib_table[i]);
        siopcb->openflag = FALSE;
        siopcb->sendflag = FALSE;
    }
}


SIOPCB   *
uart_opn_por(ID siopid, VP_INT exinf){

    SIOPCB      *siopcb;
    const SIOPINIB  *siopinib;

    siopcb = get_siopcb(siopid);
    siopinib = siopcb->siopinib;

#ifndef USE_JTAG_UART		
//    sil_wrw_mem(UART_DIVISOR, UART_DIVISOR_VAL);
    sil_wrw_mem((VP)UART_STATUS, 0x00);
    
    /*
     *  ߵ
     */
    sil_wrw_mem((VP)UART_CONTROL, UART_STATUS_RRDY);
#else
	sil_wrw_mem((VP)JTAG_UART_CONTROL,JTAG_UART_CONTROL_RIE);
#endif /* USE_JTAG_UART	*/
	
    siopcb->exinf = exinf;
    siopcb->getready = siopcb->putready = FALSE;
    siopcb->openflag = TRUE;

    return(siopcb);
}


void
uart_cls_por(SIOPCB *siopcb){
#ifndef USE_JTAG_UART	
    /* ߶ػ */
    sil_wrw_mem((VP)UART_CONTROL, 0x00);
#else
	sil_wrw_mem((VP)JTAG_UART_CONTROL,0x00);
#endif /* USE_JTAG_UART	*/		
    siopcb->openflag = FALSE;
    siopcb->sendflag = FALSE;
}



/*                                                                             
 *  ꥢI/OݡȤؤʸ                                            
 */
BOOL
uart_snd_chr(SIOPCB *siopcb, INT chr)
{
    if(uart_putready(siopcb)){
        uart_putchar(siopcb, (UB) chr);
        return(TRUE);
    }
    return(FALSE);
}

/*
 *  ꥢI/OݡȤʸ
 */
INT
uart_rcv_chr(SIOPCB *siopcb)
{
#ifndef USE_JTAG_UART
	if (uart_getready(siopcb)) {
		return((INT)(UB) uart_getchar(siopcb));
	}
	return(-1);
#else
	UB tmp;
	
	if (jtag_uart_buf != -1) {
		tmp = jtag_uart_buf;
		jtag_uart_buf = -1;
		return tmp;
	}
	return(-1);
#endif /* USE_JTAG_UART	*/	
}


/*
 *  ꥢI/OݡȤΥХåε
 */
void
uart_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{
    switch (cbrtn) {
      case SIO_ERDY_SND:
        uart_enable_send(siopcb);
        break;
      case SIO_ERDY_RCV:
        uart_enable_rcv(siopcb);
        break;
    }

}


/*
 *  ꥢI/OݡȤΥХåζػ
 */
void
uart_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{
    switch (cbrtn) {
      case SIO_ERDY_SND:
        uart_disable_send(siopcb);
        break;
      case SIO_ERDY_RCV:
        uart_disable_rcv(siopcb);
        break;
    }
}


/*                                                                            
 *  ꥢI/OݡȤФ߽                                       
 */
static void
uart_isr_siop(SIOPCB *siopcb)
{
    if (uart_getready(siopcb)) {
        /*
         *  ΥХå롼ƤӽФ
         */
        uart_ierdy_rcv(siopcb->exinf);
    }

    if (uart_putready(siopcb)) {
        /*
         *  ǽХå롼ƤӽФ
         */
        uart_ierdy_snd(siopcb->exinf);
    }
}


/*                                                                             
 *  SIOγߥӥ롼                                                
 */
void
uart_isr()
{
    if (siopcb_table[0].openflag) {
        uart_isr_siop(&(siopcb_table[0]));
    }
}

