/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#ifndef _KZ_VR4131PCI_01_
#define _KZ_VR4131PCI_01_

#define KZ_VR4131PCI_01

/*
 *  ǥХγƥ١ɥ쥹
 */

#define VR4131_BASE_ADDR	0xa0000000

/*
 *  ǥХ˶뤵륯å
 */
/*
 *  VR4131 ϵư CLKSEL(2:0) üҤ򸫤ơѥץ饤󥯥åPClock
 *  ꤹ롣ΥåȥܡɤΥǥեȤϡ
 *        CLKSEL(2:0) = 110
 *  ѥޥͥȥ˥åȤΡPMUTCLKDIVREGѹϲäʤ᲼Ȥʤ롣
 *        PClock 199.1[MHz], VTClock 33.2[MHz], TClock 16.6[MHz]
 */
/* ꥢ˶뤵륯åȿ [Hz]ʥܡ졼ǻѡ
 * 18.432MHz = 18432000 Hz ; ϡɥp193ȡ */
#define XIN_CLOCK	18432000u	/* [Hz] */

/* ޤ˶뤵륯åȿ [kHz]TO_CLOCKǻѡ
 * TO_CLOCK 1ߥü(1kHz)ȯ뤿˻ѡ
 * VTClock=33.2MHz = 33200kHz ; ϡɥp22ȡ */
#define TIMER_CLOCK	33200u	/* [kHz] */

/*
 *  ǥХγߥޥ
 *
 *  ͥ : () DSIU -> TClock -> Хåƥ­ ()
 */
/* MSYSINT1  BATINTR ˤĤƤϡϡɥp224  */

/*
 *  DSIU ߤγߥޥѡ
 *  ߥ٥Ʊ٥ꤷƤ
 */
#define CORE_IPM_DSIU		INIT_CORE_IPM	/* MIPS3(SR)ѥǡ */

/* BATINTRTCLKINTR ߤΤߤĤ롣 */
#define ICU_IPM_SYSINT1_DSIU	BATINTR		/* ߥȥѥǡ */
#define ICU_IPM_SYSINT2_DSIU	TCLKINTR

/*  ꤹߥޥIPMǵҤ */
#define IPM_DSIU	{ CORE_IPM_DSIU, {ICU_IPM_SYSINT1_DSIU, ICU_IPM_SYSINT2_DSIU} }

/*
 *  RTC Ϣγߥޥ
 */
#define CORE_IPM_TIMER		INIT_CORE_IPM	/* MIPS3(SR)ѥǡ */

/* BATINTR ߤΤߤĤ롣 */
#define ICU_IPM_SYSINT1_TCLK	BATINTR		/* ߥȥѥǡ */
#define ICU_IPM_SYSINT2_TCLK	0u

/*  ꤹߥޥIPMǵҤ */
#define IPM_TIMER	{ CORE_IPM_TIMER, {ICU_IPM_SYSINT1_TCLK, ICU_IPM_SYSINT2_TCLK} }

#endif /* _KZ_VR4131PCI_01_ */
