/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: start.S,v 1.9 2004/02/05 09:16:25 honda Exp $
 */

#define _MACRO_ONLY
#include <microblaze_asm.inc>
#include <t_config.h>
#include <sys_defs.h>
/*
 *  # 0x00 #		Imm instr for reset address     [Hi halfword]
 *  # 0x04 #		Jump to _start                  [Lo halfword]
 *  # 0x08 #		Imm instr for exception address [Hi halfword]
 *  # 0x0c #		Jump to Exception handler       [Lo halfword]
 *  # 0x10 #		Imm instr for interrupt address [Hi halfword]
 *  # 0x14 #		Jump to interrupt handler       [Lo halfword]
 */

        
	.text
	.global _start
	.align  2
    .ent _start
_start:
    /*
     *  msr
     */
    la   r1, r0, MSR_CACHE_SETTING         
    mts  rmsr,r1 
                
    /*
     *  opb_mdm Ȥ msr BIPӥåȤ'1'Ǽ¹Ԥ뤿ᡤ
     *  rtbd̿ˤ'0'˽롥
     *  stub ȤɬפʤäѤʤᡤ̵˼¹Ԥ롥
     */
    la    r1, r0, _start_
    rtbd  r1,0
_start_:        
               
    /*
     * R2R3
     *R2  : Read-only small data area anchor
     *   _SDA2_BASE_ .sdata2濴
     *R13 : Read-write small data area anchor
     *   .sdatasbssϢ³֤֤_SDA_BASE_ ꤹ
     */
	la	r13, r0, _SDA_BASE_
	la	r2,  r0, _SDA2_BASE_

	/*
	 * åݥ󥿤ν
	 */
	la	r1, r0, STACKTOP - 4

   /*
	* ٥ơ֥ν
	*/
	/*
     *  brai ̿ν񤭹
     */
	la  r3,  r0,  0xb8080000  /* brai Υڥ      */
	swi r3,  r0,  0xc         /* exception٥Ͽ  */
	swi r3,  r0,  0x14        /* interrrupt٥Ͽ */
	/*
     * imm ̿ν񤭹
     */
	la  r4,  r0,  0xb0000000  /* imm Υڥ       */
	swi r4,  r0,  0x8         /* exception٥Ͽ  */
    swi r4,  r0,  0x10        /* interrrupt٥Ͽ */

	/*
     *  㳰ϥɥϿ
     */
	la   r5,  r0,  exception_entry
	sw	 r5,  r1,  r0
	lhu  r6,  r1,  r0
	shi	 r5,  r0,  0xe       /* ߥϥɥ鲼16bit */
	shi	 r6,  r0,  0xa       /* ߥϥɥ16bit */

	/*
	 *  ߥϥɥϿ
	 */
	la   r5,  r0,  interrupt_entry
	sw	 r5,  r1,  r0
	lhu  r6,  r1,  r0
	shi	 r5,  r0,  0x16      /* ߥϥɥ鲼16bit */
	shi	 r6,  r0,  0x12      /* ߥϥɥ16bit */


	/*
	 *  _hardware_init_hook ƤӽФ(0Ǥʤ)
	 *
	 *  ϡɥ¸ɬפʽϡ
	 *  hardware_init_hook ȤؿѰդФ褤
	 *  ŪˤROMκݡRAMѲǽˤ뤿
	 *  ХȥνԤ
	 *  sys_support.S  _hardware_init_hook Ƥ
	 *  롥
	 */
start_0:
	la    r3,  r0,  _hardware_init_hook
	beqi  r3,  start_1
	brald r15, r3
	nop


	/*
     *  bss򥯥ꥢ
     */
start_1:
	la    r3,  r0,  __bss_start
	la    r4,  r0,  _end
	sub   r5,  r4,  r3
	beqi  r5,  start_3
start_2:
	sb    r0,  r0,  r3
	addi  r3,  r3,  1
	sub   r5,  r4,  r3
	bgti  r5,  start_2

	/*
	 *  dataνROMб
	 *
	 *  __idata_start  __idata_end ޤǤ__data_start ʹߤ
	 *  ԡ롥
     *  Microblaze¡RAMȤȡBRAMƤ
     *  ꥳե졼󤹤Ƚ뤿
     *  dataνϹԤʤ
     *  ˤäƤϼ뤳Ȥͤƥ٥ΤƤ
	 */
start_3:
	la    r3,  r0,  __idata_start
	la    r4,  r0,  __idata_end
	sub   r5,  r4,  r3     /* å */
	beqi  r5,  start_5
	la    r6,  r0,  __data_start
start_4:
	lbu   r7,  r0,  r3
    sb    r7,  r0,  r6
	addi  r3,  r3,  1
	addi  r6,  r6,  1
	sub   r5,  r4,  r3
	bgti  r5,  start_4


start_5:
	la    r3,  r0,  __isdata2_start
	la    r4,  r0,  __isdata2_end
	sub   r5,  r4,  r3     /* å */
	beqi  r5,  start_7
	la    r6,  r0,  __sdata2_start
start_6:
	lbu   r7,  r0,  r3
    sb    r7,  r0,  r6
	addi  r3,  r3,  1
	addi  r6,  r6,  1
	sub   r5,  r4,  r3
	bgti  r5,  start_6


start_7:
	la    r3,  r0,  __isdata_start
	la    r4,  r0,  __isdata_end
	sub   r5,  r4,  r3     /* å */
	beqi  r5,  start_9
	la    r6,  r0,  __sdata_start
start_8:
	lbu   r7,  r0,  r3
    sb    r7,  r0,  r6
	addi  r3,  r3,  1
	addi  r6,  r6,  1
	sub   r5,  r4,  r3
	bgti  r5,  start_8


	/*
	 *  _software_init_hook ƤӽФ0 Ǥʤˡ
	 *
	 *  եȥĶä˥饤֥ˤ˰¸ɬפʽ
	 *  ϡsoftware_init_hook ȤؿѰդ
	 *  褤
	 */
start_9:
	la    r3,  r0,  _software_init_hook
	beqi  r3,  start_10
	brald r15, r3
	nop

start_10:
	brlid	r15, kernel_start
    addik r1,r1,4            /* å򸵤᤹ */
