/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_defs.h,v 1.10 2005/07/27 10:38:55 honda Exp $
 */

/*
 *  ץå˰¸Microblazeѡ
 *
 *  Υ󥯥롼ɥեϡkernel.h  sil.h ǥ󥯥롼ɤ롥
 *  ¾Υե뤫ľܥ󥯥롼ɤ뤳ȤϤʤΥե򥤥
 *  롼ɤˡt_stddef.h  itron.h 󥯥롼ɤΤǡ
 *  ˰¸Ƥ褤
 */

#ifndef _CPU_DEFS_H_
#define _CPU_DEFS_H_

//#include "microblaze.h"

#ifndef MICROBLAZE
#define MICROBLAZE   /* ץåά */
#endif 
/*
 *  ץå˰¸
 */
#ifndef _MACRO_ONLY

typedef	UINT		INHNO;		/* ߥϥɥֹ */
typedef	UINT		IPM;		/* ߥޥ */
typedef	UINT		EXCNO;		/* CPU㳰ϥɥֹ */


/*
 *  INTNOȳߤζػ/
 */

typedef	UINT		INTNO;		/* ֹ */

extern ER	dis_int(INTNO intno) throw(); 
extern ER	ena_int(INTNO intno) throw();


/*
 *  åȥƥ¸Υӥ
 */
typedef	UW  SYSUTIM;	/* ǽɾѥƥ */
extern  ER   vxget_tim(SYSUTIM *pk_sysutim) throw();


/*
 *  MSRΥӥå
 */
#define MSR_IE 0x02
#define MSR_BE 0x01


/*
 *  ٤Ƥγߤػ
 */
Inline void
_disint_()
{
    UW msr;
  
    Asm("mfs %0,rmsr": "=r"(msr));
    msr &= ~MSR_IE;
    Asm("mts rmsr,%0" : : "r"(msr));
}


/*
 *  ߤ
 */
Inline void
_enaint_()
{
    UW msr;
    
    Asm("mfs %0,rmsr": "=r"(msr));
    msr |= MSR_IE;
    Asm("mts rmsr,%0" : : "r"(msr));    
}


/*
 *  ߥå֤
 */
#define SIL_PRE_LOC 
#define SIL_LOC_INT()   _disint_()
#define SIL_UNL_INT()   _enaint_()

/*
 * ƥǽ
 */
Inline void
kernel_abort()
{
    Asm("brki r16 0x20");
}

/*
 *  Ԥ
 */
Inline void
sil_dly_nse(UINT dlytim)
{
    Asm("add r5, r0, %0; \
         brlid r15, _sil_dly_nse; \
         nop\n"
        : 
        : "r"(dlytim)
        : "r15", "r5");
    
}


#endif /* _MACRO_ONLY */

/*
 *  ץåΥǥ
 */
#define SIL_ENDIAN  SIL_ENDIAN_BIG  /* ӥåǥ */


#endif /* _CPU_DEFS_H_ */
