/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_config.h,v 1.14 2003/07/08 14:57:12 hiro Exp $
 */

/*
 *	ץå¸⥸塼M68040ѡ
 *
 *  Υ󥯥롼ɥեϡt_config.h Τߤ饤󥯥롼ɤ롥
 *  ¾Υե뤫ľܥ󥯥롼ɤƤϤʤʤ
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

/*
 *  ͥ̾Υ͡
 */
#include <cpu_rename.h>

/*
 *  ץåü̿Υ饤ؿ
 */
#ifndef _MACRO_ONLY
#include <cpu_insn.h>
#endif /* _MACRO_ONLY */

/*
 *  chg_ipm/get_ipm 򥵥ݡȤ뤫ɤ
 */
#define	SUPPORT_CHG_IPM

/*
 *  TCB ΥեɤΥӥå
 *
 *  cpu_context.h 쥬ȤȤΰ¸δطǡ
 *  cpu_context.h ˤʤ
 */
#define	TBIT_TCB_TSTAT		8	/* tstat եɤΥӥå */
#define	TBIT_TCB_PRIORITY	8	/* priority եɤΥӥå */

#ifndef _MACRO_ONLY
/*
 *  ƥȥ֥å
 */
typedef struct task_context_block {
	VP	msp;		/* åݥ */
	FP	pc;		/* ץ५ */
} CTXB;

/*
 *  ߥޥ饤֥
 *
 *  ߥޥintmaskˤϡIPMInterrupt Priority Maskˤ8ӥå
 *  ˥եȤΤǤ롥
 */

/*
 *  ߤγߥޥɽФ
 */
Inline UH
current_intmask()
{
	return(current_sr() & 0x0700);
}

/*
 *  ߥޥ
 */
Inline void
set_intmask(UH intmask)
{
	set_sr((current_sr() & ~0x0700) | intmask);
}

/*
 *  ƥֻ
 */

Inline BOOL
sense_context()
{
	return((current_sr() & 0x1000) == 0);
}

Inline BOOL
sense_lock()
{
	return(current_intmask() == 0x0700);
}

#define t_sense_lock	sense_lock
#define i_sense_lock	sense_lock

/*
 *  CPUåȤβʥƥѡ
 *
 *  task_intmask ϡchg_ipm 򥵥ݡȤ뤿ѿchg_ipm 򥵥ݡ
 *  Ȥʤˤϡtask_intmask  0 ˤʤäƤȹͤФ褤
 */

#ifdef SUPPORT_CHG_IPM
extern UH	task_intmask;	/* ƥȤǤγߥޥ */
#endif /* SUPPORT_CHG_IPM */

Inline void
t_lock_cpu()
{
	disint();
}

Inline void
t_unlock_cpu()
{
#ifdef SUPPORT_CHG_IPM
	/*
	 *  t_unlock_cpu ƤӽФΤ CPUå֤ΤߤǤ뤿
	 *  ᡤ task_intmask 񤭴뤳ȤϤʤ
	 */
	set_intmask(task_intmask);
#else /* SUPPORT_CHG_IPM */
	enaint();
#endif /* SUPPORT_CHG_IPM */
}

/*
 *  CPUåȤβ󥿥ƥѡ
 */

extern UH	int_intmask;	/* 󥿥ƥȤǤγߥޥ */

Inline void
i_lock_cpu()
{
	UH	intmask;

	/*
	 *  ѿ intmask ȤäƤΤϡcurrent_intmask() 
	 *  ľ˳ߤȯư줿ߥϥɥ
	 *  int_intmask ѹǽ뤿Ǥ롥
	 */
	intmask = current_intmask();
	disint();
	int_intmask = intmask;
}

Inline void
i_unlock_cpu()
{
	set_intmask(int_intmask);
}

/*
 *  ǥѥå
 */

/*
 *  ǹ̥ͥؤΥǥѥåcpu_support.S
 *
 *  dispatch ϡƥȤƤӽФ줿ӥ
 *  ǡCPUå֤ǸƤӽФʤФʤʤ
 */
extern void	dispatch(void);

/*
 *  ߤΥƥȤΤƤƥǥѥåcpu_support.S
 *
 *  exit_and_dispatch ϡCPUå֤ǸƤӽФʤФʤʤ
 */
extern void	exit_and_dispatch(void);

/*
 *  ߥϥɥ顿CPU㳰ϥɥ
 */

/*
 *  㳰٥ơ֥ι¤
 */
typedef struct exc_vector_entry {
	FP	exchdr;			/* 㳰ϥɥεư */
} EXCVE;

/*
 *  ߥϥɥ
 *
 *  ٥ȥֹ inhno γߥϥɥεưϤ inthdr ꤹ롥
 */
Inline void
define_inh(INHNO inhno, FP inthdr)
{
	EXCVE	*excvt;

#ifdef EXCVT_KERNEL
	/*
	 *  EXCVT_KERNEL Ƥϡ VBR  
	 *  EXCVT_KERNEL ꤹΤǡEXCVT_KERNEL Ȥ
	 */
	excvt = (EXCVE *) EXCVT_KERNEL;
#else /* EXCVT_KERNEL */
	excvt = (EXCVE *) current_vbr();
#endif /* EXCVT_KERNEL */
	excvt[inhno].exchdr = inthdr;
}

/*
 *  CPU㳰ϥɥ
 *
 *  ٥ȥֹ excno CPU㳰ϥɥεưϤ exchdr ꤹ롥
 */
Inline void
define_exc(EXCNO excno, FP exchdr)
{
	define_inh(excno, exchdr);
}

/*
 *  ߥϥɥ顿CPU㳰ϥɥν
 */

/*
 *  ߥϥɥνޥ
 *
 *  reqflg å˳ߤػߤʤȡreqflg å
 *  ˵ư줿ߥϥɥǥǥѥå׵ᤵ줿ˡǥ
 *  ѥåʤ
 */

#define	INTHDR_ENTRY(inthdr)		\
extern void inthdr##_entry(void);	\
asm(".text				\n" \
#inthdr "_entry:			\n" \
"	movem.l %d0-%d1/%a0-%a1, -(%sp)	\n" /* å쥸¸ */ \
"	jsr " #inthdr "			\n" /* ߥϥɥƤӽФ */ \
"	movem.l (%sp)+, %d0-%d1/%a0-%a1	\n" /* å쥸 */ \
"	btst.b #4, (%sp)		\n" /* 褬ߥ⡼ɤʤ */ \
"	jbeq 1f				\n" /*           ˥꥿ */ \
"	or.w #0x0700, %sr		\n" /* ߶ػ */ \
"	tst.l _kernel_reqflg		\n" /* reqflg  TRUE Ǥ */ \
"	jbne _kernel_ret_int		\n" /*              ret_int  */ \
"1:	rte				\n")

#define	INT_ENTRY(inthdr)	inthdr##_entry

/*
 *  CPU㳰ϥɥνޥ
 *
 *  CPU㳰ϥɥϡ󥿥ƥȤǼ¹Ԥ롥ΤᡤCPU
 *  ϥɥƤӽФ˳ߥ⡼ɤ˰ܹԤ꥿󤷤Ƥ
 *  Υ⡼ɤ᤹Υ⡼ɤ᤹ˡߥ⡼ɤ˰ܹԤ
 *   SR ߥå¸롥CPU㳰ƥȤ
 *  ȯreqflg  TRUE ˤʤäˡret_exc ʬ롥
 *  reqflg å˳ߤػߤʤȡreqflg å
 *  ˵ư줿ߥϥɥǥǥѥå׵ᤵ줿ˡǥ
 *  ѥåʤ
 */

#define	EXCHDR_ENTRY(exchdr)		\
extern void exchdr##_entry(VP sp);	\
asm(".text				\n" \
#exchdr "_entry:			\n" \
"	movem.l %d0-%d1/%a0-%a1, -(%sp)	\n" /* å쥸¸ */ \
"	lea.l 16(%sp), %a0		\n" /* 㳰ե졼Ƭ A0  */ \
"	move.w %sr, %d0			\n" /* SR  D0  */ \
"	and.w #~0x1000, %sr		\n" /* ߥ⡼ */ \
"	move.l %d0, -(%sp)		\n" /*  SR 򥹥å¸ */ \
"	move.l %a0, -(%sp)		\n" /* A0 ȤϤ */ \
"	jsr " #exchdr "			\n" /* CPU㳰ϥɥƤӽФ */ \
"	addq.l #4, %sp			\n" \
"	move.l (%sp)+, %d0		\n" \
"	and.w #0x1000, %d0		\n" /* ߥ⡼ɤʤ */ \
"	jbeq 1f				\n" /*       ˥꥿ */ \
"	or.w #0x1700, %sr		\n" /* ޥ⡼ɡ߶ػ */ \
"	tst.l _kernel_reqflg		\n" /* reqflg  TRUE Ǥ */ \
"	jbne _kernel_ret_exc		\n" /*              ret_exc  */ \
"1:	movem.l (%sp)+, %d0-%d1/%a0-%a1	\n" /* å쥸 */ \
"	rte				\n")

#define	EXC_ENTRY(exchdr)	exchdr##_entry

/*
 *  CPU㳰ȯΥƥ֤λ
 */

/*
 *  CPU㳰ȯΥƥȤλ
 */
Inline BOOL
exc_sense_context(VP p_excinf)
{
	return((*((UH *) p_excinf) & 0x1000) == 0);
}

/*
 *  CPU㳰ȯCPUå֤λ
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
	return((*((UH *) p_excinf) & 0x0700) == 0x0700);
}

/*
 *  ץå¸ν
 */
extern void	cpu_initialize(void);

/*
 *  ץå¸νλ
 */
extern void	cpu_terminate(void);

#endif /* _MACRO_ONLY */
#endif /* _CPU_CONFIG_H_ */
