/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2007 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sys_support.S,v 1.2 2007/05/30 08:38:51 honda Exp $
 */

/*
 *	åȥƥ¸⥸塼 ֥M3A-2131ѡ
 */

#define	_MACRO_ONLY

#include <m32rasm.inc>
#include <s_services.h>

/*
 *  ٥Υåȥƥ¸ν
 *
 *  ȥåץ⥸塼ǡν˸ƤӽФ롥
 */
	.macro	out		addr, val
		ld24	r0, \addr
		seth	r1, #((\val) >> 16)
		or3		r1, r1, #((\val) & 0xffff)
		st		r1, @r0
	.endm

	.macro	outh	addr, val
		ld24	r0, #(\addr)
		ldi		r1, #(\val)
		sth		r1, @r0
	.endm

	.macro	outb	addr, val
		ld24	r0, #(\addr)
		ldi		r1, #(\val)
		stb		r1, @r0

	.endm

Function hardware_init_hook

	outb	PLLCR+3,   0x1			/* PLLåư */
	out		BSELCR(1), 0x0fffb50f	/* Х֥åѡSDRAM */

	/* PIO */
	outh	PMOD(0),   0x0100	/* ХBSEL1 */
	outh	PMOD(1),   0x1		/* ХRD/WR */
	outh	PMOD(2),   0x1		/* ХWS3 */
	outh	PMOD(3),   0x5555	/* Х */
	outh	PMOD(4),   0x5555	/* Х */
	outh	PMOD(5),   0x0555	/* I/O */
	outh	PMOD(6),   0x0555	/* I/O */

	outh	SDIR0+2,   0x182

	/* SDRAM */
	ld24	r0, SDIR1+3
	ldi		r1, 1
	stb		r1, @r0
	addi	r0, -2
L1:	ldb		r1, @r0
	bnez	r1, L1					/* DINSTӥåȤꥢȽλ */

	outb	SDBR+3, 0x2
	outh	SDRF1+2, 0x0020
	outh	SDMOD(0)+2, 0
	out		SDADR(0), 0x01000042	/* 0x01000000, 32bit, bank 4, 16MB */
	outh	SDTR(0)+2,0x0001

	outb	SDRF1+1, 1				/* եåͭ */
	outb	SDER(0)+3, 1			/* SDRAMͭ */
	outb	CPUCLKCR+1, 0x2			/* CPUåȤPLLå */
	rts

Function software_init_hook
	rts

Function vxget_tim
	rts
