/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2003-2004 by Naoki Saito
 *             Nagoya Municipal Industrial Research Institute, JAPAN
 *  Copyright (C) 2003-2004 by Ryosuke Takeuchi
 *              Platform Development Center RICOH COMPANY,LTD. JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_config.c,v 1.4 2006/08/03 04:15:57 honda Exp $
 */

/*
 *  ץå¸⥸塼M16Cѡ
 */

#include "jsp_kernel.h"
#include "check.h"
#include "task.h"

/* 
 *  /CPU㳰ͥȥ
 */
char	intnest;

/*
 *  ץå¸ν
 */
void
cpu_initialize(void)
{
	/* ߥͥȥȽ(ƥ) */
	intnest = 0;
}

/*
 *  ץå¸νλ
 */
void
cpu_terminate(void)
{
}

/*
 * software_init_hookβ
 */
#ifndef EXTERNAL_SOFT_HOOK
const VP_INT software_init_hook = 0;
#endif  /* EXTERNAL_SOFT_HOOK */


/*
 * 쥸ͥѹ
 *
 * 쥸ϡΥ쥸б׵᤬ȯʤս
 * ѹɬפ롥Τᡤߤػߤ塤ѹɬפ롥
 * ߤػߤƳ쥸ѹϡѤ̿դ
 * ɬפ롥
 * IRӥåȰʳѹˤϡAND,OR,BCLR,BSET̿Ѥ뤳ȡ
 * IRӥåȤMOV̿Ѥ뤳ȡ
 * ޤIե饰ѤƳߤػߤϡĤ˿̿ᤪȡ
 * ܺ٤ϡM16Cϡɥޥ˥奢
 *       "Ѿ->->쥸ѹ"
 * 򻲾ȤΤȡ 
 */
void
set_ic_ilvl(VP addr, UB val){
    BOOL    locked;
    
    locked = sense_lock();
    if (!(locked)) {
        sense_context() ? i_lock_cpu() : t_lock_cpu();
    }
    
    _asm("PUSH.W A0");
    _asm("PUSH.B R0L");
    _asm("MOV.W $$[FB], A0", addr);
    _asm("MOV.B $$[FB], R0L", val);
    _asm("AND.B #08H, [A0]");
    _asm("OR.B  R0L, [A0]");
    _asm("NOP");
    _asm("NOP");    
    _asm("POP.B R0L");
    _asm("POP.W A0");

    if (!(locked)) {
        sense_context() ? i_unlock_cpu() : t_unlock_cpu();
    }
    
}

