/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2003-2004 by Katsuhiro Amano
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 *  @(#) $Id: cpu_config.c,v 1.7 2007/03/23 07:58:33 honda Exp $
 */

/*
 *  ץå¸⥸塼H8ѡ
 *ͥǻѤ
 *Cؿμ
 */

#include "jsp_kernel.h"
#include "check.h"
#include "task.h"
#include "sil.h"
#include <hw_serial.h>  /*  SCI_putchar_pol()  */

#ifdef SUPPORT_CHG_IPM
/*
 *  ƥȤǤγߥޥ
 */
volatile UB      task_intmask = 0;
#endif /* SUPPORT_CHG_IPM */

/*
 *  󥿥ƥȤǤγߥޥ
 */
volatile UB      int_intmask = 0;

/*
 *  ߥͥȥ
 */
volatile UB      intnest = 0;

/*
 *  CPUå֤ɽե饰
 */
volatile BOOL    iscpulocked = TRUE;

/*
 *  ޤΥץ饤ƥ٥ѤΥǡ
 *      hw_timer.h˵Ҥ٤
 *      hw_timer.h򥤥󥯥롼ɤեǤ٤Ƽβ
 *ΰͭƤޤᡢΤϤ˵Ҥ롣
 */
const IRC TIMER_IRC = {(UB*)SYSTEM_TIMER_IPR,
                        SYSTEM_TIMER_IP_BIT,
                        SYSTEM_TIMER_IPM
};

/*
 *  SYSCRν
 *      $CPUǥ쥯ȥ
 *      ӥå7 SSBY=0sleep̿ǥ꡼ץ⡼ɤذܹ
 *      ӥå3 UE=1CCR.UIߥޥӥåȤȤ
 *      ӥå1 1ꥶ֥ӥå
 *      ӥå0 RAME=1¢RAMͭ
 *      $SYSǥ쥯ȥSYSCR_SYSȤ
 *      ӥå6-4 STSХޡ쥯
 *      ӥå2 NMIEGNMIå
 */
#define SYSCR_INI	(H8SYSCR_UE | BIT1 | H8SYSCR_RAME | SYSCR_SYS)

/*
 *  ץå¸ν
 */
void
cpu_initialize(void)
{
        /*
         *  ʲΣĤϥȥåץ롼ǽѤǤ롣
         *  ߥͥȥ intnest
         *  󥿥ƥȤγߥޥ int_intmask
         *  ƥȤγߥޥ task_intmask
         *  chg_ipm򥵥ݡȤ
         */

        /*
         *  SYSCR
         */
        sil_wrb_mem((VP)H8SYSCR, (VB)SYSCR_INI);
         
        /*  ̤  */
        /*  sleep̿ܤϾ֤  */

        /*  ٥ѥꥢݡȤν  */
        SCI_initialize(SCI_LOW_PORTID);
}

/*
 *  ץå¸νλ
 */
void
cpu_terminate(void)
{
}

#ifdef SUPPORT_CHG_IPM
/*
 *  ߥޥѹ
 *
 *IPMǤͤȤIPM_LEVEL0IPM_LEVEL1ޥƤ롣
 *
 *
 *IPM_LEVEL0٥룰٤Ƥγߤդ
 *IPM_LEVEL1٥룱NMIӥץ饤ƥ٥룱γߤΤߤ
 *դ
 *
 *  chg_ipm Ȥä IPM ٥2NMI ʳΤ٤Ƥγߤػߡˤ
 *  ѹ뤳ȤϤǤʤNMI ʳΤ٤Ƥγߤػߤ
 *  ˤϡloc_cpu ˤCPUå֤ˤФ褤
 *  IPM  0 ʳλˤ⡤ǥѥåαʤIPM ϡ
 *  ǥѥåˤäơ¹Ծ֤ˤʤäذѤ
 *  롥Τᡤ¹ˡ̤Υˤä IPM ѹ
 *  礬롥JSPͥǤϡIPM ѹϥ㳰롼
 *  ˤäƤⵯΤˤäư񤷤ʤϾʤ
 *  פ롥
 *IPM ͤˤäƥǥѥåػߤˤϡdis_dsp
 *  ʻѤФ褤
 */
SYSCALL ER
chg_ipm(IPM ipm)
{
        ER      ercd = E_OK;

        LOG_CHG_IPM_ENTER(ipm);
        CHECK_TSKCTX_UNL();
        CHECK_PAR( (ipm == IPM_LEVEL0) || (ipm == IPM_LEVEL1) || (ipm == IPM_LEVEL2));

        t_lock_cpu();
        task_intmask = ipm;
        t_unlock_cpu();

    exit:
        LOG_CHG_IPM_LEAVE(ercd)
        return(ercd);
}

/*
 *  ߥޥλ
 */
SYSCALL ER
get_ipm(IPM *p_ipm)
{
        ER      ercd = E_OK;

        LOG_GET_IPM_ENTER(p_ipm);
        CHECK_TSKCTX_UNL();

        t_lock_cpu();
        *p_ipm = task_intmask;
        t_unlock_cpu();

    exit:
        LOG_GET_IPM_LEAVE(ercd, *p_ipm);
        return(ercd);
}

#endif /* SUPPORT_CHG_IPM */

/*
 * Ԥ
 * ջࡧ
 * ɸǤdlytimUINT16ӥåȤʤΤǡ
 * UWѹƤ롣
 * sil_dly_nse()sil_dly_nse2()ƤӽФ
 */
void sil_dly_nse(UINT dlytim) {
	sil_dly_nse_long((UW)dlytim);
}

/*****ʲȤΥ󥿡ե˴ޤޤʤʬ*********/

/*
 * ϿƤʤߤΥǥեȽ
 */

/*
 * åƬƥ쥸ΤޤǤΥեå
 * 
 * å¤
 * +0:er0
 * +4:er1
 * +8:er2
 *+12:er3
 *+16:er4
 *+20:er5
 *+24:er6
 *+28:crr
 *+29:pc
 *+32:˻ѤƤåΰ
 */

/*
 * ȯľΥåݥ󥿤ޤǤΥեå
 */
#define OFFSET_SP	32

/*
 * ϿƤʤߤȯȸƤӽФ
 */
void 
cpu_experr(EXCSTACK *sp)
{
    UW sp2, pc, ccr, tmp;
    
    sp2 = (UW)sp + OFFSET_SP;
    tmp = sp->pc;
    ccr = (tmp >> 24U) & 0xff;	/*  1Х  */
    pc = tmp & 0x00ffffffUL;	/*  3Х  */
    
	/*
	 *  %xˤǤ2ХȤɽǤʤΤ
	 *  %pʥݥ󥿷ˤѤ4ХɽƤ롣
	 */
    syslog(LOG_EMERG, "Unexpected interrupt.");
    syslog(LOG_EMERG, "PC  = 0x%08p SP  = 0x%08p CCR  = 0x%02x",
                       (VP)pc, (VP)sp2, (INT)ccr);
    syslog(LOG_EMERG, "ER0 = 0x%08p ER1 = 0x%08p ER2 = 0x%08p ER3 = 0x%08p",
           (VP)(sp->er0), (VP)(sp->er1), (VP)(sp->er2), (VP)(sp->er3));
    syslog(LOG_EMERG, "ER4 = 0x%08p ER5 = 0x%08p ER6 = 0x%08p",
                       (VP)(sp->er4), (VP)(sp->er5), (VP)(sp->er6));
    while(1)
    	;
}

/*
 *  åȥƥʸ
 *
 *  ƥ٥ʸϥ롼
 */
void
cpu_putc(char c)
{
    if (c == '\n') {
        SCI_putchar_pol('\r');
    }
    SCI_putchar_pol((UB)c);
}
