/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2007 by KURUSUGAWA Electronics Industry Inc, JAPAN
 *  Copyright (C) 2008 by Takahisa Yokota
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sys_config.c,v 1.7 2003/07/08 14:57:15 hiro Exp $
 */

/*
 *	åȥƥ¸⥸塼MCF52235EVBѡ
 */

#include "jsp_kernel.h"
#include <sil.h>
#include "mcfuart.h"

/*
 *  åȥƥ¸ν
 */
void
sys_initialize()
{
    SIOPCB *siopcb;

    sil_wrb_mem (MCF_GPIO_PUAPAR, (MCF_GPIO_PUAPAR_RXD0_RXD0|MCF_GPIO_PUAPAR_TXD0_TXD0));
    sil_wrb_mem (MCF_GPIO_PUBPAR, (MCF_GPIO_PUBPAR_RXD1_RXD1|MCF_GPIO_PUBPAR_TXD1_TXD1));
    mcfuart_initialize ();
    siopcb = mcfuart_opn_por (LOGTASK_PORTID, 0);
}

/*
 *  åȥƥνλ
 */
void
sys_exit()
{
	cfv2_exit();
}

/*
 *  åȥƥʸ
 */
void
sys_putc(char c)
{
	if (c == '\n') {
		cfv2_putc(LOGTASK_PORTID, '\r');
	}
	cfv2_putc(LOGTASK_PORTID, c);
}

/* ϡɥ */
#ifndef GDB_STUB


static void init_clock_config (void)
{
    sil_wrb_mem ((VP)MCF_CLK_CCHR,  (UB)MCF_CLK_CCHR_PFD(0x4));
    
    sil_wrh_mem ((VP)MCF_CLK_SYNCR,  (UH)0x4103);
    while (!(sil_reb_mem((VP)MCF_CLK_SYNSR) & 0x08));
    
    sil_wrh_mem ((VP)MCF_CLK_SYNCR,  (UH)0x4003);
    
    while (!(sil_reb_mem((VP)MCF_CLK_SYNSR) & 0x08));
    
    sil_wrh_mem ((VP)MCF_CLK_SYNCR,  (UH)0x4007);
}

void
hardware_init_hook (void)
{
  init_clock_config ();
  sil_wrw_mem ((VP) MCF_INTC_IMRH(MCF_INTC0), ~MCF_INTC_IMRH_ALL);
  sil_wrw_mem ((VP) MCF_INTC_IMRL(MCF_INTC0), ~MCF_INTC_IMRL_ALL);
  sil_wrw_mem ((VP) MCF_INTC_IMRH(MCF_INTC1), ~MCF_INTC_IMRH_ALL);
  sil_wrw_mem ((VP) MCF_INTC_IMRL(MCF_INTC1), ~MCF_INTC_IMRL_ALL);
  return;
}
#else
void
hardware_init_hook (void)
{
}
#endif
