/*
 * Decompiled with CFR 0.152.
 */
package test;

import jp.sourceforge.tomoyo.core.PersistentPropertyManager;
import jp.sourceforge.tomoyo.core.ProjectProperty;
import jp.sourceforge.tomoyo.core.ProjectPropertyManager;
import jp.sourceforge.tomoyo.core.Utilities;
import jp.sourceforge.tomoyo.core.extensions.IConnectionAdapter;
import jp.sourceforge.tomoyo.core.server.ConcreteCommand;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import test.TomoyoCorePluginTest;

/*
 * Exception performing whole class analysis ignored.
 */
public class SSHConnectionAdapterPluginTest
extends TestCase {
    private IProject testingProject;
    private IConnectionAdapter adapter;
    private boolean b = false;

    private void ___setup() {
        this.testingProject = TomoyoCorePluginTest.getTestingProject();
        this.adapter = Utilities.getConnectionAdapter((IProject)this.testingProject);
        if (this.adapter.isConnected(this.testingProject)) {
            this.adapter.disconnect(this.testingProject);
        }
        TomoyoCorePluginTest.setupProperty((String)"169.254.195.50", (String)"root", (String)"22", (String)"jp.sourceforge.tomoyo.base.ssh.connection.SSHConnectionAdapter", null, (String)"password", null);
        ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(this.testingProject);
        properties.setProperty(new String[]{"", "confirm_conect"}, "false");
    }

    public void testConnect() {
        this.___setup();
        boolean b = false;
        b = this.adapter.isConnected(this.testingProject);
        SSHConnectionAdapterPluginTest.assertTrue((!b ? 1 : 0) != 0);
        b = this.adapter.connect(this.testingProject);
        SSHConnectionAdapterPluginTest.assertTrue((boolean)b);
        b = this.adapter.isConnected(this.testingProject);
        SSHConnectionAdapterPluginTest.assertTrue((boolean)b);
    }

    public void testIsConnected() {
        this.testConnect();
    }

    public void testDisonnect() {
        this.___setup();
        if (!this.adapter.isConnected(this.testingProject)) {
            this.adapter.connect(this.testingProject);
        }
        boolean b = false;
        b = this.adapter.isConnected(this.testingProject);
        SSHConnectionAdapterPluginTest.assertTrue((boolean)b);
        this.adapter.disconnect(this.testingProject);
        b = this.adapter.isConnected(this.testingProject);
        SSHConnectionAdapterPluginTest.assertTrue((!b ? 1 : 0) != 0);
    }

    public void testIsDisconnected() {
        this.testDisonnect();
    }

    public void testConnectAgain() {
        this.testConnect();
    }

    public void testIsConnectedAgain() {
        this.testIsConnected();
    }

    public void testDisonnectAgain() {
        this.testDisonnect();
    }

    public void testIllegalHostname() {
        this.___setup();
        ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(this.testingProject);
        properties.setProperty(PersistentPropertyManager.PROPERTY_SERVER_HOSTNAME, "unknown");
        this.b = this.adapter.connect(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)false, (boolean)this.b);
        SSHConnectionAdapterPluginTest.assertEquals((String)"com.jcraft.jsch.JSchException: java.net.UnknownHostException: unknown", (String)this.adapter.getErrorMessage(this.testingProject));
        this.b = this.adapter.isConnected(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)false, (boolean)this.b);
        properties.setProperty(PersistentPropertyManager.PROPERTY_SERVER_HOSTNAME, "169.254.195.50");
        this.b = this.adapter.connect(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)true, (boolean)this.b);
        SSHConnectionAdapterPluginTest.assertNull((Object)this.adapter.getErrorMessage(this.testingProject));
        this.b = this.adapter.isConnected(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)true, (boolean)this.b);
    }

    public void testIllegalPortNot() {
        this.___setup();
        ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(this.testingProject);
        properties.setProperty(PersistentPropertyManager.PROPERTY_SERVER_PORT, "90000");
        this.b = this.adapter.connect(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)false, (boolean)this.b);
        SSHConnectionAdapterPluginTest.assertEquals((String)"com.jcraft.jsch.JSchException: java.lang.IllegalArgumentException: port out of range:90000", (String)this.adapter.getErrorMessage(this.testingProject));
        this.b = this.adapter.isConnected(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)false, (boolean)this.b);
        properties.setProperty(PersistentPropertyManager.PROPERTY_SERVER_PORT, "22");
        this.b = this.adapter.connect(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)true, (boolean)this.b);
        SSHConnectionAdapterPluginTest.assertNull((Object)this.adapter.getErrorMessage(this.testingProject));
        this.b = this.adapter.isConnected(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)true, (boolean)this.b);
    }

    public void testIllegalUsername() {
        this.___setup();
        ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(this.testingProject);
        properties.setProperty(PersistentPropertyManager.PROPERTY_LOGIN_USERNAME, "nobody knows");
        this.b = this.adapter.connect(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)false, (boolean)this.b);
        SSHConnectionAdapterPluginTest.assertEquals((String)"com.jcraft.jsch.JSchException: Auth fail", (String)this.adapter.getErrorMessage(this.testingProject));
        this.b = this.adapter.isConnected(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)false, (boolean)this.b);
        properties.setProperty(PersistentPropertyManager.PROPERTY_LOGIN_USERNAME, "root");
        this.b = this.adapter.connect(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)true, (boolean)this.b);
        SSHConnectionAdapterPluginTest.assertNull((Object)this.adapter.getErrorMessage(this.testingProject));
        this.b = this.adapter.isConnected(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)true, (boolean)this.b);
    }

    public void testIllegalPrivateKey() {
        this.___setup();
        ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(this.testingProject);
        properties.setProperty(PersistentPropertyManager.PROPERTY_PRIVATE_KEY, "C:\\somewhere");
        this.b = this.adapter.connect(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)false, (boolean)this.b);
        SSHConnectionAdapterPluginTest.assertTrue((boolean)this.adapter.getErrorMessage(this.testingProject).startsWith("com.jcraft.jsch.JSchException: java.io.FileNotFoundException: C:\\somewhere"));
        this.b = this.adapter.isConnected(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)false, (boolean)this.b);
        properties.setProperty(PersistentPropertyManager.PROPERTY_PRIVATE_KEY, "C:\\Users\\toru\\Documents\\id_rsa");
        this.b = this.adapter.connect(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)true, (boolean)this.b);
        SSHConnectionAdapterPluginTest.assertNull((Object)this.adapter.getErrorMessage(this.testingProject));
        this.b = this.adapter.isConnected(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)true, (boolean)this.b);
    }

    public void testIllegalPassword() {
        this.___setup();
        ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(this.testingProject);
        properties.setProperty(PersistentPropertyManager.PROPERTY_LOGIN_PASSWORD, "invalid password");
        this.b = this.adapter.connect(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)false, (boolean)this.b);
        SSHConnectionAdapterPluginTest.assertEquals((String)"com.jcraft.jsch.JSchException: Auth fail", (String)this.adapter.getErrorMessage(this.testingProject));
        this.b = this.adapter.isConnected(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)false, (boolean)this.b);
        properties.setProperty(PersistentPropertyManager.PROPERTY_LOGIN_PASSWORD, "password");
        this.b = this.adapter.connect(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)true, (boolean)this.b);
        SSHConnectionAdapterPluginTest.assertNull((Object)this.adapter.getErrorMessage(this.testingProject));
        this.b = this.adapter.isConnected(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)true, (boolean)this.b);
    }

    public void testConnectWithKnownHosts() {
        this.___setup();
        ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(this.testingProject);
        properties.setProperty(PersistentPropertyManager.PROPERTY_KNOWN_HOSTS, "C:\\somewhre");
        this.b = this.adapter.connect(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)false, (boolean)this.b);
        SSHConnectionAdapterPluginTest.assertEquals((String)"com.jcraft.jsch.JSchException: reject HostKey: 169.254.195.50", (String)this.adapter.getErrorMessage(this.testingProject));
        this.b = this.adapter.isConnected(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)false, (boolean)this.b);
        properties.setProperty(PersistentPropertyManager.PROPERTY_KNOWN_HOSTS, "C:\\Users\\toru\\Documents\\known_hosts");
        this.b = this.adapter.connect(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)true, (boolean)this.b);
        SSHConnectionAdapterPluginTest.assertNull((Object)this.adapter.getErrorMessage(this.testingProject));
        this.b = this.adapter.isConnected(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)true, (boolean)this.b);
    }

    public void testConnectWithKnownHosts_invalidFileContents() {
        this.___setup();
        ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(this.testingProject);
        properties.setProperty(PersistentPropertyManager.PROPERTY_KNOWN_HOSTS, "C:\\config.sys");
        this.b = this.adapter.connect(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)false, (boolean)this.b);
        SSHConnectionAdapterPluginTest.assertEquals((String)"com.jcraft.jsch.JSchException: reject HostKey: 169.254.195.50", (String)this.adapter.getErrorMessage(this.testingProject));
        this.b = this.adapter.isConnected(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)false, (boolean)this.b);
        properties.setProperty(PersistentPropertyManager.PROPERTY_KNOWN_HOSTS, "C:\\Users\\toru\\Documents\\known_hosts");
        this.b = this.adapter.connect(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)true, (boolean)this.b);
        SSHConnectionAdapterPluginTest.assertNull((Object)this.adapter.getErrorMessage(this.testingProject));
        this.b = this.adapter.isConnected(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)true, (boolean)this.b);
    }

    public void testNGPrivatekeyThenOKPassword() {
        this.___setup();
        ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(this.testingProject);
        properties.setProperty(PersistentPropertyManager.PROPERTY_PRIVATE_KEY, "C:\\somewhre");
        this.b = this.adapter.connect(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)false, (boolean)this.b);
        this.b = this.adapter.isConnected(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)false, (boolean)this.b);
        properties.setProperty(PersistentPropertyManager.PROPERTY_PRIVATE_KEY, null);
        properties.setProperty(PersistentPropertyManager.PROPERTY_LOGIN_PASSWORD, "password");
        this.b = this.adapter.connect(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)true, (boolean)this.b);
        SSHConnectionAdapterPluginTest.assertNull((Object)this.adapter.getErrorMessage(this.testingProject));
        this.b = this.adapter.isConnected(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)true, (boolean)this.b);
    }

    public void testNGPasswordThenOKPrivatekey() {
        this.___setup();
        ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(this.testingProject);
        properties.setProperty(PersistentPropertyManager.PROPERTY_LOGIN_PASSWORD, "invalid password");
        this.b = this.adapter.connect(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)false, (boolean)this.b);
        this.b = this.adapter.isConnected(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)false, (boolean)this.b);
        properties.setProperty(PersistentPropertyManager.PROPERTY_PRIVATE_KEY, "C:\\Users\\toru\\Documents\\id_rsa");
        this.b = this.adapter.connect(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)true, (boolean)this.b);
        SSHConnectionAdapterPluginTest.assertNull((Object)this.adapter.getErrorMessage(this.testingProject));
        this.b = this.adapter.isConnected(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)true, (boolean)this.b);
    }

    public void testExecCommand() {
        this.___setup();
        this.b = this.adapter.connect(this.testingProject);
        SSHConnectionAdapterPluginTest.assertEquals((boolean)true, (boolean)this.b);
        int n = 1000;
        StringBuffer sb = new StringBuffer();
        sb.append("for i in `seq 0 1000`; do echo -n $i; done");
        ConcreteCommand command = new ConcreteCommand(this.testingProject, sb.toString());
        Boolean b = this.adapter.exec(command);
        SSHConnectionAdapterPluginTest.assertTrue((boolean)b);
        StringBuffer expected = new StringBuffer();
        int cnt = 0;
        while (cnt <= 1000) {
            expected.append(cnt);
            ++cnt;
        }
        SSHConnectionAdapterPluginTest.assertEquals((int)expected.length(), (int)command.getSTDOut().length());
        SSHConnectionAdapterPluginTest.assertEquals((String)expected.toString(), (String)command.getSTDOut());
    }
}

