/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import jp.sourceforge.tomoyo.core.server.ConnectionManager;
import jp.sourceforge.tomoyo.core.server.ConnectionStatus;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import test.TomoyoCorePluginTest;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConnectionManagerTest
extends TestCase
implements Observer {
    private ArrayList<Boolean> connectStateList = new ArrayList();

    public void testGetInstance() {
        ConnectionManager instance1 = ConnectionManager.getInstance();
        ConnectionManagerTest.assertTrue((boolean)(instance1 instanceof ConnectionManager));
        ConnectionManager instance2 = ConnectionManager.getInstance();
        ConnectionManagerTest.assertEquals((Object)instance1, (Object)instance2);
    }

    public void testConnect() {
        IProject testingProject = TomoyoCorePluginTest.getTestingProject();
        ConnectionManager instance = ConnectionManager.getInstance();
        instance.disConnect(testingProject);
        boolean b = instance.connect(testingProject);
        ConnectionManagerTest.assertTrue((boolean)b);
    }

    public void testDisConnect() {
        IProject testingProject = TomoyoCorePluginTest.getTestingProject();
        ConnectionManager instance = ConnectionManager.getInstance();
        ConnectionManagerTest.assertTrue((boolean)instance.isConnected(testingProject));
        instance.disConnect(testingProject);
        ConnectionManagerTest.assertTrue((!instance.isConnected(testingProject) ? 1 : 0) != 0);
    }

    public void testIsConnected() {
        IProject testingProject = TomoyoCorePluginTest.getTestingProject();
        ConnectionManager instance = ConnectionManager.getInstance();
        instance.disConnect(testingProject);
        ConnectionManagerTest.assertTrue((!instance.isConnected(testingProject) ? 1 : 0) != 0);
        boolean b = instance.connect(testingProject);
        ConnectionManagerTest.assertTrue((boolean)b);
        ConnectionManagerTest.assertTrue((boolean)instance.isConnected(testingProject));
    }

    public void testGetErrorMessage() {
        IProject testingProject = TomoyoCorePluginTest.getTestingProject();
        ConnectionManager instance = ConnectionManager.getInstance();
        instance.disConnect(testingProject);
        ConnectionManagerTest.assertTrue((!instance.isConnected(testingProject) ? 1 : 0) != 0);
        TomoyoCorePluginTest.setupProperty((String)"unknownHost", (String)"root", (String)"22", (String)"jp.sourceforge.tomoyo.base.ssh.connection.SSHConnectionAdapter", null, (String)"password", null);
        ConnectionManagerTest.assertNull((Object)instance.getErrorMessage(testingProject));
        boolean b = instance.connect(testingProject);
        ConnectionManagerTest.assertEquals((boolean)false, (boolean)b);
        String errorMessage = instance.getErrorMessage(testingProject);
        ConnectionManagerTest.assertNotNull((Object)errorMessage);
        ConnectionManagerTest.assertEquals((String)"com.jcraft.jsch.JSchException: java.net.UnknownHostException: unknownHost", (String)errorMessage);
        instance.disConnect(testingProject);
        TomoyoCorePluginTest.setupProperty((String)"jp.sourceforge.tomoyo.base.ssh.connection.SSHConnectionAdapter");
        boolean b2 = instance.connect(testingProject);
        ConnectionManagerTest.assertEquals((boolean)true, (boolean)b2);
        ConnectionManagerTest.assertNull((Object)instance.getErrorMessage(testingProject));
    }

    public void testUpdateConnectionState() {
        IProject testingProject = TomoyoCorePluginTest.getTestingProject();
        ConnectionManager instance = ConnectionManager.getInstance();
        try {
            ConnectionManager.getInstance().addObserver((Observer)this);
            instance.updateConnectionState(testingProject, true);
            instance.updateConnectionState(testingProject, false);
            instance.updateConnectionState(testingProject, true);
            instance.updateConnectionState(testingProject, false);
            instance.updateConnectionState(testingProject, false);
            ConnectionManagerTest.assertEquals((Object)Boolean.TRUE, this.connectStateList.get(0));
            ConnectionManagerTest.assertEquals((Object)Boolean.FALSE, this.connectStateList.get(1));
            ConnectionManagerTest.assertEquals((Object)Boolean.TRUE, this.connectStateList.get(2));
            ConnectionManagerTest.assertEquals((Object)Boolean.FALSE, this.connectStateList.get(3));
            ConnectionManagerTest.assertEquals((Object)Boolean.FALSE, this.connectStateList.get(4));
        }
        finally {
            ConnectionManager.getInstance().deleteObserver((Observer)this);
        }
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        ConnectionStatus status;
        IProject testingProject = TomoyoCorePluginTest.getTestingProject();
        if (testingProject.equals((Object)(status = (ConnectionStatus)arg1).getProject())) {
            this.connectStateList.add(status.isConnected());
        }
    }
}

