/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.core.local.resource;

import jp.sourceforge.tomoyo.core.Utilities;
import jp.sourceforge.tomoyo.core.local.resource.DomainPolicy;
import jp.sourceforge.tomoyo.core.local.resource.ExceptPolicy;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.core.local.resource.Status;
import jp.sourceforge.tomoyo.core.local.resource.SystemPolicy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class ProcResourceSet {
    private IProject project;
    private DomainPolicy domainPolicy;
    private ExceptPolicy exceptPolicy;
    private SystemPolicy systemPolicy;
    private Status status;
    private boolean loading = false;
    private boolean loaded = false;

    public ProcResourceSet(IProject project) {
        this.project = project;
    }

    public DomainPolicy getDomainPolicy() {
        if (this.domainPolicy == null) {
            this.domainPolicy = new DomainPolicy(this.project);
        }
        return this.domainPolicy;
    }

    public ExceptPolicy getExceptPolicy() {
        if (this.exceptPolicy == null) {
            this.exceptPolicy = new ExceptPolicy(this.project);
        }
        return this.exceptPolicy;
    }

    public SystemPolicy getSystemPolicy() {
        if (this.systemPolicy == null) {
            this.systemPolicy = new SystemPolicy(this.project);
        }
        return this.systemPolicy;
    }

    public Status getStatus() {
        if (this.status == null) {
            this.status = new Status(this.project);
        }
        return this.status;
    }

    public IFile getProjectFile() {
        return this.project.getFile(".project");
    }

    public LocalResource[] listLocalResource(IProject project) {
        if (Utilities.is20((IProject)project)) {
            LocalResource[] resources = new LocalResource[]{this.getDomainPolicy(), this.getExceptPolicy(), this.getStatus()};
            return resources;
        }
        LocalResource[] resources = new LocalResource[]{this.getDomainPolicy(), this.getExceptPolicy(), this.getSystemPolicy(), this.getStatus()};
        return resources;
    }

    public String[] listLocalResourceNames(IProject project) {
        if (Utilities.is20((IProject)project)) {
            String[] resourceNames = new String[]{DomainPolicy.NAME, ExceptPolicy.NAME, Status.NAME};
            return resourceNames;
        }
        String[] resourceNames = new String[]{DomainPolicy.NAME, ExceptPolicy.NAME, SystemPolicy.NAME, Status.NAME};
        return resourceNames;
    }

    public boolean hasPolicies() {
        if (Utilities.is20((IProject)this.project)) {
            return this.project.findMember("domain_policy.txt") != null && this.project.findMember("exception_policy.txt") != null;
        }
        return this.project.findMember("domain_policy.txt") != null && this.project.findMember("exception_policy.txt") != null && this.project.findMember("system_policy.txt") != null;
    }

    public void setLoading(boolean b) {
        if (this.loading && !b) {
            this.setLoaded(true);
        }
        this.loading = b;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    private void setLoaded(boolean b) {
        this.loaded = b;
    }
}

