/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.core.local.model.status;

import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import jp.sourceforge.tomoyo.core.local.model.status.Profile;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileDefinition;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileMetaData;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.graphics.RGB;

public class ProfileGroup {
    private int no;
    private Profile[] profiles = new Profile[ProfileDefinition.getProfileCount()];
    private static final String SETTINGS_DESCRIPTION = "settings.description";
    private static final String SETTINGS_FORECOLOR = "settings.forecolor";
    private static final String SETTINGS_BACKCOLOR = "settings.backcolor";

    public ProfileGroup(int id) {
        this.no = id;
    }

    public int getNo() {
        return this.no;
    }

    public void setNo(int id) {
        this.no = id;
    }

    public void storeProfileValue(String strProfileName, String strProfileValue) {
        int index = ProfileDefinition.getIndexByName((String)strProfileName);
        this.profiles[index] = new Profile(index, strProfileValue);
    }

    public Profile getProfile(ProfileMetaData meta) {
        int index = ProfileDefinition.getIndexByName((String)meta.getName());
        return this.profiles[index];
    }

    public Profile createProfile(String name) {
        int index = ProfileDefinition.getIndexByName((String)name);
        this.profiles[index] = new Profile(index, null);
        return this.profiles[index];
    }

    public Profile createProfile(ProfileMetaData meta) {
        int index = ProfileDefinition.getIndexByName((String)meta.getName());
        this.profiles[index] = new Profile(meta);
        return this.profiles[index];
    }

    public boolean hasProfile(ProfileMetaData meta) {
        int index = ProfileDefinition.getIndexByName((String)meta.getName());
        return this.profiles[index] != null;
    }

    public String getComment() {
        Profile comment = this.profiles[1];
        if (comment == null) {
            return "";
        }
        return comment.getValue();
    }

    public String getName() {
        return this.getComment();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProfileGroup) {
            ProfileGroup target = (ProfileGroup)obj;
            return target.getNo() == this.getNo();
        }
        return super.equals(obj);
    }

    public Profile[] listProfile() {
        return this.profiles;
    }

    public String getDescription() {
        IDialogSettings settings = TomoyoCorePlugin.getDefault().getDialogSettings(ProfileGroup.class.getName());
        IDialogSettings subSettings = settings.getSection(SETTINGS_DESCRIPTION);
        if (subSettings == null) {
            subSettings = settings.addNewSection(SETTINGS_DESCRIPTION);
        }
        return subSettings.get(String.valueOf(this.getNo()));
    }

    public void saveDescription(String description) {
        IDialogSettings settings = TomoyoCorePlugin.getDefault().getDialogSettings(ProfileGroup.class.getName());
        IDialogSettings subSettings = settings.getSection(SETTINGS_DESCRIPTION);
        if (subSettings == null) {
            subSettings = settings.addNewSection(SETTINGS_DESCRIPTION);
        }
        subSettings.put(String.valueOf(this.getNo()), description);
    }

    public RGB getForecolor() {
        return this.getColor(SETTINGS_FORECOLOR);
    }

    public void saveForecolor(RGB rgb) {
        this.saveColor(SETTINGS_FORECOLOR, rgb);
    }

    public RGB getBackcolor() {
        return this.getColor(SETTINGS_BACKCOLOR);
    }

    public void saveBackcolor(RGB rgb) {
        this.saveColor(SETTINGS_BACKCOLOR, rgb);
    }

    private RGB getColor(String setting) {
        IDialogSettings settings = TomoyoCorePlugin.getDefault().getDialogSettings(ProfileGroup.class.getName());
        IDialogSettings subSettings = settings.getSection(setting);
        if (subSettings == null) {
            subSettings = settings.addNewSection(setting);
        }
        String[] array = subSettings.getArray(String.valueOf(this.getNo()));
        RGB color = null;
        if (array != null) {
            color = new RGB(Integer.parseInt(array[0]), Integer.parseInt(array[1]), Integer.parseInt(array[2]));
        }
        return color;
    }

    private void saveColor(String setting, RGB rgb) {
        IDialogSettings settings = TomoyoCorePlugin.getDefault().getDialogSettings(ProfileGroup.class.getName());
        IDialogSettings subSettings = settings.getSection(setting);
        if (subSettings == null) {
            subSettings = settings.addNewSection(setting);
        }
        String r = Integer.valueOf(rgb.red).toString();
        String g = Integer.valueOf(rgb.green).toString();
        String b = Integer.valueOf(rgb.blue).toString();
        subSettings.put(String.valueOf(this.getNo()), new String[]{r, g, b});
    }

    public String getLongName() {
        StringBuffer line = new StringBuffer();
        line.append(this.getNo());
        if ((this.getDescription() == null || this.getDescription().trim().equals("")) && this.getComment() != null) {
            line.append(" - ");
            line.append(this.getComment());
        }
        if (this.getDescription() != null) {
            line.append(" - ");
            line.append(this.getDescription());
        }
        return line.toString();
    }
}

