/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import jp.sourceforge.tomoyo.base.ssh.Activator;
import jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject.CheckServerPage;
import jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject.ConnectionSettingPage;
import jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject.DownloadResourcePage;
import jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject.Messages;
import jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject.NewProjectCreationPage;
import jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject.ServerSettingsPage;
import jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject.SetupCompletePage;
import jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject.SetupManagerDomainPage;
import jp.sourceforge.tomoyo.core.ProjectPropertyManager;
import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import jp.sourceforge.tomoyo.core.Utilities;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileManager;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceSet;
import jp.sourceforge.tomoyo.core.server.ConnectionManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class CreateNewProjectWizard
extends Wizard
implements INewWizard {
    private NewProjectCreationPage newProjectPage;
    private ConnectionSettingPage connectionSettingPage;
    private CheckServerPage checkServerPage;
    private ServerSettingsPage settingsPage;
    private DownloadResourcePage downloadPage;
    private SetupManagerDomainPage managerDomainPage;
    private SetupCompletePage completePage;
    private ArrayList<WizardPage> pageList = new ArrayList();

    public CreateNewProjectWizard() {
        this.setWindowTitle(Messages.CreateNewProjectWizard_WindowTitle);
        this.setDefaultPageImageDescriptor(Activator.getImageDescriptor("project_wiz.gif"));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setNeedsProgressMonitor(true);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.setupHelps();
    }

    private void setupHelps() {
    }

    public void addPages() {
        this.newProjectPage = new NewProjectCreationPage();
        this.connectionSettingPage = new ConnectionSettingPage();
        this.checkServerPage = new CheckServerPage();
        this.settingsPage = new ServerSettingsPage();
        this.downloadPage = new DownloadResourcePage();
        this.managerDomainPage = new SetupManagerDomainPage();
        this.completePage = new SetupCompletePage();
        this._addPage((WizardPage)this.newProjectPage);
        this._addPage(this.connectionSettingPage);
        this._addPage(this.checkServerPage);
        this._addPage(this.settingsPage);
        this._addPage(this.downloadPage);
        this._addPage(this.managerDomainPage);
        this._addPage(this.completePage);
    }

    private void _addPage(WizardPage page) {
        this.pageList.add(page);
        this.addPage((IWizardPage)page);
    }

    public boolean canFinish() {
        return this.managerDomainPage.isPageComplete();
    }

    public boolean performFinish() {
        IProject project = this.getProject();
        try {
            TomoyoCorePlugin.getDefault().installNature(project);
            ProfileManager.getInstance().getProjectProfile(project);
        }
        catch (Exception e) {
            Activator.logException(e);
            return false;
        }
        try {
            IFile projectFile = ProcResourceManager.getInstance().getProcResourceSet(project).getProjectFile();
            Utilities.openEditor((IFile)projectFile);
        }
        catch (Exception e) {
            Activator.logException(e);
        }
        return true;
    }

    public IProject getProject() {
        return this.newProjectPage.getProject();
    }

    public boolean performCancel() {
        if (this.deleteProject(this.getProject())) {
            return super.performCancel();
        }
        return false;
    }

    public boolean deleteProject(IProject deletingProject) {
        if (deletingProject == null) {
            return true;
        }
        ProjectPropertyManager.getInstance().removeCache(deletingProject);
        ConnectionManager.getInstance().disConnect(deletingProject);
        DeleteProjectRunnable runnable = new DeleteProjectRunnable(deletingProject);
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)runnable);
            return runnable.isOK();
        }
        catch (InvocationTargetException e) {
            Activator.logException(e);
        }
        catch (InterruptedException e) {
            Activator.logException(e);
        }
        return false;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        try {
            IWizardPage iWizardPage = super.getNextPage(page);
            return iWizardPage;
        }
        finally {
            this.updateWindowTitle(page);
        }
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        try {
            IWizardPage iWizardPage = super.getPreviousPage(page);
            return iWizardPage;
        }
        finally {
            this.updateWindowTitle(page);
        }
    }

    private void updateWindowTitle(IWizardPage page) {
        IWizardPage[] pages = this.getPages();
        int cnt = 0;
        while (cnt < pages.length) {
            if (pages[cnt] == this.getContainer().getCurrentPage()) {
                this.setWindowTitle(String.valueOf(Messages.CreateNewProjectWizard_WindowTitle) + " (" + (cnt + 1) + "/" + this.getPageCount() + ")");
                this.getContainer().updateWindowTitle();
                break;
            }
            ++cnt;
        }
    }

    private class DeleteProjectRunnable
    implements IRunnableWithProgress {
        private IProject project;
        private boolean status;

        public DeleteProjectRunnable(IProject project) {
            this.project = project;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            if (this.project == null) {
                monitor.done();
                return;
            }
            ProcResourceSet pr = ProcResourceManager.getInstance().getProcResourceSet(this.project);
            LocalResource[] resources = pr.listLocalResource(this.project);
            int cnt = 0;
            while (cnt < resources.length) {
                LocalResource localResource = resources[cnt];
                IFile file = localResource.getFile();
                try {
                    if (file != null) {
                        file.delete(true, monitor);
                    }
                }
                catch (CoreException e) {
                    Activator.log(e);
                }
                ++cnt;
            }
            try {
                if (this.project.isOpen()) {
                    this.project.close(monitor);
                }
                this.project.delete(true, monitor);
            }
            catch (CoreException e) {
                Activator.log(e);
            }
            this.status = true;
        }

        public boolean isOK() {
            return this.status;
        }
    }
}

