/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.text.outline;

import jp.sourceforge.tomoyo.core.local.model.domain.AccessPermission;
import jp.sourceforge.tomoyo.core.local.model.domain.Domain;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.ui.editor.text.outline.PolicyActions;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;

public abstract class PolicyOutlineMenuListener
extends PolicyActions
implements IMenuListener {
    protected IProject project;
    protected StructuredViewer viewer;

    public PolicyOutlineMenuListener(IProject project, StructuredViewer viewer) {
        super(project);
        this.project = project;
        this.viewer = viewer;
    }

    protected IStructuredSelection getSelection() {
        return this.getSelection(this.viewer);
    }

    protected IStructuredSelection getSelection(StructuredViewer viewer) {
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        return selection;
    }

    public void menuAboutToShow(IMenuManager manager) {
        IStructuredSelection selection = this.getSelection();
        if (this.areDomainsOnly(selection)) {
            manager.add((IAction)this.createDeleteDomainAction(this.toDomainArray(selection)));
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.createDeleteChildAccessControlAction(selection));
            manager.add((IContributionItem)new Separator());
            Domain[] domainArray = this.toDomainArray(selection);
            manager.add((IAction)this.createChangeProfileAction(domainArray));
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.createKeepDomainAction(domainArray));
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.createInializerAction(domainArray));
            manager.add((IContributionItem)new Separator());
        }
        if (this.areAccessPermissionsOnly(selection, true)) {
            AccessPermission[] accessPermissionArray = this.toAccessPermissionArray(selection);
            manager.add((IAction)this.createDeleteAccessPermissionAction(accessPermissionArray));
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.createPatternizeAccessPermissionAction(accessPermissionArray));
            manager.add((IContributionItem)new Separator());
        }
        if (this.isExceptPolicyElementsOnly(selection)) {
            manager.add((IAction)this.createDeleteElementAction((LocalResource)ProcResourceManager.getInstance().getProcResourceSet(this.project).getExceptPolicy(), selection));
            manager.add((IContributionItem)new Separator());
        }
        if (this.isSystemPolicyElementsOnly(selection)) {
            manager.add((IAction)this.createDeleteElementAction((LocalResource)ProcResourceManager.getInstance().getProcResourceSet(this.project).getSystemPolicy(), selection));
            manager.add((IContributionItem)new Separator());
        }
    }
}

