/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.text.outline;

import jp.sourceforge.tomoyo.core.Utilities;
import jp.sourceforge.tomoyo.core.local.model.PolicyCacheManager;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.PolicyElementDefinition;
import jp.sourceforge.tomoyo.core.local.model.domain.AccessPermission;
import jp.sourceforge.tomoyo.core.local.model.domain.Domain;
import jp.sourceforge.tomoyo.core.local.model.domain.Profile;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileGroup;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileManager;
import jp.sourceforge.tomoyo.core.local.model.status.ProjectProfile;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.CoreEditorOutlineLabelProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public class DomainPolicyOutlineLabelProvider
extends CoreEditorOutlineLabelProvider
implements IColorProvider {
    protected IProject project;
    private boolean isDomainVerbose = false;
    private boolean showResourceCount = false;
    private boolean accessControlVerbose;
    private boolean enableForeColor = false;
    private boolean enableBackColor = false;
    private boolean deletedColoring = false;

    public DomainPolicyOutlineLabelProvider(IProject project) {
        this.project = project;
    }

    private LocalResource getRemoteResource() {
        return ProcResourceManager.getInstance().getProcResourceSet(this.project).getDomainPolicy();
    }

    @Override
    protected void cacheImages() {
        super.cacheImages();
    }

    @Override
    public String getText(Object object) {
        if (object instanceof PolicyElement) {
            PolicyElement element = (PolicyElement)object;
            if (object instanceof Domain) {
                Domain domain = (Domain)element;
                String text = null;
                text = this.isDomainVerbose ? domain.getText() : domain.getProcessName();
                if (this.showResourceCount) {
                    int count = PolicyCacheManager.getInstance().count(this.project, domain, AccessPermission.class, false);
                    text = String.valueOf(text) + " (" + count + ")";
                }
                return text;
            }
            if (object instanceof AccessPermission) {
                if (this.accessControlVerbose) {
                    return element.getText();
                }
                return element.getTextFrom(1);
            }
            if (object instanceof Profile) {
                Profile profile = (Profile)element;
                return profile.getLongName();
            }
            return element.getContents();
        }
        if (object instanceof PolicyElementDefinition) {
            PolicyElementDefinition definition = (PolicyElementDefinition)object;
            return definition.getCaption();
        }
        return super.getText(object);
    }

    @Override
    public Image getImage(Object object) {
        if (object instanceof Domain) {
            Domain domain = (Domain)object;
            if (domain.isKeepDomain() && domain.isInitializerTarget()) {
                return Activator.getImage("initializerTarget+keep_domain.gif");
            }
            if (domain.isKeepDomain()) {
                return Activator.getImage("keep_domain.gif");
            }
            if (domain.isInitializerTarget()) {
                return Activator.getImage("initializerTarget.gif");
            }
            if (domain.isInitializerSource()) {
                return Activator.getImage("initializerSource.gif");
            }
            return this.getRemoteResource().getModel().getElementImage(domain.getClass());
        }
        if (object instanceof AccessPermission) {
            AccessPermission permission = (AccessPermission)object;
            if (permission.isInitializedSource()) {
                return Activator.getImage("initializerSource.gif");
            }
            return Activator.getImage("policy_element.gif");
        }
        if (object instanceof PolicyElementDefinition) {
            PolicyElementDefinition definition = (PolicyElementDefinition)object;
            return definition.getImage();
        }
        return null;
    }

    public void setDomainVerbose(boolean b) {
        this.isDomainVerbose = b;
    }

    public void showResourceCount(boolean b) {
        this.showResourceCount = b;
    }

    public void setGray(boolean selection) {
    }

    public void setAccessControlVerbose(boolean b) {
        this.accessControlVerbose = b;
    }

    public Color getBackground(Object object) {
        if (object instanceof PolicyElement) {
            PolicyElement policyElement = (PolicyElement)object;
            if (policyElement.isDeleted() && this.deletedColoring) {
                return Utilities.getDeletedColor();
            }
            if (policyElement.isCreated()) {
                return Utilities.getCreatedColor();
            }
        }
        if (this.enableBackColor) {
            return this.getColor(object, false);
        }
        return null;
    }

    private Color getColor(Object object, boolean foreGround) {
        if (object instanceof Domain) {
            Domain domain = (Domain)object;
            Profile profile = domain.getProfile();
            if (profile == null) {
                return null;
            }
            int groupNo = Integer.parseInt(profile.getNo());
            ProjectProfile pp = ProfileManager.getInstance().getProjectProfile(this.project);
            ProfileGroup group = pp.getGroup(groupNo);
            if (group == null) {
                return null;
            }
            RGB rgb = foreGround ? group.getForecolor() : group.getBackcolor();
            if (rgb == null) {
                return null;
            }
            return Activator.getDefault().getColor(rgb);
        }
        return null;
    }

    public Color getForeground(Object object) {
        if (object instanceof PolicyElement) {
            PolicyElement policyElement = (PolicyElement)object;
            if (policyElement.isDeleted() && this.deletedColoring) {
                return Activator.getStandardDisplay().getSystemColor(2);
            }
            if (policyElement.isCreated()) {
                return Activator.getStandardDisplay().getSystemColor(2);
            }
        }
        if (this.enableForeColor) {
            return this.getColor(object, true);
        }
        return Activator.getStandardDisplay().getSystemColor(2);
    }

    public boolean isEnableBackColor() {
        return this.enableBackColor;
    }

    public void setBackColorEnabled(boolean enableBackColor) {
        this.enableBackColor = enableBackColor;
    }

    public boolean isEnableForeColor() {
        return this.enableForeColor;
    }

    public void setForeColorEnabled(boolean enableForeColor) {
        this.enableForeColor = enableForeColor;
    }

    public void setColoringEnabled(boolean b) {
        this.setForeColorEnabled(b);
        this.setBackColorEnabled(b);
    }

    public void setDeletetedColoring(boolean b) {
        this.deletedColoring = b;
    }
}

