/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.text.domain;

import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class DomainPolicyKeywordScanner
extends RuleBasedScanner {
    private static Color defaultColor = Display.getCurrent().getSystemColor(2);
    private static Color keywordColor = Display.getCurrent().getSystemColor(12);
    private static Color domainsForeColor = Display.getCurrent().getSystemColor(9);
    private static Color profileForeColor = Display.getCurrent().getSystemColor(10);
    private static Color reserveColor = Display.getCurrent().getSystemColor(10);
    private static final String[] reserveds = new String[]{"dev", "nodev", "exec", "noexec", "suid", "nosuid", "rw", "ro", "atime", "noatime", "diratime", "nodiratime", "recurse", "norecurse", "TCP", "UDP", "RAW", "accept", "bind", "listen", "connect", "inet_tcp_create", "inet_tcp_listen", "inet_tcp_connect", "use_inet_udp", "use_inet_ip", "use_route", "use_packet", "use_kernel_module", "create_fifo", "create_block_dev", "create_char_dev", "create_unix_socket", "SYS_MOUNT", "SYS_UMOUNT", "SYS_REBOOT", "SYS_CHROOT", "SYS_KILL", "SYS_VHANGUP", "SYS_TIME", "SYS_NICE", "SYS_SETHOSTNAME", "SYS_LINK", "SYS_SYMLINK", "SYS_RENAME", "SYS_UNLINK", "SYS_CHMOD", "SYS_CHOWN", "SYS_IOCTL", "SYS_KEXEC_LOAD", "SYS_PIVOT_ROOT", "task.uid", "task.euid", "task.suid", "task.fsuid", "task.gid", "task.egid", "task.sgid", "task.fsgid", "task.pid", "task.ppid", "path1.uid", "path1.gid", "path1.ino", "path1.parent.uid", "path1.parent.gid", "path1.parent.ino", "path2.parent.uid", "path2.parent.gid", "path2.parent.ino"};

    public DomainPolicyKeywordScanner(IProject project) {
        Token defaultToken = new Token((Object)new TextAttribute(defaultColor));
        Token keywordToken = new Token((Object)new TextAttribute(keywordColor, null, 2));
        Token domainsToken = new Token((Object)new TextAttribute(domainsForeColor, null, 2));
        Token profileToken = new Token((Object)new TextAttribute(profileForeColor, null, 2));
        Token reserveToken = new Token((Object)new TextAttribute(reserveColor, null, 2));
        WordRule keywordRule = new WordRule((IWordDetector)new PolicyKeywordDetector(), (IToken)defaultToken);
        int i = 0;
        while (i < reserveds.length) {
            keywordRule.addWord(reserveds[i], (IToken)reserveToken);
            ++i;
        }
        String[] domainDirectives = ProcResourceManager.getInstance().getProcResourceSet(project).getExceptPolicy().getModel().listSupportedDirectives();
        int i2 = 0;
        while (i2 < domainDirectives.length) {
            keywordRule.addWord(domainDirectives[i2], (IToken)keywordToken);
            ++i2;
        }
        IRule[] rules = new IRule[]{new EndOfLineRule("<kernel>", (IToken)domainsToken), new EndOfLineRule("use_profile", (IToken)profileToken), new WhitespaceRule((IWhitespaceDetector)new PolicyWhitespaceDetector()), keywordRule};
        this.setRules(rules);
    }

    static class PolicyKeywordDetector
    implements IWordDetector {
        PolicyKeywordDetector() {
        }

        public boolean isWordPart(char character) {
            return Character.isDigit(character) | Character.isLetter(character) | character == '_';
        }

        public boolean isWordStart(char character) {
            return Character.isDigit(character) | Character.isLetter(character);
        }
    }

    static class PolicyWhitespaceDetector
    implements IWhitespaceDetector {
        PolicyWhitespaceDetector() {
        }

        public boolean isWhitespace(char character) {
            return Character.isWhitespace(character);
        }
    }
}

