/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.form.profile.wizard;

import java.util.ArrayList;
import jp.sourceforge.tomoyo.ui.editor.form.profile.wizard.BasicInformationPage;
import jp.sourceforge.tomoyo.ui.editor.form.profile.wizard.Messages;
import jp.sourceforge.tomoyo.ui.editor.form.profile.wizard.NewProfileCreationCompletePage;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

public class NewProfileWizard
extends Wizard {
    private BasicInformationPage basicPage;
    private NewProfileCreationCompletePage completePage;
    private IProject project;
    private int defaultGroupNo;
    private boolean finished = false;
    private ArrayList<WizardPage> pageList = new ArrayList();
    private int retGroupNo;
    private String retComment = null;
    private int retMacForFile;
    private int retMacForNetwork;
    private int retVerbose;

    public NewProfileWizard(IProject project) {
        this.project = project;
        this.setWindowTitle(Messages.NewProfileWizard_WindowTitle);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.setupHelps();
    }

    private void setupHelps() {
        int cnt = 0;
        while (cnt < this.pageList.size()) {
            WizardPage page = this.pageList.get(cnt);
            PlatformUI.getWorkbench().getHelpSystem().setHelp(page.getControl(), "jp.sourceforge.tomoyo.doc.create_a_new_profile");
            ++cnt;
        }
    }

    public void addPages() {
        this.basicPage = new BasicInformationPage();
        this.basicPage.setDefaultGroupNo(this.defaultGroupNo);
        this.completePage = new NewProfileCreationCompletePage();
        this.addPage((IWizardPage)this.basicPage);
        this.addPage((IWizardPage)this.completePage);
        this.pageList.add(this.basicPage);
        this.pageList.add(this.completePage);
    }

    public void setDefaultGroupNo(int suggestion) {
        this.defaultGroupNo = suggestion;
    }

    public IProject getProject() {
        return this.project;
    }

    public boolean performFinish() {
        this.retGroupNo = this.basicPage.getGroupNo();
        this.retComment = this.basicPage.getComment();
        this.retMacForFile = this.basicPage.getMacForFile();
        this.retMacForNetwork = this.basicPage.getMacForNetwork();
        this.retVerbose = this.basicPage.getVerbose();
        this.finished = true;
        return true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public int getGroupNo() {
        return this.retGroupNo;
    }

    public String getComment() {
        return this.retComment;
    }

    public int getMacForFile() {
        return this.retMacForFile;
    }

    public int getMacForNetwork() {
        return this.retMacForNetwork;
    }

    public int getVerbose() {
        return this.retVerbose;
    }
}

