/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.form.profile;

import java.util.List;
import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import jp.sourceforge.tomoyo.core.local.model.status.Profile;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileGroup;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileManager;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileMetaData;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileTypeChoise;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileTypeRange;
import jp.sourceforge.tomoyo.core.local.model.status.ProjectProfile;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.core.server.ConnectionManager;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.form.PlainFormPage;
import jp.sourceforge.tomoyo.ui.editor.form.ResourceFormPage;
import jp.sourceforge.tomoyo.ui.editor.form.profile.BackColor;
import jp.sourceforge.tomoyo.ui.editor.form.profile.ForeColor;
import jp.sourceforge.tomoyo.ui.editor.form.profile.Messages;
import jp.sourceforge.tomoyo.ui.editor.form.profile.ProfileViewerContentProvider;
import jp.sourceforge.tomoyo.ui.editor.form.profile.ProfileViewerLabelProvider;
import jp.sourceforge.tomoyo.ui.editor.form.profile.wizard.NewProfileWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColorCellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.Section;

public class ProjectProfilePage
extends ResourceFormPage {
    public static final String PAGE_ID = "Profile";
    private Button expandButton;
    private Button collapseButton;
    private Button saveButton;
    private Button rollbackButton;
    private Button newButton;
    ISelection selectionCache = null;
    private TreeViewer treeViewer;
    private static final String TITLE_COLUMN_PROPERTY = "";
    private CellModifier cellModifier;

    public ProjectProfilePage(FormEditor editor) {
        super(editor, PAGE_ID, Messages.ProjectProfilePage_PageTitle);
        this.setContentDescription(Messages.ProjectProfilePage_PageDescription);
    }

    @Override
    protected List<Action> getToolBarActions() {
        List<Action> actionList = super.getToolBarActions();
        this.openEditorAction.setEnabled(false);
        return actionList;
    }

    @Override
    protected LocalResource getLocalResource() {
        return ProcResourceManager.getInstance().getProcResourceSet(this.getProject()).getStatus();
    }

    @Override
    protected String getFormTitle() {
        return Messages.ProjectProfilePage_FormTitle;
    }

    @Override
    protected void createClient(Composite body) {
        Composite composite = new Composite(body, 0);
        GridLayout layout = new GridLayout();
        composite.setBackground(body.getBackground());
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createMainSection(composite);
    }

    protected Section createMainSection(Composite parent) {
        String description;
        Section section = this.getManagedForm().getToolkit().createSection(parent, 384);
        section.setLayoutData((Object)new GridData(4, 4, true, true));
        String title = Messages.ProjectProfilePage_ProfileTableSectionTitle;
        if (title != null) {
            section.setText(title);
        }
        if ((description = Messages.ProjectProfilePage_PageDescription) != null) {
            section.setDescription(description);
        }
        Composite container = this.getManagedForm().getToolkit().createComposite((Composite)section);
        container.setBackground(parent.getBackground());
        container.setLayout((Layout)new GridLayout(2, false));
        GridData data = new GridData(4, 4, true, true, 1, 1);
        container.setLayoutData((Object)data);
        this.treeViewer = this.createProfileTableTree(container);
        this.createButtonContoler(container);
        section.setTextClient((Control)this.createToolbar(section));
        this.getManagedForm().getToolkit().paintBordersFor(container);
        section.setClient((Control)container);
        return section;
    }

    @Override
    protected void restoreDefault() {
        super.restoreDefault();
        this.expandButton.setEnabled(true);
        this.collapseButton.setEnabled(true);
        boolean isConnected = ConnectionManager.getInstance().isConnected(this.getProject());
        this.saveButton.setEnabled(isConnected);
        this.rollbackButton.setEnabled(false);
        this.treeViewer.setInput(this.createModel());
        this.packColumn();
    }

    private void packColumn() {
    }

    @Override
    protected PlainFormPage.Todo[] getTodoList() {
        PlainFormPage.Todo[] todoList = new PlainFormPage.Todo[]{};
        return todoList;
    }

    @Override
    protected void handleTodoLinkEvent(String href) {
    }

    private void createButtonContoler(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.marginLeft = 0;
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        GridData data = new GridData(131072, 4, false, true, 1, 1);
        data.horizontalIndent = 0;
        container.setLayoutData((Object)data);
        this.expandButton = (Button)this.addWidget((Widget)this.createButton(container, Activator.getImage("expandall.gif"), 0));
        this.expandButton.setToolTipText(Messages.ProjectProfilePage_ExpandAllButtonToolTip);
        this.collapseButton = (Button)this.addWidget((Widget)this.createButton(container, Activator.getImage("collapseall.gif"), 0));
        this.collapseButton.setToolTipText(Messages.ProjectProfilePage_CollapseAllButtonToolTip);
        this.saveButton = (Button)this.addWidget((Widget)this.createButton(container, Activator.getImage("save.gif"), 0));
        this.saveButton.setToolTipText(Messages.ProjectProfilePage_SaveChangesButtonToolTip);
        this.rollbackButton = (Button)this.addWidget((Widget)this.createButton(container, Activator.getImage("rollback.gif"), 0));
        this.rollbackButton.setToolTipText(Messages.ProjectProfilePage_ResetChangesButtonToolTip);
        this.newButton = (Button)this.addWidget((Widget)this.createButton(container, Activator.getImage("new.gif"), 0));
        this.newButton.setToolTipText(Messages.ProjectProfilePage_CreateNewProfileButtonToolTip);
    }

    @Override
    protected void handleButtonSelected(Button button) {
        if (button == this.expandButton) {
            if (!this.treeViewer.getSelection().isEmpty()) {
                this.selectionCache = this.treeViewer.getSelection();
            }
            this.treeViewer.getTree().setRedraw(false);
            this.treeViewer.expandAll();
            this.treeViewer.getTree().setRedraw(true);
            if (this.selectionCache == null) {
                this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.treeViewer.getTree().getItem(0)));
            } else {
                this.treeViewer.setSelection(this.selectionCache);
            }
        }
        if (button == this.collapseButton) {
            if (!this.treeViewer.getSelection().isEmpty()) {
                this.selectionCache = this.treeViewer.getSelection();
            }
            this.treeViewer.getTree().setRedraw(false);
            this.treeViewer.collapseAll();
            this.treeViewer.getTree().setRedraw(true);
        }
        if (button == this.saveButton) {
            this.saveProfile();
        }
        if (button == this.rollbackButton) {
            this.rollback();
        }
        if (button == this.newButton) {
            this.startCreateDialog();
        }
    }

    private void saveProfile() {
        ProjectProfile pp = ProfileManager.getInstance().getProjectProfile(this.getProject());
        if (pp.hasDirty()) {
            boolean updateYes = MessageDialog.openQuestion((Shell)Activator.getStandardDisplay().getActiveShell(), (String)Messages.ProjectProfilePage_SaveConfirmationTitle, (String)Messages.ProjectProfilePage_SaveConfirmationMessage);
            if (!updateYes) {
                return;
            }
            boolean isSaved = pp.save();
            if (isSaved) {
                this.treeViewer.refresh();
                this.updateButtonEnabled();
                TomoyoCorePlugin.getDefault().setStatusMessage(STATUS_MSG_SAVED);
            } else {
                TomoyoCorePlugin.getDefault().setStatusErrorMessage(STATUS_MSG_ERROR);
            }
        }
        this.updateButtonEnabled();
    }

    private void rollback() {
        ProjectProfile pp = ProfileManager.getInstance().getProjectProfile(this.getProject());
        pp.rollback();
        this.treeViewer.refresh();
        this.updateButtonEnabled();
    }

    private void startCreateDialog() {
        boolean updateYes;
        ProjectProfile pp = ProfileManager.getInstance().getProjectProfile(this.getProject());
        if (pp.hasDirty() && !(updateYes = MessageDialog.openQuestion((Shell)Activator.getStandardDisplay().getActiveShell(), (String)Messages.ProjectProfilePage_StartWizardConfirmationTitle, (String)Messages.ProjectProfilePage_StartWizardConfirmationMessage))) {
            return;
        }
        NewProfileWizard wizard = new NewProfileWizard(this.getProject());
        wizard.setDefaultGroupNo(pp.getNewGroupNo());
        WizardDialog dialog = new WizardDialog(this.getActiveShell(), (IWizard)wizard){

            protected void configureShell(Shell shell) {
                super.configureShell(shell);
            }
        };
        if (dialog.open() == 0) {
            int profileNo = wizard.getGroupNo();
            ProfileGroup group = pp.createGroup(profileNo);
            group.createProfile("COMMENT").setUpdateValue(wizard.getComment());
            group.createProfile("MAC_FOR_FILE").setUpdateValue(String.valueOf(wizard.getMacForFile()));
            group.createProfile("MAC_FOR_NETWORK").setUpdateValue(String.valueOf(wizard.getMacForNetwork()));
            group.createProfile("TOMOYO_VERBOSE").setUpdateValue(String.valueOf(wizard.getVerbose()));
            boolean isSaved = pp.save();
            if (isSaved) {
                this.addColumn(this.treeViewer, profileNo);
                this.updateColumn();
                this.restoreViewerSelectioned(this.treeViewer);
                this.treeViewer.refresh();
                TomoyoCorePlugin.getDefault().setStatusMessage(STATUS_MSG_SAVED);
            } else {
                TomoyoCorePlugin.getDefault().setStatusErrorMessage(STATUS_MSG_ERROR);
            }
        }
    }

    private TreeViewer createProfileTableTree(Composite parent) {
        TreeViewer viewer = new TreeViewer(parent, 2048);
        GridData layoutData = new GridData(4, 4, true, true);
        viewer.getControl().setLayoutData((Object)layoutData);
        this.setupColumn(viewer);
        viewer.setContentProvider((IContentProvider)new ProfileViewerContentProvider(this.getProject()));
        viewer.setLabelProvider((IBaseLabelProvider)new ProfileViewerLabelProvider(this.getProject(), viewer));
        viewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                StructuredSelection selection = (StructuredSelection)ProjectProfilePage.this.treeViewer.getSelection();
                if (selection.size() == 1 && event.button == 3) {
                    return;
                }
            }

            public void mouseDoubleClick(MouseEvent event) {
                StructuredSelection selection = (StructuredSelection)ProjectProfilePage.this.treeViewer.getSelection();
                if (selection.size() == 1) {
                    if (event.button == 3) {
                        return;
                    }
                    Object object = selection.getFirstElement();
                    if (ProjectProfilePage.this.treeViewer.getExpandedState(object)) {
                        ProjectProfilePage.this.treeViewer.collapseToLevel(object, 1);
                    } else {
                        ProjectProfilePage.this.treeViewer.expandToLevel(object, 1);
                    }
                }
            }
        });
        viewer.getTree().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                ProjectProfilePage.this.handleSelection(event);
            }
        });
        viewer.getTree().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 | e.keyCode == 32) {
                    ISelection selection = ProjectProfilePage.this.treeViewer.getSelection();
                    for (Object object : (IStructuredSelection)selection) {
                        if (ProjectProfilePage.this.treeViewer.getExpandedState(object)) {
                            ProjectProfilePage.this.treeViewer.collapseToLevel(object, 1);
                            continue;
                        }
                        ProjectProfilePage.this.treeViewer.expandToLevel(object, 1);
                    }
                }
            }

            public void keyReleased(KeyEvent arg0) {
            }
        });
        viewer.getControl().addFocusListener((FocusListener)new ResourceFormPage.TreeFocusAdapter(viewer));
        return viewer;
    }

    private void handleSelection(SelectionEvent event) {
        StructuredSelection selection = (StructuredSelection)this.treeViewer.getSelection();
        this.storeViewerSelectioned((Viewer)this.treeViewer, selection);
        this.switchCellEditor();
    }

    private void switchCellEditor() {
        if (this.treeViewer == null) {
            return;
        }
        StructuredSelection selection = (StructuredSelection)this.treeViewer.getSelection();
        if (selection == null) {
            return;
        }
        Object object = selection.getFirstElement();
        if (object == null) {
            return;
        }
        CellEditor[] editors = this.treeViewer.getCellEditors();
        int cnt = 1;
        while (cnt < editors.length) {
            if (object instanceof ProfileMetaData) {
                ProfileMetaData meta = (ProfileMetaData)object;
                if (meta.getType() instanceof ProfileTypeChoise) {
                    ProfileTypeChoise choise = (ProfileTypeChoise)meta.getType();
                    editors[cnt] = new ComboBoxCellEditor((Composite)this.treeViewer.getTree(), choise.choiseTexts, 0x1000000);
                } else {
                    editors[cnt] = new TextCellEditor((Composite)this.treeViewer.getTree(), 0x1000000);
                    editors[cnt].addListener(new ICellEditorListener(){

                        public void applyEditorValue() {
                        }

                        public void cancelEditor() {
                        }

                        public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                        }
                    });
                }
            }
            if (object instanceof Class) {
                Class cls = (Class)object;
                if (cls.equals(String.class)) {
                    editors[cnt] = new TextCellEditor((Composite)this.treeViewer.getTree(), 0x1000000);
                }
                if (cls.equals(ForeColor.class)) {
                    editors[cnt] = new ColorCellEditor((Composite)this.treeViewer.getTree());
                }
                if (cls.equals(BackColor.class)) {
                    editors[cnt] = new ColorCellEditor((Composite)this.treeViewer.getTree());
                }
            }
            ++cnt;
        }
    }

    private void setupColumn(TreeViewer viewer) {
        Tree tree = viewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.createBlankColumn(tree);
        ProfileGroup[] groups = ProfileManager.getInstance().getProjectProfile(this.getProject()).toArray(true);
        String[] properties = new String[groups.length + 1];
        CellEditor[] editors = new CellEditor[groups.length + 1];
        properties[0] = TITLE_COLUMN_PROPERTY;
        editors[0] = null;
        int cnt = 0;
        while (cnt < groups.length) {
            ProfileGroup group = groups[cnt];
            TreeColumn column = new TreeColumn(tree, 0);
            column.setText(group.getLongName());
            column.setAlignment(0x1000000);
            column.setWidth(100);
            column.setData((Object)group.getNo());
            properties[cnt + 1] = String.valueOf(group.getNo());
            editors[cnt + 1] = null;
            ++cnt;
        }
        viewer.setColumnProperties(properties);
        viewer.setCellEditors(editors);
        viewer.setCellModifier(this.createCellModifier(viewer));
    }

    private void addColumn(TreeViewer viewer, int groupNo) {
        Tree tree = viewer.getTree();
        TreeColumn column = new TreeColumn(tree, 0);
        column.setAlignment(0x1000000);
        column.setWidth(100);
        column.setData((Object)groupNo);
        String[] oldProperties = (String[])this.treeViewer.getColumnProperties();
        CellEditor[] oldEditors = this.treeViewer.getCellEditors();
        String[] newProperties = new String[oldProperties.length + 1];
        CellEditor[] newEditors = new CellEditor[oldEditors.length + 1];
        System.arraycopy(oldProperties, 0, newProperties, 0, oldProperties.length);
        System.arraycopy(oldEditors, 0, newEditors, 0, oldEditors.length);
        newProperties[newProperties.length - 1] = String.valueOf(groupNo);
        newEditors[newEditors.length - 1] = null;
        viewer.setColumnProperties(newProperties);
        viewer.setCellEditors(newEditors);
    }

    private void updateColumn() {
        TreeColumn[] columns = this.treeViewer.getTree().getColumns();
        int cnt = 0;
        while (cnt < columns.length) {
            if (cnt != 0) {
                TreeColumn column = columns[cnt];
                Integer groupNo = (Integer)column.getData();
                ProfileGroup group = ProfileManager.getInstance().getProjectProfile(this.getProject()).getGroup(groupNo.intValue());
                columns[cnt].setText(group.getLongName());
            }
            ++cnt;
        }
    }

    private void createBlankColumn(Tree tree) {
        TreeColumn column = new TreeColumn(tree, 0);
        column.setWidth(200);
    }

    protected Object createModel() {
        return ProfileManager.getInstance().getProjectProfile(this.getProject());
    }

    private ICellModifier createCellModifier(TreeViewer viewer) {
        if (this.cellModifier == null) {
            this.cellModifier = new CellModifier(viewer);
        }
        return this.cellModifier;
    }

    private void updateButtonEnabled() {
        boolean dirty = ProfileManager.getInstance().getProjectProfile(this.getProject()).hasDirty();
        this.saveButton.setEnabled(dirty);
        this.rollbackButton.setEnabled(dirty);
    }

    @Override
    protected void notifyConnectionUpdated(IProject project, boolean isConnected) {
        super.notifyConnectionUpdated(project, isConnected);
        if (!this.checkWidgets()) {
            return;
        }
        if (project == this.getProject()) {
            this.saveButton.setEnabled(isConnected);
        }
    }

    @Override
    protected void notifyProfileUpdated(IProject project) {
        super.notifyProfileUpdated(project);
        this.updateColumn();
    }

    @Override
    protected void notifyLocalResourceUpdated(LocalResource localResource) {
        super.notifyLocalResourceUpdated(localResource);
        this.treeViewer.refresh();
        this.updateButtonEnabled();
    }

    @Override
    protected String getHelpPath() {
        return "/jp.sourceforge.tomoyo.doc/html/page-profile.html";
    }

    public class CellModifier
    implements ICellModifier {
        private TreeViewer viewer;
        private Object lastElement = null;

        public CellModifier(TreeViewer viewer) {
            this.viewer = viewer;
        }

        public boolean canModify(Object element, String property) {
            boolean modifiable = false;
            try {
                if (element instanceof ProfileMetaData) {
                    modifiable = this.lastElement == element;
                } else if (element instanceof Class) {
                    modifiable = this.lastElement == element;
                }
                boolean bl = modifiable;
                return bl;
            }
            finally {
                this.lastElement = element;
            }
        }

        public Object getValue(Object element, String property) {
            ProfileGroup group;
            ProjectProfile pp;
            if (property.equals(ProjectProfilePage.TITLE_COLUMN_PROPERTY)) {
                return null;
            }
            CellEditor[] editors = ProjectProfilePage.this.treeViewer.getCellEditors();
            CellEditor editor = editors[1];
            if (element instanceof ProfileMetaData) {
                ProfileMetaData meta = (ProfileMetaData)element;
                pp = ProfileManager.getInstance().getProjectProfile(ProjectProfilePage.this.getProject());
                group = pp.getGroup(Integer.parseInt(property));
                Profile profile = group.getProfile(meta);
                if (editor instanceof TextCellEditor) {
                    if (profile == null) {
                        return ProjectProfilePage.TITLE_COLUMN_PROPERTY;
                    }
                    return profile.getValue();
                }
                if (editor instanceof ComboBoxCellEditor) {
                    if (profile == null) {
                        return new Integer(0);
                    }
                    if (meta.getType() instanceof ProfileTypeChoise) {
                        return new Integer(profile.getValue());
                    }
                }
            }
            if (element instanceof Class) {
                Class cls = (Class)element;
                pp = ProfileManager.getInstance().getProjectProfile(ProjectProfilePage.this.getProject());
                group = pp.getGroup(Integer.parseInt(property));
                if (editor instanceof TextCellEditor) {
                    String description = group.getDescription();
                    if (description == null) {
                        return ProjectProfilePage.TITLE_COLUMN_PROPERTY;
                    }
                    return description;
                }
                if (editor instanceof ColorCellEditor) {
                    RGB color;
                    if (cls.equals(ForeColor.class)) {
                        color = group.getForecolor();
                        if (color == null) {
                            return new RGB(0, 0, 0);
                        }
                        return color;
                    }
                    if (cls.equals(BackColor.class)) {
                        color = group.getBackcolor();
                        if (color == null) {
                            return new RGB(0, 0, 0);
                        }
                        return color;
                    }
                }
                if (editor instanceof ComboBoxCellEditor) {
                    return new Integer(1);
                }
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            ProfileGroup group;
            ProjectProfile pp;
            if (property.equals(ProjectProfilePage.TITLE_COLUMN_PROPERTY)) {
                return;
            }
            TreeItem treeItem = (TreeItem)element;
            if (treeItem.getData() instanceof ProfileMetaData) {
                ProfileMetaData meta = (ProfileMetaData)treeItem.getData();
                pp = ProfileManager.getInstance().getProjectProfile(ProjectProfilePage.this.getProject());
                group = pp.getGroup(Integer.parseInt(property));
                Profile profile = group.getProfile(meta);
                if (profile == null) {
                    profile = group.createProfile(meta);
                }
                if (this.validate(meta, value.toString())) {
                    profile.setUpdateValue(this.translate(value.toString()));
                }
            }
            if (treeItem.getData() instanceof Class) {
                RGB rgb;
                Class cls = (Class)treeItem.getData();
                pp = ProfileManager.getInstance().getProjectProfile(ProjectProfilePage.this.getProject());
                group = pp.getGroup(Integer.parseInt(property));
                if (cls.equals(ForeColor.class)) {
                    rgb = (RGB)value;
                    group.saveForecolor(rgb);
                }
                if (cls.equals(BackColor.class)) {
                    rgb = (RGB)value;
                    group.saveBackcolor(rgb);
                }
                if (cls.equals(String.class)) {
                    String username = (String)value;
                    if (username == null || username.trim().length() == 0) {
                        group.saveDescription(null);
                    } else {
                        group.saveDescription(username);
                    }
                    pp.setUpdate();
                }
            }
            this.viewer.refresh(true);
            ProjectProfilePage.this.updateButtonEnabled();
        }

        private String translate(String string) {
            if (string != null && string.equals("-1")) {
                return null;
            }
            return string;
        }

        private boolean validate(ProfileMetaData meta, String string) {
            if (meta.getType() instanceof ProfileTypeRange) {
                ProfileTypeRange type = (ProfileTypeRange)meta.getType();
                try {
                    int value = Integer.parseInt(string);
                    if (value < type.min || type.max < value) {
                        MessageDialog.openWarning((Shell)ProjectProfilePage.this.getActiveShell(), (String)Messages.ProjectProfilePage_InputErrorDialogTitle, (String)(String.valueOf(Messages.ProjectProfilePage_MustBetweenErrorMessage) + type.min + Messages.ProjectProfilePage_MustBetweenErrorMessageAnd + type.max));
                        return false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    MessageDialog.openWarning((Shell)ProjectProfilePage.this.getActiveShell(), (String)Messages.ProjectProfilePage_InputErrorDialogTitle, (String)Messages.ProjectProfilePage_MustBeNumberErrorMessage);
                    return false;
                }
            }
            return true;
        }
    }
}

