/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.form.profile;

import jp.sourceforge.tomoyo.core.local.model.status.Profile;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileDefinition;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileGroup;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileKind;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileManager;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileMetaData;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileTypeChoise;
import jp.sourceforge.tomoyo.core.local.model.status.ProjectProfile;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.form.profile.BackColor;
import jp.sourceforge.tomoyo.ui.editor.form.profile.ForeColor;
import jp.sourceforge.tomoyo.ui.editor.form.profile.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public class ProfileViewerLabelProvider
implements ITableLabelProvider,
ITableColorProvider,
ITableFontProvider {
    private IProject project;
    private TreeViewer viewer;

    public ProfileViewerLabelProvider(IProject project, TreeViewer viewer) {
        this.project = project;
        this.viewer = viewer;
    }

    protected void cacheImages() {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex == 0) {
            if (element instanceof Integer) {
                Integer id = (Integer)element;
                return ProfileKind.getName((int)id);
            }
            if (element instanceof ProfileMetaData) {
                ProfileMetaData meta = (ProfileMetaData)element;
                return meta.getShortName();
            }
            if (element instanceof String) {
                return Messages.ProfileViewerLabelProvider_Customized;
            }
            if (element instanceof Class) {
                Class elementClass = (Class)element;
                if (elementClass.equals(String.class)) {
                    return Messages.ProfileViewerLabelProvider_CustomizedDescription;
                }
                if (elementClass.equals(ForeColor.class)) {
                    return Messages.ProfileViewerLabelProvider_CustomizedForecolor;
                }
                if (elementClass.equals(BackColor.class)) {
                    return Messages.ProfileViewerLabelProvider_CustomizedBackcolor;
                }
            }
        } else {
            ProfileGroup group;
            ProjectProfile pp;
            if (element instanceof ProfileMetaData) {
                Profile profile;
                ProfileMetaData meta = (ProfileMetaData)element;
                pp = ProfileManager.getInstance().getProjectProfile(this.project);
                if (pp.getGroupCount() >= columnIndex && (profile = (group = pp.toArray(true)[columnIndex - 1]).getProfile(meta)) != null) {
                    return ProfileDefinition.tranlateValue((ProfileMetaData)meta, (Profile)profile);
                }
            }
            if (element instanceof Class) {
                Class elementClass = (Class)element;
                pp = ProfileManager.getInstance().getProjectProfile(this.project);
                if (pp.getGroupCount() >= columnIndex) {
                    RGB rgb;
                    group = pp.getGroup(this.column2no(columnIndex));
                    if (elementClass.equals(ForeColor.class) && (rgb = group.getForecolor()) != null) {
                        return "RGB[" + rgb.red + "," + rgb.green + "," + rgb.blue + "]";
                    }
                    if (elementClass.equals(BackColor.class) && (rgb = group.getBackcolor()) != null) {
                        return "RGB[" + rgb.red + "," + rgb.green + "," + rgb.blue + "]";
                    }
                    if (elementClass.equals(String.class)) {
                        String username = group.getDescription();
                        if (username == null) {
                            return "";
                        }
                        return username;
                    }
                }
            }
        }
        return null;
    }

    private int column2no(int columnIndex) {
        try {
            Object[] properties = this.viewer.getColumnProperties();
            int column = Integer.parseInt(properties[columnIndex].toString());
            return column;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public Color getBackground(Object element, int columnIndex) {
        if (columnIndex > 0 && element instanceof ProfileMetaData) {
            ProfileMetaData meta = (ProfileMetaData)element;
            ProjectProfile pp = ProfileManager.getInstance().getProjectProfile(this.project);
            ProfileGroup group = pp.toArray(true)[columnIndex - 1];
            Profile profile = group.getProfile(meta);
            if (profile != null && profile.isDirty()) {
                return Activator.getStandardDisplay().getSystemColor(15);
            }
        }
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        if (columnIndex > 0 && element instanceof ProfileMetaData) {
            ProfileMetaData meta = (ProfileMetaData)element;
            ProjectProfile pp = ProfileManager.getInstance().getProjectProfile(this.project);
            ProfileGroup group = pp.toArray(true)[columnIndex - 1];
            Profile profile = group.getProfile(meta);
            if (profile != null && meta.getType() instanceof ProfileTypeChoise) {
                if (profile.getValue() == null) {
                    return null;
                }
                int value = Integer.parseInt(profile.getValue());
                switch (value) {
                    case 0: {
                        return Activator.getStandardDisplay().getSystemColor(2);
                    }
                    case 1: {
                        return Activator.getStandardDisplay().getSystemColor(9);
                    }
                    case 2: {
                        return Activator.getStandardDisplay().getSystemColor(11);
                    }
                    case 3: {
                        return Activator.getStandardDisplay().getSystemColor(3);
                    }
                }
            }
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Font getFont(Object element, int columnIndex) {
        if (columnIndex != 0 && element instanceof ProfileMetaData) {
            ProfileMetaData meta = (ProfileMetaData)element;
            ProjectProfile pp = ProfileManager.getInstance().getProjectProfile(this.project);
            ProfileGroup group = pp.toArray(true)[columnIndex - 1];
            Profile profile = group.getProfile(meta);
            if (profile != null && profile.isDirty()) {
                Font defaultFont = this.viewer.getTree().getFont();
                FontData fontData = defaultFont.getFontData()[0];
                fontData.setStyle(2);
                return new Font((Device)Activator.getStandardDisplay(), fontData);
            }
        }
        return null;
    }
}

