/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.form.domain;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.domain.Domain;
import jp.sourceforge.tomoyo.ui.editor.form.domain.DomainSearchDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class DomainSearchDialogObserver
implements Observer {
    private TreeViewer viewer;
    private DomainSearchDialog dialog;
    private String searchText;
    private String matchingMethod;

    public void setDialog(DomainSearchDialog dialog) {
        this.dialog = dialog;
        this.connect();
    }

    public void setViewer(TreeViewer viewer) {
        this.viewer = viewer;
    }

    private void connect() {
        if (this.dialog != null) {
            this.dialog.addObserver(this);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        Hashtable table = (Hashtable)arg;
        String search = (String)table.get("search");
        String method = (String)table.get("method");
        Boolean orient = (Boolean)table.get("orient");
        this.notifySearchConditionChanged(search, method, orient == false);
    }

    public String getSearchText() {
        return this.searchText;
    }

    public void notifySearchConditionChanged(boolean orientation) {
        this.notifySearchConditionChanged(this.getSearchText(), this.matchingMethod, orientation);
    }

    public void notifySearchConditionChanged(String searchText, String method, boolean orientation) {
        if (this.viewer == null || this.viewer.getTree().isDisposed()) {
            return;
        }
        if (searchText == null) {
            return;
        }
        Domain selectedDomain = null;
        StructuredSelection selections = (StructuredSelection)this.viewer.getSelection();
        if (selections.getFirstElement() instanceof Domain) {
            selectedDomain = (Domain)selections.getFirstElement();
        }
        this.searchText = searchText;
        this.matchingMethod = method;
        Object model = this.viewer.getInput();
        if (!(model instanceof PolicyElement)) {
            return;
        }
        PolicyElement element = (PolicyElement)model;
        ArrayList<Domain> matchedDomains = new ArrayList<Domain>();
        boolean foundSelected = false;
        int childCount = element.getChildrenCount();
        int cnt = 0;
        while (cnt < childCount) {
            int childIndex = orientation ? cnt : childCount - cnt - 1;
            PolicyElement child = element.getChild(childIndex);
            if (child instanceof Domain) {
                Domain domain = (Domain)child;
                String filePath = domain.getProcessName();
                String fileName = this.getFileName(filePath);
                if (method.equals("fullpath") && searchText.equals(filePath)) {
                    if (selectedDomain == null || foundSelected) {
                        this.setSelection(domain);
                        return;
                    }
                    matchedDomains.add(domain);
                }
                if (method.equals("execpath") && searchText.equals(fileName)) {
                    if (selectedDomain == null || foundSelected) {
                        this.setSelection(domain);
                        return;
                    }
                    matchedDomains.add(domain);
                }
                if (method.equals("includes") && filePath.indexOf(searchText) > -1) {
                    if (selectedDomain == null || foundSelected) {
                        this.setSelection(domain);
                        return;
                    }
                    matchedDomains.add(domain);
                }
                if (selectedDomain != null && selectedDomain.equals((Object)domain)) {
                    foundSelected = true;
                }
            }
            ++cnt;
        }
        if (matchedDomains.size() > 0) {
            this.setSelection((Domain)matchedDomains.get(0));
        }
        if (this.dialog != null) {
            this.dialog.notifyFound(matchedDomains.size());
        }
    }

    public void setSelection(Domain domain) {
        StructuredSelection selection = new StructuredSelection((Object)domain);
        this.viewer.setSelection((ISelection)selection);
        this.viewer.reveal(selection.getFirstElement());
        this.viewer.refresh();
    }

    private String getFileName(String filePath) {
        int lastidx = filePath.lastIndexOf("/");
        if (lastidx > 0) {
            return filePath.substring(lastidx + 1);
        }
        return filePath;
    }
}

