/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.dialog;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Comparator;
import jp.sourceforge.tomoyo.core.local.model.PolicyCacheManager;
import jp.sourceforge.tomoyo.core.local.model.domain.Domain;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileManager;
import jp.sourceforge.tomoyo.core.local.model.status.ProjectProfile;
import jp.sourceforge.tomoyo.core.server.CommandManager;
import jp.sourceforge.tomoyo.core.server.ConcreteCommand;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.ViewerExpandCollapseKeyListener;
import jp.sourceforge.tomoyo.ui.editor.dialog.Messages;
import jp.sourceforge.tomoyo.ui.editor.form.domain.DomainPolicyPage;
import jp.sourceforge.tomoyo.ui.editor.text.outline.DomainPolicyOutlineLabelProvider;
import jp.sourceforge.tomoyo.ui.editor.text.outline.PolicyOutlineMenuListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

public class CcsTreeDialog
extends TitleAreaDialog {
    private IProject project;
    private static final String DEFAULT_MESSAGE = Messages.CcsTreeDialog_DialogMessage;
    private TreeViewer ccstreeViewer;
    private Button expand;
    private Button collapse;
    private Button showDomain;
    private Button showProfile;
    private Button coloring;
    private Button enableSort;
    private Button refresh;
    private DomainPolicyPage parent;

    public CcsTreeDialog(Shell parentShell, IProject project) {
        super(parentShell);
        this.project = project;
    }

    private IProject getProject() {
        return this.project;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.CcsTreeDialog_ShellTitle);
        shell.setImage(Activator.getImage("new.gif"));
    }

    protected Point getInitialSize() {
        return new Point(700, 500);
    }

    protected int getShellStyle() {
        return 1040;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.CcsTreeDialog_DialogTitle);
        this.setTitleImage(Activator.getImage("newelm_wiz.gif"));
        this.setMessage(DEFAULT_MESSAGE, 0);
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridData data = new GridData(4, 4, true, true);
        dialogArea.setLayoutData((Object)data);
        this.createCCSTreeComposite(dialogArea);
        this.restoreDefault();
        return dialogArea;
    }

    private void restoreDefault() {
        this.ccstreeViewer.setInput(this.getInput());
        this.ccstreeViewer.expandAll();
    }

    private Object getInput() {
        ConcreteCommand command = CommandManager.getInstance().exec(this.project, CommandManager.createCCSToolPath((IProject)this.project, (String)"ccstree"));
        if (command.isSuccessful()) {
            return command.getSTDOut();
        }
        return null;
    }

    protected Control createCCSTreeComposite(Composite parent) {
        Composite container = new Composite(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        container.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        container.setLayoutData((Object)data);
        this.ccstreeViewer = new TreeViewer(container, 2816);
        this.ccstreeViewer.setContentProvider((IContentProvider)new CCSTreeViewerContentProvider());
        this.ccstreeViewer.setLabelProvider((IBaseLabelProvider)new CCSTreeViewerLabelProvider(this.project));
        this.ccstreeViewer.addSelectionChangedListener((ISelectionChangedListener)new CCSTreeViewerSelectionChangeLister());
        this.ccstreeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.ccstreeViewer.getControl().addKeyListener((KeyListener)new ViewerExpandCollapseKeyListener(this.ccstreeViewer));
        this.ccstreeViewer.getControl().addMouseListener((MouseListener)new CCSTreeViewerMouseListener(this.ccstreeViewer));
        this.ccstreeViewer.setSorter((ViewerSorter)new CCSTreeViewerSorter());
        this.createCCSTreeContoler(container);
        this.setupMenuListener(container, this.ccstreeViewer);
        return container;
    }

    private void createCCSTreeContoler(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        container.setLayout((Layout)layout);
        GridData data = new GridData(2);
        container.setLayoutData((Object)data);
        this.expand = this.createButton(container, Activator.getImage("expandall.gif"), 0);
        this.expand.setToolTipText(Messages.CcsTreeDialog_ExpandTreeButtonTooltip);
        this.collapse = this.createButton(container, Activator.getImage("collapseall.gif"), 0);
        this.collapse.setToolTipText(Messages.CcsTreeDialog_CollapseTreeButtonTooltip);
        this.showDomain = this.createButton(container, Activator.getImage("domain.gif"), 2);
        this.showDomain.setToolTipText(Messages.CcsTreeDialog_ShowDomainButtonTooltip);
        this.showProfile = this.createButton(container, Activator.getImage("profile.gif"), 2);
        this.showProfile.setToolTipText(Messages.CcsTreeDialog_ShowProfileButtonTooltip);
        this.coloring = this.createButton(container, Activator.getImage("coloring.gif"), 2);
        this.coloring.setToolTipText(Messages.CcsTreeDialog_EnableColorDecorationButtonTooltip);
        this.enableSort = this.createButton(container, Activator.getImage("sort_asc.gif"), 2);
        this.enableSort.setToolTipText(Messages.CcsTreeDialog_SortOrderButtonTooltip);
        this.refresh = this.createButton(container, Activator.getImage("refresh.gif"), 0);
        this.refresh.setToolTipText(Messages.CcsTreeDialog_RefreshButtonTooltip);
    }

    private Button createButton(Composite parent, Image image, int style) {
        Button button = new Button(parent, style);
        button.setImage(image);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CcsTreeDialog.this.handleRadioButtonSelected((Button)e.getSource());
            }
        });
        GridData data = new GridData();
        data.horizontalIndent = 0;
        data.verticalIndent = 0;
        button.setLayoutData((Object)data);
        return button;
    }

    private void handleRadioButtonSelected(Button button) {
        CCSTreeViewerLabelProvider labelProvider;
        if (button == this.expand) {
            this.ccstreeViewer.expandAll();
        }
        if (button == this.collapse) {
            this.ccstreeViewer.collapseAll();
            this.ccstreeViewer.expandToLevel(2);
        }
        if (button == this.showDomain) {
            labelProvider = (CCSTreeViewerLabelProvider)this.ccstreeViewer.getLabelProvider();
            labelProvider.showDomain(button.getSelection());
            this.ccstreeViewer.refresh();
        }
        if (button == this.showProfile) {
            labelProvider = (CCSTreeViewerLabelProvider)this.ccstreeViewer.getLabelProvider();
            labelProvider.showProfile(button.getSelection());
            this.ccstreeViewer.refresh();
        }
        if (button == this.coloring) {
            labelProvider = (CCSTreeViewerLabelProvider)this.ccstreeViewer.getLabelProvider();
            labelProvider.setColoringEnabled(button.getSelection());
            this.ccstreeViewer.refresh();
        }
        if (button == this.enableSort) {
            CCSTreeViewerSorter sorter = (CCSTreeViewerSorter)this.ccstreeViewer.getSorter();
            sorter.setEnabled(button.getSelection());
            this.ccstreeViewer.refresh();
        }
        if (button == this.refresh) {
            this.restoreDefault();
        }
    }

    private void setupMenuListener(Composite parent, TreeViewer viewer) {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)new CCSTreeViewerMenuListener(this.getProject(), (StructuredViewer)viewer));
        Menu menu = menuManager.createContextMenu((Control)parent);
        viewer.getTree().setMenu(menu);
    }

    public void setParent(DomainPolicyPage parent) {
        this.parent = parent;
    }

    private class Process {
        private int level;
        private int profile;
        private String process;
        private int pid;
        private String domain;
        private Process parent;
        private ArrayList<Process> children = new ArrayList();

        public Process(Process init, Process prev, String line) {
            int idxTrunk = line.indexOf("+- ");
            if (idxTrunk > 0) {
                int blank = idxTrunk - 5;
                this.level = blank / 4 + 1;
            } else {
                this.level = 0;
            }
            this.profile = Integer.parseInt(line.substring(0, 3).trim());
            this.process = init == null ? line.split("[\\s]+")[2] : line.split("[\\s]+")[3];
            this.pid = this.getPID(line);
            this.domain = this.getDomain(line);
            if (init != null) {
                if (this.level == prev.getLevel()) {
                    prev.getParent().addChild(this);
                } else if (this.level > prev.getLevel()) {
                    prev.addChild(this);
                } else {
                    init.addChild(this);
                }
            }
        }

        private int getPID(String line) {
            int str = line.indexOf(" (") + 2;
            int end = line.indexOf(") ");
            return Integer.parseInt(line.substring(str, end));
        }

        private String getDomain(String line) {
            int end = line.indexOf(") ") + 2;
            return line.substring(end);
        }

        public int getLevel() {
            return this.level;
        }

        public int getProfile() {
            return this.profile;
        }

        public String getProcess() {
            return this.process;
        }

        public int getPid() {
            return this.pid;
        }

        public String getDomain() {
            return this.domain;
        }

        private void setParent(Process parent) {
            this.parent = parent;
        }

        private Process getParent() {
            return this.parent;
        }

        public void addChild(Process child) {
            this.children.add(child);
            child.setParent(this);
        }

        public ArrayList<Process> getChildren() {
            return this.children;
        }
    }

    private class CCSTreeViewerContentProvider
    implements ITreeContentProvider {
        private ArrayList<Process> lines = new ArrayList();

        private CCSTreeViewerContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            ArrayList<Process> children = new ArrayList<Process>();
            if (parentElement instanceof String) {
                Process init = this.lines.get(0);
                children.add(init);
                return children.toArray();
            }
            if (parentElement instanceof Process) {
                Process process = (Process)parentElement;
                return process.getChildren().toArray();
            }
            return children.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getElements(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            String stdout = (String)newInput;
            if (stdout == null) {
                return;
            }
            this.lines.clear();
            StringReader reader = new StringReader(stdout);
            BufferedReader bufferdReader = new BufferedReader(reader);
            Process init = null;
            Process prev = null;
            try {
                String line;
                while ((line = bufferdReader.readLine()) != null) {
                    Process process = new Process(init, prev, line);
                    if (init == null) {
                        init = process;
                    }
                    prev = process;
                    this.lines.add(process);
                }
            }
            catch (IOException e) {
                Activator.logException(e);
            }
        }
    }

    private class CCSTreeViewerLabelProvider
    extends DomainPolicyOutlineLabelProvider
    implements IColorProvider {
        private boolean showDomain;
        private boolean showProfile;
        private boolean enableColoring;

        public CCSTreeViewerLabelProvider(IProject project) {
            super(project);
        }

        @Override
        public Image getImage(Object object) {
            if (object instanceof Process) {
                Process process = (Process)object;
                Domain domain = PolicyCacheManager.getInstance().findDomain(this.project, process.getDomain());
                if (domain == null) {
                    return Activator.getImage("domain_notfound.gif");
                }
                return super.getImage(domain);
            }
            return null;
        }

        @Override
        public String getText(Object object) {
            if (object instanceof Process) {
                Process process = (Process)object;
                StringBuffer text = new StringBuffer();
                text.append(process.getProcess());
                text.append(" ");
                text.append("(");
                text.append(process.getPid());
                text.append(")");
                if (this.showProfile) {
                    text.append(" ");
                    text.append("[");
                    text.append(process.getProfile());
                    text.append("]");
                }
                if (this.showDomain) {
                    text.append(" ");
                    text.append(process.getDomain());
                }
                return text.toString();
            }
            return super.getText(object);
        }

        public void showDomain(boolean b) {
            this.showDomain = b;
        }

        public void showProfile(boolean b) {
            this.showProfile = b;
        }

        @Override
        public void setColoringEnabled(boolean b) {
            this.enableColoring = b;
        }

        @Override
        public Color getBackground(Object element) {
            if (this.enableColoring) {
                return this.getColor(element, false);
            }
            return null;
        }

        @Override
        public Color getForeground(Object element) {
            if (this.enableColoring) {
                return this.getColor(element, true);
            }
            return null;
        }

        private Color getColor(Object object, boolean foreGround) {
            if (object instanceof Process) {
                Process process = (Process)object;
                int groupNo = process.getProfile();
                ProjectProfile pp = ProfileManager.getInstance().getProjectProfile(this.project);
                RGB rgb = foreGround ? pp.getGroup(groupNo).getForecolor() : pp.getGroup(groupNo).getBackcolor();
                if (rgb == null) {
                    return null;
                }
                return Activator.getDefault().getColor(rgb);
            }
            return null;
        }
    }

    private class CCSTreeViewerSelectionChangeLister
    implements ISelectionChangedListener {
        private CCSTreeViewerSelectionChangeLister() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            TreeViewer viewer = (TreeViewer)event.getSource();
            ISelection selection = viewer.getSelection();
            Object object = ((IStructuredSelection)selection).getFirstElement();
            if (object == null) {
                return;
            }
            Process process = (Process)object;
            if (CcsTreeDialog.this.parent != null) {
                String strDomain = process.getDomain();
                Domain domain = PolicyCacheManager.getInstance().findDomain(CcsTreeDialog.this.project, strDomain);
                if (domain == null) {
                    CcsTreeDialog.this.setMessage(String.valueOf(Messages.CcsTreeDialog_DomainNotFoundMessage) + " : " + strDomain, 2);
                } else {
                    CcsTreeDialog.this.setMessage(DEFAULT_MESSAGE, 0);
                    CcsTreeDialog.this.parent.setSelection(domain);
                }
            }
        }
    }

    private class CCSTreeViewerMouseListener
    implements MouseListener {
        private TreeViewer viewer;

        public CCSTreeViewerMouseListener(TreeViewer viewer) {
            this.viewer = viewer;
        }

        public void mouseDoubleClick(MouseEvent e) {
            if (e.button == 3) {
                return;
            }
            ISelection selection = this.viewer.getSelection();
            Object object = ((IStructuredSelection)selection).getFirstElement();
            if (this.viewer.getExpandedState(object)) {
                this.viewer.collapseToLevel(object, 1);
            } else {
                this.viewer.expandToLevel(object, 1);
            }
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
        }
    }

    private class CCSTreeViewerSorter
    extends ViewerSorter
    implements Comparator<Object> {
        private boolean enabled;

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.compare(e1, e2);
        }

        @Override
        public int compare(Object e1, Object e2) {
            Process p1 = (Process)e1;
            Process p2 = (Process)e2;
            if (this.enabled) {
                return p1.getProcess().compareTo(p2.getProcess());
            }
            return 0;
        }

        public void setEnabled(boolean b) {
            this.enabled = b;
        }
    }

    private class CCSTreeViewerMenuListener
    extends PolicyOutlineMenuListener {
        public CCSTreeViewerMenuListener(IProject project, StructuredViewer viewer) {
            super(project, viewer);
        }

        @Override
        public void menuAboutToShow(IMenuManager manager) {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            if (selection.getFirstElement() instanceof Process) {
                Process process = (Process)selection.getFirstElement();
                String domainText = process.getDomain();
                Domain domain = PolicyCacheManager.getInstance().findDomain(this.project, domainText);
                manager.add((IAction)this.createKeepDomainAction(new Domain[]{domain}));
            }
        }
    }
}

