/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor;

import jp.sourceforge.tomoyo.core.Utilities;
import jp.sourceforge.tomoyo.core.local.model.DomainPolicyModel;
import jp.sourceforge.tomoyo.core.local.model.ExceptPolicyModel;
import jp.sourceforge.tomoyo.core.local.model.SystemPolicyModel;
import jp.sourceforge.tomoyo.core.local.model.domain.Profile;
import jp.sourceforge.tomoyo.core.local.resource.DomainPolicy;
import jp.sourceforge.tomoyo.core.local.resource.ExceptPolicy;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceSet;
import jp.sourceforge.tomoyo.core.local.resource.SystemPolicy;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.CoreEditorFormToolkit;
import jp.sourceforge.tomoyo.ui.editor.CoreEditorOutlineContainer;
import jp.sourceforge.tomoyo.ui.editor.ICoreEditorOutlinePageProvider;
import jp.sourceforge.tomoyo.ui.editor.ICoreEditorPage;
import jp.sourceforge.tomoyo.ui.editor.form.PlainFormPage;
import jp.sourceforge.tomoyo.ui.editor.form.ProjectPropertySheetPage;
import jp.sourceforge.tomoyo.ui.editor.form.domain.DomainPolicyPage;
import jp.sourceforge.tomoyo.ui.editor.form.except.ExceptionPolicyPage;
import jp.sourceforge.tomoyo.ui.editor.form.outline.ProjectOutlineElement;
import jp.sourceforge.tomoyo.ui.editor.form.overview.ProjectOverviewPage;
import jp.sourceforge.tomoyo.ui.editor.form.profile.ProjectProfilePage;
import jp.sourceforge.tomoyo.ui.editor.form.system.SystemPolicyPage;
import jp.sourceforge.tomoyo.ui.editor.perspective.SwitchPerspectiveThread;
import jp.sourceforge.tomoyo.ui.editor.text.domain.DomainPolicyEditor;
import jp.sourceforge.tomoyo.ui.editor.text.except.ExceptPolicyEditor;
import jp.sourceforge.tomoyo.ui.editor.text.system.SystemPolicyEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class CoreEditor
extends FormEditor
implements IResourceChangeListener {
    private TextEditor editor;
    private CoreEditorOutlineContainer outlinePage = null;
    private PropertySheetPage propertySheet;

    public CoreEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.addPageChangedListener(new IPageChangedListener(){

            public void pageChanged(PageChangedEvent event) {
                CoreEditor.this.handlePageChanged(event);
            }
        });
        Activator.getStandardDisplay().asyncExec((Runnable)new SwitchPerspectiveThread());
    }

    private void handlePageChanged(PageChangedEvent event) {
        if (event.getSelectedPage() instanceof PlainFormPage) {
            PlainFormPage editorPage = (PlainFormPage)event.getSelectedPage();
            editorPage.notifyPageChanged(editorPage);
        }
        if (event.getSelectedPage() instanceof ICoreEditorOutlinePageProvider) {
            ICoreEditorOutlinePageProvider outlinePage = (ICoreEditorOutlinePageProvider)event.getSelectedPage();
            this.getContentOutline().setPageActive(outlinePage.getContentOutlinePage());
        }
        if (event.getSelectedPage() instanceof ICoreEditorPage) {
            ICoreEditorPage corePage = (ICoreEditorPage)event.getSelectedPage();
            corePage.notifyPageActivated();
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.getEditor(0).doSave(monitor);
    }

    public void doSaveAs() {
        IEditorPart editor = this.getEditor(0);
        editor.doSaveAs();
        this.setPageText(0, editor.getTitle());
        this.setInput(editor.getEditorInput());
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage[] pages = CoreEditor.this.getSite().getWorkbenchWindow().getPages();
                    int i = 0;
                    while (i < pages.length) {
                        if (CoreEditor.this.editor != null && ((FileEditorInput)CoreEditor.this.editor.getEditorInput()).getFile().getProject().equals((Object)event.getResource())) {
                            IEditorPart editorPart = pages[i].findEditor(CoreEditor.this.editor.getEditorInput());
                            pages[i].closeEditor(editorPart, true);
                        }
                        ++i;
                    }
                }
            });
        }
    }

    protected void addPages() {
        try {
            this.addPage((IFormPage)new ProjectOverviewPage(this));
            this.addPage((IFormPage)new DomainPolicyPage(this));
            this.addPage((IFormPage)new ExceptionPolicyPage(this));
            if (!Utilities.is20((IProject)this.getProject())) {
                this.addPage((IFormPage)new SystemPolicyPage(this));
            }
            this.addPage((IFormPage)new ProjectProfilePage(this));
            ProcResourceSet projectResource = ProcResourceManager.getInstance().getProcResourceSet(this.getProject());
            this.addEditorPage(new DomainPolicyEditor(this), projectResource.getDomainPolicy().getFile());
            this.addEditorPage(new ExceptPolicyEditor(this), projectResource.getExceptPolicy().getFile());
            if (!Utilities.is20((IProject)this.getProject())) {
                this.addEditorPage(new SystemPolicyEditor(this), projectResource.getSystemPolicy().getFile());
            }
        }
        catch (PartInitException e) {
            Activator.logException(e);
        }
    }

    private void addEditorPage(TextEditor editor, IFile file) throws PartInitException {
        FileEditorInput editorInput = new FileEditorInput(file);
        editor.init(this.getEditorSite(), (IEditorInput)editorInput);
        int index = this.addPage((IEditorPart)editor, editor.getEditorInput());
        this.setPageText(index, editor.getTitle());
    }

    public void openEditorPage(LocalResource localResource) {
        if (localResource instanceof DomainPolicy) {
            this.setActivePage(5);
        }
        if (localResource instanceof ExceptPolicy) {
            this.setActivePage(6);
        }
        if (localResource instanceof SystemPolicy) {
            this.setActivePage(7);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IContentOutlinePage.class)) {
            return this.getContentOutline();
        }
        if (adapter.equals(IPropertySheetPage.class)) {
            return this.getPropertySheet();
        }
        return super.getAdapter(adapter);
    }

    public CoreEditorOutlineContainer getContentOutline() {
        if (this.outlinePage == null) {
            this.outlinePage = new CoreEditorOutlineContainer(this);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                }
            });
            this.outlinePage.addSelectionChangedListener(new ProjectOutlineSelectionChangedListener());
        }
        return this.outlinePage;
    }

    public PropertySheetPage getPropertySheet() {
        if (this.propertySheet == null) {
            this.propertySheet = new ProjectPropertySheetPage();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                }
            });
        }
        return this.propertySheet;
    }

    public String getPartName() {
        return ((FileEditorInput)this.getEditorInput()).getFile().getProject().getName();
    }

    public IProject getProject() {
        return ((FileEditorInput)this.getEditorInput()).getFile().getProject();
    }

    protected FormToolkit createToolkit(Display display) {
        return new CoreEditorFormToolkit(display);
    }

    private class ProjectOutlineSelectionChangedListener
    implements ISelectionChangedListener {
        private ProjectOutlineSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            StructuredSelection selections = (StructuredSelection)event.getSelection();
            if (selections.isEmpty()) {
                return;
            }
            ProjectOutlineElement firstElement = (ProjectOutlineElement)selections.getFirstElement();
            if (firstElement.getObject().equals(DomainPolicyModel.class)) {
                CoreEditor.this.setActivePage("Domain");
            }
            if (firstElement.getObject().equals(ExceptPolicyModel.class)) {
                CoreEditor.this.setActivePage("ExceptionPolicy");
            }
            if (firstElement.getObject().equals(SystemPolicyModel.class)) {
                CoreEditor.this.setActivePage("SystemPolicy");
            }
            if (firstElement.getObject().equals(Profile.class)) {
                CoreEditor.this.setActivePage("Profile");
            }
        }
    }
}

