/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.text.domain;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;

import jp.sourceforge.tomoyo.core.local.model.domain.Domain;
import jp.sourceforge.tomoyo.core.local.resource.DomainPolicy;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.ui.editor.CoreEditor;
import jp.sourceforge.tomoyo.ui.editor.text.PolicyEditor;
import jp.sourceforge.tomoyo.ui.editor.text.outline.PolicyOutlinePage;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.widgets.Composite;

/**
 * This class implements the User editor.
 */
public class DomainPolicyEditor extends PolicyEditor {

    public DomainPolicyEditor(CoreEditor editor) {
		super(editor);
		
		setSourceViewerConfiguration(new DomainPolicySourceViewerConfiguration(this));
	}

	//------------------------------------------------------------------------------------------------
	// Adapters
	//------------------------------------------------------------------------------------------------

	/**
     * Returns the content outline.
     */
    protected PolicyOutlinePage getContentOutline() {
    	if (outline == null) {
			outline = new DomainPolicyOutlinePage(this);
        }
    	return outline;
    }
  
	//------------------------------------------------------------------------------------------------
	// Document model
	//------------------------------------------------------------------------------------------------
	
    public IAdaptable getDocumentModel() {
		DomainPolicy domainPolicy = ProcResourceManager.getInstance().getProcResourceSet(getProject()).getDomainPolicy();
		return domainPolicy.getModel();
    }

	//------------------------------------------------------------------------------------------------
	// Text folding
	//------------------------------------------------------------------------------------------------
    
	private ProjectionSupport projectionSupport;
    
	private ProjectionAnnotationModel annotationModel;
    
	public void createPartControl(Composite parent) {
		super.createPartControl(parent);
		ProjectionViewer viewer =(ProjectionViewer)getSourceViewer();

		projectionSupport = new ProjectionSupport(viewer,getAnnotationAccess(),getSharedColors());
		projectionSupport.install();

		//turn projection mode on
		viewer.doOperation(ProjectionViewer.TOGGLE);

		annotationModel = viewer.getProjectionAnnotationModel();
//		annotationModel.addAnnotationModelListener(new IAnnotationModelListener() {
//			public void modelChanged(IAnnotationModel model) {
//			}
//		});
	}

	protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
		ISourceViewer viewer = new ProjectionViewer(parent, ruler, getOverviewRuler(), isOverviewRulerVisible(), styles);

		// ensure decoration support has been created and configured.
		getSourceViewerDecorationSupport(viewer);

		return viewer;
	}

	private Annotation[] oldAnnotations;

	public void updateFoldingStructure(Hashtable<Domain, Position> positions) {
//		storeFoldingState();
		
		Annotation[] annotations = new Annotation[positions.size()];

		//this will hold the new annotations along
		//with their corresponding positions
		HashMap<DomainAnnotation, Position> newAnnotations = new HashMap<DomainAnnotation, Position>();

		Iterator<Domain> it = positions.keySet().iterator();
		for (int i = 0; it.hasNext(); i++) {
			Domain domain = (Domain)it.next();
			Position position = (Position)positions.get(domain);

			DomainAnnotation annotation = new DomainAnnotation(domain);
/*
			if (isExpanded(domain))
				annotationModel.expand(annotation);
			else
				annotationModel.collapse(annotation);
*/
			annotation.markCollapsed();

			newAnnotations.put(annotation, position);
			annotations[i] = annotation;
		}

		if (oldAnnotations == null)
			annotationModel.modifyAnnotations(oldAnnotations, newAnnotations, null);
		else
//			annotationModel.modifyAnnotations(null, null, annotations);
			annotationModel.modifyAnnotations(oldAnnotations, newAnnotations, null);

		oldAnnotations = annotations;
		
//		restoreFoldingState();
	}
	
	/*
	private boolean isExpanded(Domain domain) {
		if (oldAnnotations == null)
			return false;
		for (int cnt = 0; cnt < oldAnnotations.length; cnt++) {
			if (oldAnnotations[cnt] instanceof DomainAnnotation) {
				DomainAnnotation domAnno = (DomainAnnotation)oldAnnotations[cnt];
				if (domAnno.getDomain().equals(domain)) {
					return oldAnnotations[cnt]
				}
			}
		}
	}
	*/

/*
	private void storeFoldingState() {
		Iterator it = annotationModel.getAnnotationIterator();
		while (it.hasNext()) {
			DomainAnnotation annotation = (DomainAnnotation)it.next();
			Domain domain = annotation.getDomain();
			annoCache.put(domain.getText(), Boolean.valueOf(!annotation.isCollapsed()));
		}
	}

	private void restoreFoldingState() {
		Iterator it = annotationModel.getAnnotationIterator();
		while (it.hasNext()) {
			DomainAnnotation annotation = (DomainAnnotation)it.next();
			Domain domain = annotation.getDomain();
			if (isExpanded(domain))
//				annotationModel.expand(annotation);
				;
			else
				annotationModel.collapse(annotation);
		}
	}

	private Hashtable annoCache = new Hashtable();

	private boolean isExpanded(Domain domain) {
		Boolean b = (Boolean)annoCache.get(domain.getText());
		if (b == null)
			return false;
		return b.booleanValue();
	}
*/	

	private class DomainAnnotation extends ProjectionAnnotation {
		private Domain domain = null;
		public DomainAnnotation(Domain domain) {
			this.domain = domain;
		}
		public Domain getDomain() {
			return domain;
		}
	}
	
	protected void editorContextMenuAboutToShow(IMenuManager menu) {
		super.editorContextMenuAboutToShow(menu);
		/*
		menu.add(new Separator());
		MenuManager subMenu = new MenuManager(Messages.DomainPolicyEditor_PopupMenuFoldDomains);
		menu.add(subMenu);
		subMenu.add(new FoldingAction(true));
		subMenu.add(new FoldingAction(false));
		*/
	}
	
	/*
	private class FoldingAction extends Action {
		private boolean expand;
		public FoldingAction(boolean expand) {
			this.expand = expand;
			if (expand) {
				setText(Messages.DomainPolicyEditor_PopupMenuExpand);
				setImageDescriptor(Activator.getImageDescriptor("unfold.gif")); //$NON-NLS-1$
			} else {
				setText(Messages.DomainPolicyEditor_PopupMenuCollapse);
				setImageDescriptor(Activator.getImageDescriptor("fold.gif")); //$NON-NLS-1$
			}
			setToolTipText(getText());
		}
		public void run() {
			if (annotationModel == null)
				return;
			Iterator it = annotationModel.getAnnotationIterator();
			while (it.hasNext()) {
				Annotation annotation = (Annotation)it.next();				
				if (expand) {
					annotationModel.expand(annotation);
				} else {
					annotationModel.collapse(annotation);
				}
			}
		}
	}
	*/

}
