/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.form.profile;

import java.util.ArrayList;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

import jp.sourceforge.tomoyo.core.Utilities;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileDefinition;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileKind;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileMetaData;
import jp.sourceforge.tomoyo.core.local.model.status.ProjectProfile;

public class ProfileViewerContentProvider implements ITreeContentProvider {

	private static final String USER_PREFERENCE = "preference";
	
	private IProject project;
	
	public ProfileViewerContentProvider(IProject project) {
		this.project = project;
	}
	
	public Object[] getChildren(Object parentElement) {
		ArrayList<Object> list = new ArrayList<Object>();
		if (parentElement instanceof ProjectProfile) {
			list.add(Integer.valueOf(ProfileKind.PROFILE_KIND_FILE));
			list.add(Integer.valueOf(ProfileKind.PROFILE_KIND_NETWORK));
			list.add(Integer.valueOf(ProfileKind.PROFILE_KIND_FILESYSTEM));
			list.add(Integer.valueOf(ProfileKind.PROFILE_KIND_LOG));
			list.add(Integer.valueOf(ProfileKind.PROFILE_KIND_CAPABILITY));
			list.add(Integer.valueOf(ProfileKind.PROFILE_KIND_OTHERS));
			list.add(USER_PREFERENCE);
			return list.toArray();
		}
		if (parentElement instanceof Integer) {
			Integer kind = (Integer)parentElement;
			ProfileMetaData[] metaDatas = ProfileDefinition.getMetaData();
			for (int cnt = 0; cnt < metaDatas.length; cnt++) {
				if (metaDatas[cnt].getKind() == kind.intValue()) {
					if (metaDatas[cnt].isAvailableVersion(Utilities.getTomoyoVersion(project)))
						list.add(metaDatas[cnt]);
				}
			}
			return list.toArray();
		}
		if (parentElement instanceof String) {
			String parentString = (String)parentElement;
			if (parentString.equals(USER_PREFERENCE)) {
				list.add(String.class);
				list.add(ForeColor.class);
				list.add(BackColor.class);
//				list.add(Image.class);
				return list.toArray();
			}
		}
		return new Object[0];
	}

	public boolean hasChildren(Object obj) {
		return getChildren(obj).length > 0;
	}

	public Object[] getElements(Object inputElement) {
		return getChildren(inputElement);
	}

	public Object getParent(Object obj) {
		/*
		if (obj instanceof PolicyElement) {
			PolicyElement element = (PolicyElement)obj;
			return element.getParent();
		}
		*/
		return null;
	}

	public void dispose() {
	}

	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
	}

}
