/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.form.except;		

import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.ui.editor.form.DefinitionPolicyPage;

import org.eclipse.ui.forms.editor.FormEditor;

public class ExceptionPolicyPage extends DefinitionPolicyPage {

	public static final String PAGE_ID = "ExceptionPolicy"; //$NON-NLS-1$

	public ExceptionPolicyPage(FormEditor editor) {
		super(editor, PAGE_ID, Messages.ExceptionPolicyPage_PageTitle);
	}

	//-----------------------------------------------------------------------------------------
	// Overwrides 
	//-----------------------------------------------------------------------------------------
	
	protected LocalResource getLocalResource() {
		return ProcResourceManager.getInstance().getProcResourceSet(getProject()).getExceptPolicy();
	}

    //-----------------------------------------------------------------------------------------
	// Overwrides (form)
	//-----------------------------------------------------------------------------------------

	protected String getFormTitle() {
		return Messages.ExceptionPolicyPage_FormTitle;
	}
	
    //-----------------------------------------------------------------------------------------
	// Overwrides (TODO section)
	//-----------------------------------------------------------------------------------------

	protected Todo[] getTodoList() {
		Todo[] todoList = new Todo[] {
		};
		return todoList;
	}

	protected String getHelpPath() {
		return "/jp.sourceforge.tomoyo.doc/" + "html/" + "page-except.html";
	}

}
