/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.form.domain;

import jp.sourceforge.tomoyo.core.local.model.PolicyCacheManager;
import jp.sourceforge.tomoyo.core.local.model.domain.AccessPermission;
import jp.sourceforge.tomoyo.core.local.model.domain.Domain;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;

public class DomainPolicyOutlineMouseListener implements MouseListener {

	private IProject project;
	private TreeViewer viewer;
	
	public DomainPolicyOutlineMouseListener(IProject project, TreeViewer viewer) {
		this.project = project;
		this.viewer = viewer;
	}
	
	public void mouseDoubleClick(MouseEvent e) {
        if (e.button == 3)
            return;
        ISelection selection = viewer.getSelection();
        Object object = ((IStructuredSelection)selection).getFirstElement();
        if (object == null)
            return;
        if (object instanceof AccessPermission) {
        	AccessPermission permission = (AccessPermission)object;
        	if (permission.isInitializedSource()) {
        		String processName = permission.getContents();
				Domain foundDomain = (Domain)PolicyCacheManager.getInstance().getInitializerTarget(project, processName);
				if (foundDomain == null)
					return;
				StructuredSelection ss = new StructuredSelection(foundDomain);
	        	viewer.setSelection(ss);
        	}
        }
    }
	
	public void mouseDown(MouseEvent e) {
	}
	
	public void mouseUp(MouseEvent e) {
	}

}
