/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor;

import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class EditorUtilities {

	public static void doSaveEditor(IFile file) {
		TomoyoCorePlugin.getStandardDisplay().syncExec(new SaveEditorThread(file));
	}
	
	private static class SaveEditorThread implements Runnable {
		private IFile file;
		public SaveEditorThread(IFile file) {
			this.file = file;
		}
		public void run() {
			IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
			for (int wcnt = 0; wcnt < windows.length; wcnt++) {
				IWorkbenchPage[] pages = windows[wcnt].getPages();
				for (int pcnt = 0; pcnt < pages.length; pcnt++) {
					IEditorPart workEditor = pages[pcnt].findEditor(new FileEditorInput(file));
					if (workEditor != null) {
						workEditor.doSaveAs();
						return;
					}
				}
			}			
		}
	}
	
	public static Color getCreatedColor() {
		return TomoyoCorePlugin.getStandardDisplay().getSystemColor(SWT.COLOR_YELLOW);
	}

	public static Color getDeletedColor() {
		return TomoyoCorePlugin.getStandardDisplay().getSystemColor(SWT.COLOR_GRAY);
	}
	
	public static void closeEditors(IProject project) {
		TomoyoCorePlugin.getStandardDisplay().syncExec(new CloseEditorThread(project));
	}

	private static class CloseEditorThread implements Runnable {
		private IProject project;
		public CloseEditorThread(IProject project) {
			this.project = project;
		}
		public void run() {
			IWorkbench workbench = PlatformUI.getWorkbench();
			IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
			IWorkbenchPage page = window.getActivePage();
			for (int cnt = 0; cnt < page.getEditorReferences().length; cnt++) {
				IEditorReference reference = page.getEditorReferences()[cnt];
				if (reference.getEditor(false) instanceof CoreEditor) {
					CoreEditor editor = (CoreEditor)reference.getEditor(false);
					if (project.equals(editor.getProject()))
						editor.close(true);
				}
			}
		}
	}

}
