/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;

public class CoreEditorOutlineMouseListener implements MouseListener {

	private TreeViewer viewer;
	
	public CoreEditorOutlineMouseListener(TreeViewer viewer) {
		this.viewer = viewer;
	}
	
	public void mouseDoubleClick(MouseEvent e) {
		if (e.button == 3)	// ignore right double click
			return;
		ISelection selection = viewer.getSelection();
		Object object = ((IStructuredSelection)selection).getFirstElement();
		if (viewer.getExpandedState(object))
			viewer.collapseToLevel(object, 1);
		else
			viewer.expandToLevel(object, 1);
	}

	public void mouseDown(MouseEvent e) {
	}
	
	public void mouseUp(MouseEvent e) {
	}

}
