/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;

import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class Activator extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "jp.sourceforge.tomoyo.ui.editor";

	// The shared instance
	private static Activator plugin;
	
	/**
	 * The constructor
	 */
	public Activator() {
		plugin = this;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		
		ResourcesPlugin.getWorkspace().addResourceChangeListener(
				new TomoyoCoreProjectPreCloseListener(), IResourceChangeEvent.PRE_CLOSE);
		ResourcesPlugin.getWorkspace().addResourceChangeListener(
				new TomoyoCoreProjectPreDeleteListener(), IResourceChangeEvent.PRE_DELETE);
		
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static Activator getDefault() {
		return plugin;
	}

	
	private class TomoyoCoreProjectPreCloseListener implements IResourceChangeListener {
		public void resourceChanged(IResourceChangeEvent event) {
			IResource resource = event.getResource();
			if (resource instanceof IProject) {
				prepareCloseProject((IProject)resource);
			}
		}
	}
	
	private class TomoyoCoreProjectPreDeleteListener implements IResourceChangeListener {
		public void resourceChanged(IResourceChangeEvent event) {
			IResource resource = event.getResource();
			if (resource instanceof IProject) {
				prepareCloseProject((IProject)resource);
			}
		}
	}
	
	private void prepareCloseProject(IProject project) {
		EditorUtilities.closeEditors(project);
	}

	/**
	 * Returns the standard display to be used. The method first checks, if
	 * the thread calling this method has an associated disaply. If so, this
	 * display is returned. Otherwise the method returns the default display.
	 */
	public static Display getStandardDisplay() {
		Display display;
		display = Display.getCurrent();
		if (display == null)
			display = Display.getDefault();
		return display;
	}
	
    public static Image getImage(String name) {
    	ImageRegistry registry = getDefault().getImageRegistry();
    	Image image = registry.get(name);
    	if (image == null) {
        	try {
            	URL url = getDefault().getBundle().getEntry("/");
    			image = ImageDescriptor.createFromURL(new URL(url, "icons/" + name)).createImage();
    			registry.put(name, image);
        	} catch (MalformedURLException e) {
    			image = ImageDescriptor.getMissingImageDescriptor().createImage();
    		}
    	}
    	return image;
    }
    
    public static ImageDescriptor getImageDescriptor(String name) {
    	ImageRegistry registry = getDefault().getImageRegistry();
    	ImageDescriptor imageDescriptor = registry.getDescriptor(name);
    	if (imageDescriptor == null) {
        	try {
            	URL url = getDefault().getBundle().getEntry("/");
            	imageDescriptor = ImageDescriptor.createFromURL(new URL(url, "icons/" + name));
    			registry.put(name, imageDescriptor);
        	} catch (MalformedURLException e) {
        		imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
    		}
    	}
    	return imageDescriptor;
    }
    
	private ColorRegistry colorRegistry = new ColorRegistry();
	
	public Color getColor(RGB rgb) {
		return getColor(rgb.red, rgb.green, rgb.blue);
	}
	
	public Color getColor(int r, int g, int b) {
		String key = String.valueOf(r) + "." + String.valueOf(g) + "." + String.valueOf(b);
		if (colorRegistry.get(key) == null) {
			colorRegistry.put(key, new RGB(r, g, b));
		}
		return colorRegistry.get(key);
	}
	
	public static void log(IStatus status) {
		ResourcesPlugin.getPlugin().getLog().log(status);
	}
	
	public static void logErrorMessage(String message) {
		log(new Status(IStatus.ERROR, PLUGIN_ID, IStatus.ERROR, message, null));
	}
	
	public static void logException(
		Throwable e,
		final String title,
		String message) {
		if (e instanceof InvocationTargetException) {
			e = ((InvocationTargetException) e).getTargetException();
		}
		IStatus status = null;
		if (e instanceof CoreException)
			status = ((CoreException) e).getStatus();
		else {
			if (message == null)
				message = e.getMessage();
			if (message == null)
				message = e.toString();
			status = new Status(IStatus.ERROR, PLUGIN_ID, IStatus.OK, message, e);
		}
		ResourcesPlugin.getPlugin().getLog().log(status);
		Display display = getStandardDisplay();
		final IStatus fstatus = status;
		display.asyncExec(new Runnable() {
			public void run() {
				ErrorDialog.openError(null, title, null, fstatus);
			}
		});
	}
	
	public static void logException(Throwable e) {
		logException(e, null, null);
	}
	
	public static void log(Throwable e) {
		if (e instanceof InvocationTargetException)
			e = ((InvocationTargetException) e).getTargetException();
		IStatus status = null;
		if (e instanceof CoreException)
			status = ((CoreException) e).getStatus();
		else
			status =
				new Status(IStatus.ERROR, PLUGIN_ID, IStatus.OK, e.getMessage(), e);
		log(status);
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.views.markers.internal.TableView#getDialogSettings()
	 */
	public IDialogSettings getDialogSettings(String sectionName) {
		IDialogSettings workbenchSettings = getDefault().getDialogSettings();
		IDialogSettings settings = workbenchSettings.getSection(sectionName);
		if (settings == null) {
			settings = workbenchSettings.addNewSection(sectionName);
		}
		return settings;
	}

	public boolean isTomoyoCoreProject(IProject project) {
		return TomoyoCorePlugin.isTomoyoCoreProject(project);
	}
	
}
