/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.ui.propertysheet.status;

import jp.sourceforge.tomoyo.core.local.model.status.ProfileMetaData;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ProfileMetaPropertySource implements IPropertySource {
	
	private static final String PROPERTY_ID_PROFILE = "id.profile"; //$NON-NLS-1$
	private static final String PROPERTY_ID_DESCRIPTION = "id.desciption"; //$NON-NLS-1$

	private ProfileMetaData element;
	
	public ProfileMetaPropertySource(ProfileMetaData element) {
		this.element = element;
	}

	public Object getEditableValue() {
		return null;
	}

	public IPropertyDescriptor[] getPropertyDescriptors() {
	    IPropertyDescriptor[] descriptor = new IPropertyDescriptor[] {
	    		new PropertyDescriptor(PROPERTY_ID_PROFILE, Messages.ProfileMetaPropertySource_ProfileName),
	    		new PropertyDescriptor(PROPERTY_ID_DESCRIPTION, Messages.ProfileMetaPropertySource_Description),
	    };
	    return descriptor;
	}

	public Object getPropertyValue(Object id) {
		if (id == null)
			return null;
		if (id.equals(PROPERTY_ID_PROFILE))
			return element.getName();
		if (id.equals(PROPERTY_ID_DESCRIPTION))
			return element.getDescription();
		return null;
	}

	public boolean isPropertySet(Object id) {
		return false;
	}

	public void resetPropertyValue(Object id) {
	}

	public void setPropertyValue(Object id, Object value) {
	}

}
