/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.ui.propertysheet.except;

import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.ui.propertysheet.ElementPropertySource;

public class KeepDomainPropertySource extends ElementPropertySource {
	
	public KeepDomainPropertySource(PolicyElement element) {
		super(element);
	}

	private static final String PROPERTY_ID_DIRECTIVE = "id.directive"; //$NON-NLS-1$
	private static final String PROPERTY_ID_PROGRAM = "id.program"; //$NON-NLS-1$
	private static final String PROPERTY_ID_FROM = "id.from"; //$NON-NLS-1$

	protected String[] getPropertyIDs() {
		if (element.getTextFieldCount() == 2) {
			return new String[] {
					PROPERTY_ID_DIRECTIVE,
					PROPERTY_ID_PROGRAM,
			};
		} else {
			return new String[] {
					PROPERTY_ID_DIRECTIVE,
					PROPERTY_ID_PROGRAM,
					PROPERTY_ID_FROM,
			};
		}
	}

	protected String getPropertyName(String propertyID) {
		if (propertyID.equals(PROPERTY_ID_DIRECTIVE))
			return Messages.Directive;
		if (propertyID.equals(PROPERTY_ID_PROGRAM))
			return Messages.KeepDomainPropertySource_Program;
		if (propertyID.equals(PROPERTY_ID_FROM))
			return Messages.KeepDomainPropertySource_From;
		return null;
	}

	public Object getPropertyValue(Object id) {
		if (id == null)
			return null;
		if (id.equals(PROPERTY_ID_DIRECTIVE))
			return "" + element.getTextFieldCount(); //$NON-NLS-1$
		if (id.equals(PROPERTY_ID_PROGRAM))
			return element.getText(1);
		if (element.getTextFieldCount() == 4) {
			if (id.equals(PROPERTY_ID_FROM))
				return element.getText(3);
		}
		return null;
	}

}
