/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.server;

import java.util.Observable;

import jp.sourceforge.tomoyo.core.PersistentPropertyManager;
import jp.sourceforge.tomoyo.core.ProjectProperty;
import jp.sourceforge.tomoyo.core.ProjectPropertyManager;
import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import jp.sourceforge.tomoyo.core.Utilities;
import jp.sourceforge.tomoyo.core.extensions.IConnectionAdapter;
import jp.sourceforge.tomoyo.core.local.resource.IProcFile;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;

import org.eclipse.core.resources.IProject;

public class CommandManager extends Observable {
	
	public static final String CMD_CCSTREE = "ccstree";
	public static final String CMD_SETLEVEL = "setlevel";
	public static final String CMD_SETPROFILE = "setprofile";
	public static final String CMD_SAVEPOLICY = "savepolicy";
	public static final String CMD_LOADPOLICY = "loadpolicy";
	public static final String CMD_EDITPOLICY = "editpolicy";
	public static final String CMD_SORTPOLICY = "sortpolicy";
	
	public static final String CMD_SYSTEM_LN = "ln";
	public static final String CMD_SYSTEM_SORT = "sort";
	
	private static CommandManager instance;
	
	public static CommandManager getInstance() {
		if (instance == null)
			instance = new CommandManager();
		return instance;
	}
	
	public ConcreteCommand exec(IProject project, String strCommand) {
		return exec(project, strCommand, null, null, new int[] {0});
	}
	
	public ConcreteCommand exec(IProject project, String strCommand, String[] options, String[] args) {
		return exec(project, strCommand, options, args, new int[] {0});
	}
	
	public ConcreteCommand exec(IProject project, String strCommand, String[] options, String[] args, int[] okSystemCodes) {
		ConcreteCommand command = new ConcreteCommand(project, strCommand, options, args, okSystemCodes);
		IConnectionAdapter connectionMgr = Utilities.getConnectionAdapter(command.getProject());
		if (connectionMgr.exec(command)) {
			;
		} else {
			TomoyoCorePlugin.logErrorMessage("Command exec failure : status = " + command.getSystemStatusCode() + " cmd = " + command.toString());
		}
		notifyResult(command);
		return command;
	}

	public ReadCommand read(IProject project, LocalResource localResource) {
		return read(project, getServerProcPath(localResource), localResource.getSorterCommand());
	}
	
	public ReadCommand read(IProject project, String source) {
		return read(project, source, null);
	}
	
	public ReadCommand read(IProject project, String source, String sorterCommand) {
		ReadCommand command = new ReadCommand(project, source, sorterCommand);
		IConnectionAdapter connectionMgr = Utilities.getConnectionAdapter(command.getProject());
		if (connectionMgr.read(command)) {
			;
		} else {
			TomoyoCorePlugin.logErrorMessage("Command exec failure : status = " + command.getSystemStatusCode() + " cmd = " + command.toString());
		}
		notifyResult(command);
		return command;
	}

	public WriteCommand write(IProject project, LocalResource localResource, String inputText) {
		return write(project, getServerProcPath(localResource), inputText, false);
	}
	
	public WriteCommand write(IProject project, String target, String inputText) {
		return write(project, target, inputText, false);
	}
	
	public WriteCommand write(IProject project, String target, String inputText, boolean append) {
		return write(project, target, inputText, append, null);
	}
	
	public WriteCommand write(IProject project, String target, String inputText, boolean append, String filter) {
		WriteCommand wCommand = new WriteCommand(project, target, inputText, append);
		wCommand.setFilter(filter);
		IConnectionAdapter connectionMgr = Utilities.getConnectionAdapter(wCommand.getProject());
		if (connectionMgr.write(wCommand)) {
			;
		} else {
			TomoyoCorePlugin.logErrorMessage("Command exec failure : status = " + wCommand.getSystemStatusCode() + " cmd = " + wCommand.toString());
		}
		notifyResult(wCommand);
		return wCommand;
	}


	public String getSelfDomain(IProject project) {
		IConnectionAdapter connectionMgr = Utilities.getConnectionAdapter(project);
		return connectionMgr.getSelfDomain(project);
	}

	private void notifyResult(ICommand command) {
		setChanged();
		notifyObservers(command);
	}

	public static String createCCSToolPath(IProject project, String toolName) {
		ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(project);
		return concatServerPath(properties.getProperty(PersistentPropertyManager.PROPERTY_CCS_TOOL_DIRECTORY), toolName);
	}

	public static String createCCSDataPath(IProject project, String fileName) {
		ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(project);
		return concatServerPath(properties.getProperty(PersistentPropertyManager.PROPERTY_CCS_DATA_DIRECTORY), fileName);
	}
	
	public static String getServerProcPath(LocalResource localResource) {
		if (localResource instanceof IProcFile) {
			IProcFile proc = (IProcFile)localResource;
			return proc.getProcPath();
		}
		throw new IllegalArgumentException("Argument " + localResource + " is not supported.");
	}

	private static final String SERVER_PATH_DELIMITER = "/";

	private static String concatServerPath(String directory, String file) {
		if (directory == null)
			throw new IllegalArgumentException("Argment directory is null.");
		if (directory.endsWith(SERVER_PATH_DELIMITER))
			return directory + file;
		else
			return directory + SERVER_PATH_DELIMITER + file;
	}

}
