/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.local.parser;

import java.util.regex.Matcher;

import jp.sourceforge.tomoyo.core.local.model.PolicyCacheManager;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.PolicyElementDefinition;
import jp.sourceforge.tomoyo.core.local.model.AbstractPolicyModel;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;

public class SystemPolicyParser extends PolicyParser {

	public SystemPolicyParser(LocalResource localResource) {
		super(localResource);
	}

	protected PolicyElement parseLine(AbstractPolicyModel model, String line, int lineno, int column) {
		PolicyElement retElement = null;
		
		Matcher matcher =  getMatchingPattern().matcher(line);
		if (matcher.matches()) {
			String directive = matcher.group(1);
			PolicyElement element;
			PolicyElementDefinition definition = getLocalResource().getModel().getDefinitionByDirective(directive);
			if (definition == null) {
				return null;
			}
			if ((element = PolicyCacheManager.getInstance().findElement(model.getProject(), definition.getElementClass(), line)) == null) {
				element = definition.createElement(directive, line, lineno, column);
				element.setCreated(model.isValid());
				
				PolicyCacheManager.getInstance().addElement(model.getProject(), element);
				model.addChild(element);
			} else {
				element.setLineno(lineno);
				element.setOffset(column);
				element.setCreated(false);
			}

			element.setChecked(true);
			
			retElement = element;
		}
		
		return retElement;
	}

	protected void handleParseAboutToStart() {
	}

	protected void handleParseCompleted() {
	}
	
}
