/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.local.model.status;

import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.graphics.RGB;

public class ProfileGroup {
	
	private int no;

	private Profile[] profiles = new Profile[ProfileDefinition.getProfileCount()];

	public ProfileGroup(int id) {
		super();
		this.no = id;
	}

	public int getNo() {
		return no;
	}
	
	public void setNo(int id) {
		this.no = id;
	}
	
	public void storeProfileValue(String strProfileName, String strProfileValue) {
		int index = ProfileDefinition.getIndexByName(strProfileName);
		profiles[index] = new Profile(index, strProfileValue);
	}
	
	public Profile getProfile(ProfileMetaData meta) {
		int index = ProfileDefinition.getIndexByName(meta.getName());
		return profiles[index];
	}
	
	public Profile createProfile(String name) {
		int index = ProfileDefinition.getIndexByName(name);
		profiles[index] = new Profile(index, null);
		return profiles[index];
	}
	
	public Profile createProfile(ProfileMetaData meta) {
		int index = ProfileDefinition.getIndexByName(meta.getName());
		profiles[index] = new Profile(meta);
		return profiles[index];
	}
	
	public boolean hasProfile(ProfileMetaData meta) {
		int index = ProfileDefinition.getIndexByName(meta.getName());
		return (profiles[index] != null);
	}
	
	public String getComment() {
		Profile comment = profiles[1];
		if (comment == null)
			return "";
		return comment.getValue();
	}
	
	public String getName() {
		return getComment();
	}
	
	public boolean equals(Object obj) {
		if (obj instanceof ProfileGroup) {
			ProfileGroup target = (ProfileGroup)obj;
			return target.getNo() == getNo();
		}
		return super.equals(obj);
	}

	public Profile[] listProfile() {
		return profiles;
	}

	//----------------------------------------------------------------------------------------------
	// Dialog settings
	//----------------------------------------------------------------------------------------------
	
	private static final String SETTINGS_DESCRIPTION = "settings.description";
	
	public String getDescription() {
	    IDialogSettings settings = TomoyoCorePlugin.getDefault().getDialogSettings(ProfileGroup.class.getName());
	    
	    IDialogSettings subSettings = settings.getSection(SETTINGS_DESCRIPTION);
	    if (subSettings == null)
	    	subSettings = settings.addNewSection(SETTINGS_DESCRIPTION);

	    return subSettings.get(String.valueOf(getNo()));
	}

	public void saveDescription(String description) {
	    IDialogSettings settings = TomoyoCorePlugin.getDefault().getDialogSettings(ProfileGroup.class.getName());

	    IDialogSettings subSettings = settings.getSection(SETTINGS_DESCRIPTION);
	    if (subSettings == null)
	    	subSettings = settings.addNewSection(SETTINGS_DESCRIPTION);

	    subSettings.put(String.valueOf(getNo()), description);
	}

	private static final String SETTINGS_FORECOLOR = "settings.forecolor";
	private static final String SETTINGS_BACKCOLOR = "settings.backcolor";

	public RGB getForecolor() {
		return getColor(SETTINGS_FORECOLOR);
	}

	public void saveForecolor(RGB rgb) {
		saveColor(SETTINGS_FORECOLOR, rgb);
	}

	public RGB getBackcolor() {
		return getColor(SETTINGS_BACKCOLOR);
	}

	public void saveBackcolor(RGB rgb) {
		saveColor(SETTINGS_BACKCOLOR, rgb);
	}

	private RGB getColor(String setting) {
	    IDialogSettings settings = TomoyoCorePlugin.getDefault().getDialogSettings(ProfileGroup.class.getName());
	    
	    IDialogSettings subSettings = settings.getSection(setting);
	    if (subSettings == null)
	    	subSettings = settings.addNewSection(setting);
	    
		String[] array = subSettings.getArray(String.valueOf(getNo()));
		RGB color = null;
		if (array != null)
			color = new RGB(Integer.parseInt(array[0]), Integer.parseInt(array[1]), Integer.parseInt(array[2]));
		return color;
	}

	private void saveColor(String setting, RGB rgb) {
	    IDialogSettings settings = TomoyoCorePlugin.getDefault().getDialogSettings(ProfileGroup.class.getName());

	    IDialogSettings subSettings = settings.getSection(setting);
	    if (subSettings == null)
	    	subSettings = settings.addNewSection(setting);
	    
		String r = Integer.valueOf(rgb.red).toString();
		String g = Integer.valueOf(rgb.green).toString();
		String b = Integer.valueOf(rgb.blue).toString();

		subSettings.put(String.valueOf(getNo()), new String[] { r, g, b });
	}

	public String getLongName() {
		StringBuffer line = new StringBuffer();
		line.append(getNo());
		if (getDescription() == null || getDescription().trim().equals("")) {
			if (getComment() != null) {
				line.append(" - ");
				line.append(getComment());
			}
		}
		if (getDescription() != null) {
			line.append(" - ");
			line.append(getDescription());
		}
		return line.toString();
	}
	
}
