/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.local.model;

import java.util.ArrayList;

import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import jp.sourceforge.tomoyo.core.Utilities;
import jp.sourceforge.tomoyo.core.local.model.except.AddressGroup;
import jp.sourceforge.tomoyo.core.local.model.except.Aggregator;
import jp.sourceforge.tomoyo.core.local.model.except.Alias;
import jp.sourceforge.tomoyo.core.local.model.except.AllowRead;
import jp.sourceforge.tomoyo.core.local.model.except.DenyRewrite;
import jp.sourceforge.tomoyo.core.local.model.except.FilePattern;
import jp.sourceforge.tomoyo.core.local.model.except.InitializeDomain;
import jp.sourceforge.tomoyo.core.local.model.except.Initializer;
import jp.sourceforge.tomoyo.core.local.model.except.KeepDomain;
import jp.sourceforge.tomoyo.core.local.model.except.NoInitializeDomain;
import jp.sourceforge.tomoyo.core.local.model.except.NoInitializer;
import jp.sourceforge.tomoyo.core.local.model.except.NoKeepDomain;
import jp.sourceforge.tomoyo.core.local.model.except.PathGroup;

import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySource;

public class ExceptPolicyModel extends AbstractPolicyModel {

	public ExceptPolicyModel(IProject project) {
		super(project);
	}

	@Override
	public String getPolicyModelName() {
		return Messages.PolicyElementManager_Class_ExceptPolicyElement;
	}

	@Override
	public Image getImage() {
		return TomoyoCorePlugin.getImage("except_policy.gif"); //$NON-NLS-1$;
	}

	private static ArrayList<PolicyElementDefinition> definitions = null;
	
	@Override
	public ArrayList<PolicyElementDefinition> listElementDefinitions() {
		if (definitions != null)
			return definitions;
		
		definitions = new ArrayList<PolicyElementDefinition>();
		
		definitions.add(new PolicyElementDefinition(
				"path_group", //$NON-NLS-1$
				PathGroup.class,
				"path_group", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"), //$NON-NLS-1$
				Utilities.T_VER_ALL
		));
		definitions.add(new PolicyElementDefinition(
				"address_group", //$NON-NLS-1$
				AddressGroup.class,
				"address_group", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"), //$NON-NLS-1$
				Utilities.T_VER_1x
		));
		definitions.add(new PolicyElementDefinition(
				"file_pattern", //$NON-NLS-1$
				FilePattern.class,
				"file_pattern", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"), //$NON-NLS-1$
				Utilities.T_VER_ALL
		));
		definitions.add(new PolicyElementDefinition(
				"allow_read", //$NON-NLS-1$
				AllowRead.class,
				"allow_read", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"), //$NON-NLS-1$
				Utilities.T_VER_ALL
		));
		definitions.add(new PolicyElementDefinition(
				"deny_rewrite", //$NON-NLS-1$
				DenyRewrite.class,
				"deny_rewrite", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"), //$NON-NLS-1$
				Utilities.T_VER_ALL
		));
		definitions.add(new PolicyElementDefinition(
				"alias", //$NON-NLS-1$
				Alias.class,
				"alias", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"), //$NON-NLS-1$
				Utilities.T_VER_ALL
		));
		definitions.add(new PolicyElementDefinition(
				"aggregator", //$NON-NLS-1$
				Aggregator.class,
				"aggregator", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"), //$NON-NLS-1$
				Utilities.T_VER_ALL
		));
		definitions.add(new PolicyElementDefinition(
				"initialize_domain", //$NON-NLS-1$
				InitializeDomain.class,
				"initialize_domain", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"), //$NON-NLS-1$
				Utilities.T_VER_ALL
		));
		definitions.add(new PolicyElementDefinition(
				"initializer", //$NON-NLS-1$
				Initializer.class,
				"initializer", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"), //$NON-NLS-1$
				Utilities.T_VER_ALL
		));
		definitions.add(new PolicyElementDefinition(
				"no_initialize_domain", //$NON-NLS-1$
				NoInitializeDomain.class,
				"no_initialize_domain", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"), //$NON-NLS-1$
				Utilities.T_VER_ALL
		));
		definitions.add(new PolicyElementDefinition(
				"no_initializer", //$NON-NLS-1$
				NoInitializer.class,
				"no_initializer", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"), //$NON-NLS-1$
				Utilities.T_VER_ALL
		));
		definitions.add(new PolicyElementDefinition(
				"keep_domain", //$NON-NLS-1$
				KeepDomain.class,
				"keep_domain", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"), //$NON-NLS-1$
				Utilities.T_VER_ALL
		));
		definitions.add(new PolicyElementDefinition(
				"no_keep_domain", //$NON-NLS-1$
				NoKeepDomain.class,
				"no_keep_domain", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"), //$NON-NLS-1$
				Utilities.T_VER_ALL
		));
		
		return definitions;
	}
	
	@Override
	protected IPropertySource createPropertySource() {
		return null;
	}

}
