/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.extensions;

import java.io.Serializable;

public class AuditLog implements Serializable {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private String projectName = null;

	private String hostName = null;
	
	private String[] lines;
	
	private boolean granted;
	
//	private String[] parts = new String[AuditLogFilter.getLogItemCount()];
	private String[] parts = new String[30];
	
	public AuditLog(String projectName, String hostName, boolean b, String[] lineArray) {
		this.projectName = projectName;
		this.hostName = hostName;
		granted = b;
		lines = lineArray;
		parse();
	}
	
	public String get(int index) {
		return parts[index];
	}
	
	public String getMessage() {
		return parts[0];
	}
	
	public String getDate() {
		return parts[1];
	}
	
	public String getProjectName() {
		return parts[2];
	}
	
	public String getProfile() {
		return parts[3];
	}
	
	public String getHost() {
		return parts[4];
	}
	
	public String getDomain() {
		return parts[5];
	}
	
	public String getPermission() {
		return parts[6];
	}
	
	public String getPath() {
		return parts[7];
	}
	
	public String getPid() {
		return parts[8];
	}
	
	public String getUid() {
		return parts[9];
	}
	
	public String getGid() {
		return parts[10];
	}
	
	public String getEuid() {
		return parts[11];
	}
	
	public String getEgid() {
		return parts[12];
	}
	
	public String getSuid() {
		return parts[13];
	}
	
	public String getSgid() {
		return parts[14];
	}
	
	public String getFsuid() {
		return parts[15];
	}
	
	public String getFsgid() {
		return parts[16];
	}
	
	public boolean isGranted() {
		return granted;
	}
	
	public String[] getLines() {
		return lines;
	}
	
	public String toString() {
		return lines[1] + " " + lines[2];
	}
	/*
	public IProject getProject() {
		return project;
	}
	*/
	
	private void parse() {
		String[] line1 = lines[0].split("[\\s]+"); //$NON-NLS-1$
		String   line2 = lines[1];
		String[] line3 = lines[2].split("[\\s]+"); //$NON-NLS-1$
		parts[0] = granted ? "Granted" : "Rejected";
		StringBuffer datetime = new StringBuffer(line1[0] + " " + line1[1]); //$NON-NLS-1$
		datetime.deleteCharAt(0);
		datetime.deleteCharAt(datetime.length() - 1);
		parts[1] = datetime.toString();
		parts[2] = projectName;
		parts[4] = hostName;
		parts[5] = line2;
		parts[6] = line3[0];
		parts[7] = "";
		if (line3.length > 1) {
			for (int cnt = 1; cnt < line3.length; cnt++) {
				parts[7] += line3[cnt];
				if (cnt < line3.length - 1)
					parts[7] += " ";
			}
		}
		parts[8] = line1[2].split("=")[1]; //$NON-NLS-1$
		parts[9] = line1[3].split("=")[1]; //$NON-NLS-1$
		parts[10] = line1[4].split("=")[1]; //$NON-NLS-1$
		parts[11] = line1[5].split("=")[1]; //$NON-NLS-1$
		parts[12] = line1[6].split("=")[1]; //$NON-NLS-1$
		parts[13] = line1[7].split("=")[1]; //$NON-NLS-1$
		parts[14] = line1[8].split("=")[1]; //$NON-NLS-1$
		parts[15] = line1[9].split("=")[1]; //$NON-NLS-1$
		parts[16] = line1[10].split("=")[1]; //$NON-NLS-1$
/*		
		Domain domain = ElementCacheManager.getInstance().findDomain(project, getDomain());
		if (domain != null) {
			Profile profile = domain.getProfile();
			if (profile != null)
				parts[3] = profile.getLongName();
		}
*/		
	}
	
}
