/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core;

import java.util.Hashtable;

import org.eclipse.core.resources.IProject;

public class ProjectPropertyManager {
	
	private static ProjectPropertyManager instance;
	
	private static Hashtable<String, ProjectProperty> cache = new Hashtable<String, ProjectProperty>();

	private ProjectPropertyManager() {
	}
	
	public static ProjectPropertyManager getInstance() {
		if (instance == null)
			instance = new ProjectPropertyManager();
		return instance;
	}
	
	public ProjectProperty getProperty(IProject project) {
		if (project == null || !project.isOpen())
			return null;
		if (cache.get(project.getName()) == null) {
			ProjectProperty property = new ProjectProperty(project);
			cache.put(project.getName(), property);
		}
		return cache.get(project.getName());
	}

	public void removeCache(IProject project) {
		if (project == null)
			return;
		cache.remove(project.getName());
	}
	
}
