/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject;

import java.lang.reflect.InvocationTargetException;

import jp.sourceforge.tomoyo.base.ssh.Activator;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceSet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public class DownloadResourcePage extends AbstractWizardPage {

	private Button downloadButton;
	
	public DownloadResourcePage() {
		super(Messages.DownloadResourcePage_PageTitle);
		setTitle(Messages.DownloadResourcePage_PageTitle);
		setDescription(Messages.DownloadResourcePage_PageDesription);
		setPageComplete(false);
	}

	protected String getHelpResourceName() {
		return "download_resource";
	}

	private Composite composite;
	
	public void createControl(Composite parent) {
		composite = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout(1, false);
		composite.setLayout(layout);
		createConfigComposite(composite);
		createDownloadGroup(composite);
		setControl(composite);
		
		downloadButton.setFocus();
	}
	
	@Override
	protected void hookFirstVisit() {
		super.hookFirstVisit();
		
		ProcResourceSet pr = ProcResourceManager.getInstance().getProcResourceSet(getProject());
		String[] resourceNames = pr.listLocalResourceNames(getProject());

		statusLabel = new Label[resourceNames.length];
		 
		for (int cnt = 0; cnt < resourceNames.length; cnt++) {
	        Label name = new Label(container, SWT.NONE);
	        name.setText(resourceNames[cnt]);
	        name.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
	        statusLabel[cnt] = new Label(container, SWT.NONE);
	        statusLabel[cnt].setAlignment(SWT.LEFT);
	        statusLabel[cnt].setText(Messages.DownloadResourcePage_StatusLabelNotDownloaded);
	        statusLabel[cnt].setForeground(Activator.getStandardDisplay().getSystemColor(SWT.COLOR_DARK_GRAY));
	        statusLabel[cnt].setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		}
		composite.layout(true);
		composite.redraw();
	}

	private Composite container;
	
	private void createConfigComposite(Composite composite) {
		GridLayout layout = new GridLayout(2, true);
		container = new Composite(composite, SWT.NONE);
		
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		container.setLayoutData(data);
		container.setLayout(layout);
	}
	
    private void createDownloadGroup(Composite parent) {
		Composite container = new Composite(parent, SWT.NONE);
		container.setLayout(new GridLayout(2, false));
		GridData gridData = new GridData();
		gridData.horizontalAlignment = SWT.FILL;
		container.setLayoutData(gridData);

		Label blank = new Label(container, SWT.NONE);
		GridData lineData = new GridData(GridData.FILL_HORIZONTAL);
		lineData.horizontalSpan = 1;
		blank.setLayoutData(lineData);

		downloadButton = new Button(container, SWT.PUSH);
		downloadButton.setText(Messages.DownloadResourcePage_DownloadButton);
		downloadButton.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));
		downloadButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				handleIntallButtonPressed();
			}
			public void widgetDefaultSelected(SelectionEvent e) {
			}
		});
    }
    
	private Label[] statusLabel = null;
	
 	private void handleIntallButtonPressed() {
		if (download()) {
			downloadButton.setEnabled(false);
			setMessage(Messages.DownloadResourcePage_DonwloadOKMessage, INFORMATION);
			setPageComplete(true);
		} else {
			downloadButton.setEnabled(true);
			setMessage(Messages.DownloadResourcePage_DownloadNGMessage, ERROR);
			setPageComplete(false);
		}
	}

	private boolean download() {
		CreateNewProjectWizard wizard = (CreateNewProjectWizard)getWizard();
		CreateLocalResourceRunnable runnable = new CreateLocalResourceRunnable(wizard.getProject());
		try {
			wizard.getContainer().run(true, false, runnable);
		} catch (InvocationTargetException e) {
			Activator.logException(e);
			return false;
		} catch (InterruptedException e) {
			Activator.logException(e);
			return false;
		}
		return runnable.isOK();
	}

	private void updateLabel(int index, String message) {
	   Display.getDefault().asyncExec(new UpdateLabelRunnable(index, message));
	}
	
	private class UpdateLabelRunnable implements Runnable {
		private int index;
		private String message;
		public UpdateLabelRunnable(int index, String message) {
			this.index = index;
			this.message = message;
		}
		public void run() {
			statusLabel[index].setText(message);
			statusLabel[index].setForeground(Activator.getStandardDisplay().getSystemColor(SWT.COLOR_BLUE));
			statusLabel[index].pack();
			statusLabel[index].redraw();
		}   
	}
	
	private class CreateLocalResourceRunnable implements IRunnableWithProgress {
		private IProject project;
		private boolean status = false;
		public CreateLocalResourceRunnable(IProject project) {
			this.project = project;
		}
		public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
			ProcResourceSet pr = ProcResourceManager.getInstance().getProcResourceSet(project);
			LocalResource[] resources = pr.listLocalResource(getProject());
				
			monitor.beginTask("", resources.length); //$NON-NLS-1$
			
			for (int cnt = 0; cnt < resources.length; cnt++) {
				updateLabel(cnt, Messages.DownloadResourcePage_DownloadingMessage);

				LocalResource localResource = resources[cnt];
				localResource.create();

				if (ProcResourceManager.getInstance().synchronize(project, localResource)) {
					updateLabel(cnt, Messages.DownloadResourcePage_StatusLabelDownloaded);
					monitor.worked(1);
				} else {
					updateLabel(cnt, Messages.DownloadResourcePage_DownloadNGMessage);
					return;
				}
			}
				
			status = true;
		}
		public boolean isOK() {
			return status;
		}
	}

	protected void previousButtonPressed() {
	}

	protected void nextButtonPressed() {
	}

}
