/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

import jp.sourceforge.tomoyo.base.ssh.Activator;
import jp.sourceforge.tomoyo.core.*;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileManager;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceSet;
import jp.sourceforge.tomoyo.core.server.ConnectionManager;

public class CreateNewProjectWizard extends Wizard implements INewWizard {

	private NewProjectCreationPage newProjectPage;
	private ConnectionSettingPage connectionSettingPage;
	private CheckServerPage checkServerPage;
//	private DistributionSelectionPage distroPage;
	private ServerSettingsPage settingsPage;
	private DownloadResourcePage downloadPage;
	private SetupManagerDomainPage managerDomainPage;
	private SetupCompletePage completePage;

	public CreateNewProjectWizard() {
		super();
		setWindowTitle(Messages.CreateNewProjectWizard_WindowTitle);
		setDefaultPageImageDescriptor(Activator.getImageDescriptor("project_wiz.gif")); //$NON-NLS-1$
	}
	
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		setNeedsProgressMonitor(true);
	}
	
	public void createPageControls(Composite pageContainer) {
		super.createPageControls(pageContainer);
		
		setupHelps();
	}

	private void setupHelps() {
		/*
		for (int cnt = 0; cnt < pageList.size(); cnt++) {
			WizardPage page = (WizardPage)pageList.get(cnt);
			if (page instanceof AbstractWizardPage) {
				PlatformUI.getWorkbench().getHelpSystem().setHelp(page.getControl(),
						((AbstractWizardPage)page).getHelpResource());
			}
			if (page instanceof NewProjectCreationPage) {
				PlatformUI.getWorkbench().getHelpSystem().setHelp(page.getControl(),
						"jp.sourceforge.tomoyo.doc.new_project_name");
			}
		}
		*/
	}

	private ArrayList<WizardPage> pageList = new ArrayList<WizardPage>();
	
	public void addPages() {
		newProjectPage = new NewProjectCreationPage();
		connectionSettingPage = new ConnectionSettingPage();
		checkServerPage = new CheckServerPage();
//		distroPage = new DistributionSelectionPage();
		settingsPage = new ServerSettingsPage();
		downloadPage = new DownloadResourcePage();
		managerDomainPage = new SetupManagerDomainPage();
		completePage = new SetupCompletePage();
		_addPage(newProjectPage);
		_addPage(connectionSettingPage);
		_addPage(checkServerPage);
//		_addPage(distroPage);
		_addPage(settingsPage);
//		_addPage(profilePage);
		_addPage(downloadPage);
		_addPage(managerDomainPage);
		_addPage(completePage);
	}
	
	private void _addPage(WizardPage page) {
		pageList.add(page);
		addPage(page);
	}

	public boolean canFinish() {
		return managerDomainPage.isPageComplete();
	}

	public boolean performFinish() {
		IProject project = getProject();
		try {
			// install original nature.
			TomoyoCorePlugin.getDefault().installNature(project);
			// collect project profile.
			ProfileManager.getInstance().getProjectProfile(project);
		} catch (Exception e) {
			Activator.logException(e);
			return false;
		}
		try {
			IFile projectFile = ProcResourceManager.getInstance().getProcResourceSet(project).getProjectFile();
			// open status.txt as project file.
			Utilities.openEditor(projectFile);
		} catch (Exception e) {
			Activator.logException(e);
		}
		return true;
	}
	
	public IProject getProject() {
		return newProjectPage.getProject();
	}

	public boolean performCancel() {
		if (deleteProject(getProject()))
			return super.performCancel();
		else
			return false;
	}

	public boolean deleteProject(IProject deletingProject) {
		if (deletingProject == null)
			return true;
		
		ProjectPropertyManager.getInstance().removeCache(deletingProject);
		ConnectionManager.getInstance().disConnect(deletingProject);
		
		DeleteProjectRunnable runnable = new DeleteProjectRunnable(deletingProject);
		try {
			getContainer().run(false, false, runnable);
			return runnable.isOK();
		} catch (InvocationTargetException e) {
			Activator.logException(e);
		} catch (InterruptedException e) {
			Activator.logException(e);
		}
		return false;
	}
	
	private class DeleteProjectRunnable implements IRunnableWithProgress {
		private IProject project;
		private boolean status;
		public DeleteProjectRunnable(IProject project) {
			this.project = project;
		}
		public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
			if (project == null) {
				monitor.done();
				return;
			}
			/*
			monitor.beginTask("Deleting project" + " : " + project.getName(), IProgressMonitor.UNKNOWN);
			try {
				if (project.isOpen())
					project.close(monitor);
				project.delete(true, monitor);
				status = true;
			} catch (CoreException e) {
				status = false;
			} finally {
				monitor.done();
			}
			*/
			ProcResourceSet pr = ProcResourceManager.getInstance().getProcResourceSet(project);
			LocalResource[] resources = pr.listLocalResource(project);
			
			for (int cnt = 0; cnt < resources.length; cnt++) {
		        LocalResource localResource = resources[cnt];
		        IFile file = localResource.getFile();
		        try {
		        	if (file != null)
		        		file.delete(true, monitor);
		        } catch (CoreException e) {
		        	Activator.log(e);
		        }
			}
	        try {
				if (project.isOpen())
					project.close(monitor);
				project.delete(true, monitor);
	        } catch (CoreException e) {
	        	Activator.log(e);
	        }
			status = true;
		}
		public boolean isOK() {
			return status;
		}
	}

	public IWizardPage getNextPage(IWizardPage page) {
		try {
			return super.getNextPage(page);
		} finally {
			updateWindowTitle(page);
		}
	}

	public IWizardPage getPreviousPage(IWizardPage page) {
		try {
			return super.getPreviousPage(page);
		} finally {
			updateWindowTitle(page);
		}
	}

	private void updateWindowTitle(IWizardPage page) {
		IWizardPage[] pages = getPages();
		for (int cnt = 0; cnt < pages.length; cnt++) {
			if (pages[cnt] == getContainer().getCurrentPage()) {
				setWindowTitle(Messages.CreateNewProjectWizard_WindowTitle + " (" + (cnt + 1) + "/" +  getPageCount() + ")");
				getContainer().updateWindowTitle();
				break;
			}
		}
	}

}

