/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject;

import jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject.AbstractWizardPage;
import jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject.Messages;
import jp.sourceforge.tomoyo.core.Utilities;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SetupManagerDomainPage
extends AbstractWizardPage {
    private static final String DEF_DESCRIPTION = Messages.SetupManagerDomainPage_PageDescription;
    private Text managerDomainText;
    private Button installButton;

    public SetupManagerDomainPage() {
        super(Messages.SetupManagerDomainPage_PageName);
        this.setTitle(Messages.SetupManagerDomainPage_PageTitle);
        this.setDescription(DEF_DESCRIPTION);
        this.setPageComplete(false);
    }

    @Override
    protected String getHelpResourceName() {
        return "setup_manager_domain";
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        this.createMDomainComposite(composite);
        this.createDownloadGroup(composite);
        this.setControl((Control)composite);
    }

    @Override
    protected void hookFirstVisit() {
        this.setPageComplete(false);
        this.installButton.setEnabled(false);
        String recommendedManager = Utilities.getNeedToBeManagerDomain((IProject)this.getProject());
        if (recommendedManager == null) {
            this.managerDomainText.setText("");
            this.setErrorMessage(Messages.SetupManagerDomainPage_CouldNotCalculateManagerMessage);
            return;
        }
        this.managerDomainText.setText(recommendedManager);
        if (Utilities.isRegisterdAsManager((IProject)this.getProject(), (String)recommendedManager)) {
            this.setPageComplete(true);
            this.setMessage(Messages.SetupManagerDomainPage_AlreadyRegisteredMessage, 1);
        } else {
            this.setPageComplete(false);
            this.setMessage(Messages.SetupManagerDomainPage_PleaseInstallMessage, 2);
            this.installButton.setEnabled(true);
        }
    }

    private void createMDomainComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 0);
        label.setText(String.valueOf(Messages.SetupManagerDomainPage_ManagerLabel) + " : ");
        this.managerDomainText = new Text(parent, 2052);
        this.managerDomainText.setLayoutData((Object)new GridData(768));
        this.managerDomainText.setText("");
        this.managerDomainText.setEditable(false);
    }

    private void createDownloadGroup(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        container.setLayoutData((Object)gridData);
        Label blank = new Label(container, 0);
        GridData lineData = new GridData(768);
        lineData.horizontalSpan = 1;
        blank.setLayoutData((Object)lineData);
        this.installButton = new Button(container, 8);
        this.installButton.setText(Messages.SetupManagerDomainPage_InstallButton);
        this.installButton.setLayoutData((Object)new GridData(128));
        this.installButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SetupManagerDomainPage.this.handleIntallButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void handleIntallButtonPressed() {
        if (Utilities.installManagerDomain((IProject)this.getProject(), (String)this.managerDomainText.getText())) {
            this.setPageComplete(true);
            this.setMessage(Messages.SetupManagerDomainPage_SaveOKMessage, 1);
            this.installButton.setEnabled(false);
        } else {
            this.setPageComplete(false);
            this.setErrorMessage(Messages.SetupManagerDomainPage_SaveNGMessage);
        }
    }
}

