/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject;

import java.lang.reflect.InvocationTargetException;
import jp.sourceforge.tomoyo.base.ssh.Activator;
import jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject.CreateNewProjectWizard;
import jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject.Messages;
import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class NewProjectCreationPage
extends WizardNewProjectCreationPage {
    private IProject creatingProject = null;

    public NewProjectCreationPage() {
        super(Messages.NewProjectCreationPage_PageTitle);
        this.setTitle(Messages.NewProjectCreationPage_PageTitle);
        this.setDescription(Messages.NewProjectCreationPage_PageDescription);
    }

    protected boolean validatePage() {
        IProject[] projects = TomoyoCorePlugin.getDefault().getTomoyoCoreProjects();
        int cnt = 0;
        while (cnt < projects.length) {
            if (projects[cnt].getName().equals(this.getProjectName())) {
                this.setErrorMessage(Messages.NewProjectCreationPage_IdenticalNameErrorMessage);
                return false;
            }
            ++cnt;
        }
        this.setErrorMessage(null);
        return super.validatePage();
    }

    public IWizardPage getNextPage() {
        if (this.createNewProject()) {
            return super.getNextPage();
        }
        return null;
    }

    public boolean canFlipToNextPage() {
        return super.isPageComplete();
    }

    private boolean createNewProject() {
        if (this.creatingProject != null) {
            if (this.creatingProject.getName().equals(this.getProjectName())) {
                return true;
            }
            CreateNewProjectWizard wizard = (CreateNewProjectWizard)this.getWizard();
            boolean b = wizard.deleteProject(this.creatingProject);
            if (!b) {
                Activator.logErrorMessage("couldn't delete previously creating project.");
                return false;
            }
        }
        CreateProjectRunnable runnable = new CreateProjectRunnable(this.getProjectName());
        try {
            this.getWizard().getContainer().run(false, false, (IRunnableWithProgress)runnable);
            return runnable.isOK();
        }
        catch (InvocationTargetException e) {
            Activator.logException(e);
        }
        catch (InterruptedException e) {
            Activator.logException(e);
        }
        return false;
    }

    public IProject getProject() {
        return this.creatingProject;
    }

    private class CreateProjectRunnable
    implements IRunnableWithProgress {
        private String name;
        private boolean status;

        public CreateProjectRunnable(String name) {
            this.name = name;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(String.valueOf(Messages.NewProjectCreationPage_CreatingProjectProgressMessage) + " : " + this.name, -1);
            NewProjectCreationPage.this.creatingProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.name);
            try {
                try {
                    NewProjectCreationPage.this.creatingProject.create(monitor);
                    NewProjectCreationPage.this.creatingProject.open(monitor);
                    this.status = true;
                }
                catch (CoreException coreException) {
                    this.status = false;
                }
            }
            finally {
                monitor.done();
            }
        }

        public boolean isOK() {
            return this.status;
        }
    }
}

