/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject;

import jp.sourceforge.tomoyo.base.ssh.Activator;
import jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject.AbstractWizardPage;
import jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject.Messages;
import jp.sourceforge.tomoyo.core.PersistentPropertyManager;
import jp.sourceforge.tomoyo.core.ProjectProperty;
import jp.sourceforge.tomoyo.core.Utilities;
import jp.sourceforge.tomoyo.core.server.CommandManager;
import jp.sourceforge.tomoyo.core.server.ConcreteCommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CheckServerPage
extends AbstractWizardPage {
    private Text versionText;
    private Label osLabel = null;
    private Label tomoyoLabel = null;

    public CheckServerPage() {
        super("");
        this.setTitle(Messages.CheckServerPage_PageTitle);
        this.setDescription("");
        this.setPageComplete(false);
    }

    @Override
    protected String getHelpResourceName() {
        return "installation_check";
    }

    @Override
    public IWizardPage getPreviousPage() {
        super.getPreviousPage();
        return null;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        this.createConfigComposite(composite);
        this.createInstallGroup(composite);
        this.setControl((Control)composite);
    }

    private void createConfigComposite(Composite composite) {
        GridLayout layout = new GridLayout(2, false);
        Composite container = new Composite(composite, 0);
        GridData data = new GridData(768);
        container.setLayoutData((Object)data);
        container.setLayout((Layout)layout);
        Label osTitle = new Label(container, 0);
        osTitle.setText(String.valueOf(Messages.CheckServerPage_LinuxLabel) + " : ");
        this.osLabel = new Label(container, 0);
        this.osLabel.setAlignment(16384);
        this.osLabel.setText(Messages.CheckServerPage_No);
        this.osLabel.setForeground(Activator.getStandardDisplay().getSystemColor(16));
        this.osLabel.setLayoutData((Object)new GridData(768));
        Label tomoyoTitle = new Label(container, 0);
        tomoyoTitle.setText(String.valueOf(Messages.CheckServerPage_TomoyoLinuxLabel) + " : ");
        this.tomoyoLabel = new Label(container, 0);
        this.tomoyoLabel.setAlignment(16384);
        this.tomoyoLabel.setText(Messages.CheckServerPage_No);
        this.tomoyoLabel.setForeground(Activator.getStandardDisplay().getSystemColor(16));
        this.tomoyoLabel.setLayoutData((Object)new GridData(768));
        Label versionLabel = new Label(container, 0);
        versionLabel.setText(String.valueOf(Messages.CheckServerPage_TomoyoVersionLabel) + " : ");
        this.versionText = new Text(container, 2052);
        this.versionText.setLayoutData((Object)new GridData(768));
        this.versionText.setEditable(false);
    }

    private void createInstallGroup(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        container.setLayoutData((Object)gridData);
        Label blank = new Label(container, 0);
        GridData lineData = new GridData(768);
        lineData.horizontalSpan = 1;
        blank.setLayoutData((Object)lineData);
    }

    @Override
    protected void hookFirstVisit() {
        this.checkServer();
    }

    private void checkServer() {
        ConcreteCommand command = null;
        command = CommandManager.getInstance().exec(this.getProject(), "uname", new String[]{"-s"}, null);
        if (command.isSuccessful()) {
            if (!command.getSTDOut().startsWith("Linux")) {
                this.setMessage(Messages.CheckServerPage_NotLinuxBoxErrorMessage, 3);
                this.setPageComplete(false);
                return;
            }
        } else {
            this.setMessage(Messages.CheckServerPage_UnknownOSErrorMessage, 3);
            this.setPageComplete(false);
            return;
        }
        this.osLabel.setText(Messages.CheckServerPage_Yes);
        this.osLabel.setForeground(Activator.getStandardDisplay().getSystemColor(9));
        this.osLabel.pack();
        this.osLabel.redraw();
        command = CommandManager.getInstance().exec(this.getProject(), "ls", null, new String[]{"/proc/ccs"});
        if (!command.isSuccessful()) {
            this.setMessage(Messages.CheckServerPage_TOMOYOInstallationNo, 3);
            this.setPageComplete(false);
            return;
        }
        this.tomoyoLabel.setText(Messages.CheckServerPage_Yes);
        this.tomoyoLabel.setForeground(Activator.getStandardDisplay().getSystemColor(9));
        this.tomoyoLabel.pack();
        this.tomoyoLabel.redraw();
        String strVersion = Utilities.distinctVersion((IProject)this.getProject());
        this.versionText.setText(strVersion);
        if (Utilities.isSupportedVersion((String)strVersion)) {
            this.versionText.setForeground(Activator.getStandardDisplay().getSystemColor(9));
            this.setMessage(Messages.CheckServerPage_SupportedTOMOYOFoundMessage, 1);
            this.setPageComplete(true);
        } else {
            this.setMessage(Messages.CheckServerPage_UnSupportedTOMOYOFoundMessage, 3);
            this.setPageComplete(false);
        }
    }

    @Override
    protected void nextButtonPressed() {
        this.storeProperties();
    }

    private void storeProperties() {
        ProjectProperty properties = new ProjectProperty(this.getProject());
        properties.setProperty(PersistentPropertyManager.PROPERTY_VERSION, this.versionText.getText());
    }
}

