/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.base.ssh.connection;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.util.Observable;
import jp.sourceforge.tomoyo.base.ssh.Activator;
import jp.sourceforge.tomoyo.base.ssh.connection.Messages;
import jp.sourceforge.tomoyo.base.ssh.connection.SSHConnectionSettings;
import jp.sourceforge.tomoyo.base.ssh.connection.SSHUserInfo;
import jp.sourceforge.tomoyo.core.server.Connection;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SSHSession
extends Observable
implements Connection {
    protected SSHConnectionSettings settings = null;
    protected Session session = null;
    private String errorMessage;

    public SSHSession(SSHConnectionSettings settings) {
        this.settings = settings;
    }

    private void notifyObservers(int statusDisconnected) {
        this.setChanged();
        this.notifyObservers(this.settings);
    }

    public boolean isConnected() {
        if (this.session == null) {
            return false;
        }
        return this.session.isConnected();
    }

    public boolean connect() {
        block5: {
            try {
                if (!this.settings.confirmConnection) break block5;
                ConfirmDialog dialog = new ConfirmDialog();
                Display.getDefault().syncExec((Runnable)dialog);
                if (dialog.isConnecting()) break block5;
                return false;
            }
            catch (JSchException e) {
                this.setErrorMessage(e.toString());
                this.notifyObservers(2);
                Activator.log(e);
                return false;
            }
        }
        if (this.settings.isPublicKeyAuthentication) {
            this.connect(this.settings.hostname, this.settings.portno, this.settings.username, this.settings.knownHosts, this.settings.pkeyfile);
        } else {
            this.connect(this.settings.hostname, this.settings.portno, this.settings.username, this.settings.knownHosts, this.settings.password);
        }
        this.setErrorMessage(null);
        this.notifyObservers(1);
        return true;
    }

    private void connect(String host, int port, String username, File known_hosts, File private_key) throws JSchException {
        if (this.isConnected()) {
            return;
        }
        JSch jsch = new JSch();
        SSHUserInfo ui = new SSHUserInfo();
        ui.setHoskeyCheck(known_hosts != null);
        if (known_hosts != null) {
            jsch.setKnownHosts(known_hosts.getAbsolutePath());
        }
        jsch.addIdentity(private_key.getAbsolutePath());
        this.session = jsch.getSession(username, host, port);
        this.session.setUserInfo((UserInfo)ui);
        this.session.connect();
    }

    private void connect(String host, int port, String username, File known_hosts, String password) throws JSchException {
        if (this.isConnected()) {
            return;
        }
        JSch jsch = new JSch();
        SSHUserInfo ui = new SSHUserInfo();
        ui.setHoskeyCheck(known_hosts != null);
        ui.setPassword(password);
        if (known_hosts != null) {
            jsch.setKnownHosts(known_hosts.getAbsolutePath());
        }
        this.session = jsch.getSession(username, host, port);
        this.session.setUserInfo((UserInfo)ui);
        this.session.connect();
    }

    public Channel getChannel() throws JSchException {
        if (!this.isConnected()) {
            this.connect();
        }
        if (this.session == null) {
            return null;
        }
        return this.session.openChannel("exec");
    }

    public void disconnect() {
        if (this.session != null) {
            this.session.disconnect();
        }
        this.notifyObservers(2);
    }

    private void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private class ConfirmDialog
    implements Runnable {
        private boolean connect;

        private ConfirmDialog() {
        }

        @Override
        public void run() {
            this.connect = MessageDialog.openQuestion((Shell)Activator.getStandardDisplay().getActiveShell(), (String)Messages.SSHSession_ConnectConfirmDialogTitle, (String)Messages.SSHSession_ConnectConfirmMessage);
        }

        public boolean isConnecting() {
            return this.connect;
        }
    }
}

