/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.text.outline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jp.sourceforge.tomoyo.core.local.model.AbstractPolicyModel;
import jp.sourceforge.tomoyo.core.local.model.PolicyCacheManager;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.PolicyElementDefinition;
import jp.sourceforge.tomoyo.ui.editor.text.outline.PolicyOutlineContentProvider;
import org.eclipse.core.resources.IProject;

public class ExceptPolicyOutlineContentProvider
extends PolicyOutlineContentProvider {
    private IProject project;
    private Comparator<Object> sorter = new Comparator<Object>(){

        @Override
        public int compare(Object obj1, Object obj2) {
            String str1 = this.toString(obj1);
            String str2 = this.toString(obj2);
            try {
                return str1.compareTo(str2);
            }
            catch (NullPointerException nullPointerException) {
                return 0;
            }
        }

        private String toString(Object obj) {
            if (obj instanceof PolicyElementDefinition) {
                PolicyElementDefinition definition = (PolicyElementDefinition)obj;
                return definition.getDirectiveName();
            }
            if (obj instanceof PolicyElement) {
                PolicyElement element = (PolicyElement)obj;
                return element.getText();
            }
            return obj.toString();
        }
    };
    private boolean definitionVisible = false;

    public ExceptPolicyOutlineContentProvider(IProject project) {
        this.project = project;
    }

    @Override
    public Object[] getChildren(Object parent) {
        if (parent instanceof AbstractPolicyModel) {
            ArrayList<PolicyElementDefinition> children = new ArrayList<PolicyElementDefinition>();
            AbstractPolicyModel model = (AbstractPolicyModel)parent;
            ArrayList elementDefinitions = model.listElementDefinitions(true);
            int cnt = 0;
            while (cnt < elementDefinitions.size()) {
                PolicyElementDefinition definition = (PolicyElementDefinition)elementDefinitions.get(cnt);
                children.add(definition);
                ++cnt;
            }
            Collections.sort(children, this.sorter);
            return children.toArray();
        }
        if (parent instanceof PolicyElementDefinition[]) {
            ArrayList<PolicyElement> children = new ArrayList<PolicyElement>();
            PolicyElementDefinition[] defArray = (PolicyElementDefinition[])parent;
            int cnt = 0;
            while (cnt < defArray.length) {
                PolicyElementDefinition definition = defArray[cnt];
                List retlist = PolicyCacheManager.getInstance().findElementList(this.project, definition.getElementClass());
                this.filterDeleted(retlist, children);
                ++cnt;
            }
            Collections.sort(children, this.sorter);
            return children.toArray();
        }
        if (parent instanceof PolicyElementDefinition) {
            ArrayList<PolicyElement> children = new ArrayList<PolicyElement>();
            PolicyElementDefinition definition = (PolicyElementDefinition)parent;
            if (this.definitionVisible) {
                ArrayList list = (ArrayList)PolicyCacheManager.getInstance().findElementList(this.project, definition.getElementClass());
                this.filterDeleted(list, children);
            }
            Collections.sort(children, this.sorter);
            return children.toArray();
        }
        return new Object[0];
    }

    private void filterDeleted(List<PolicyElement> elementList, ArrayList<PolicyElement> retlist) {
        int cnt = 0;
        while (cnt < elementList.size()) {
            PolicyElement child = elementList.get(cnt);
            if (!child.isDeleted()) {
                retlist.add(child);
            }
            ++cnt;
        }
    }

    public void setDefinitionVisible(boolean b) {
        this.definitionVisible = b;
    }
}

