/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.text.outline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jp.sourceforge.tomoyo.core.local.model.AbstractPolicyModel;
import jp.sourceforge.tomoyo.core.local.model.PolicyCacheManager;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.domain.AccessPermission;
import jp.sourceforge.tomoyo.core.local.model.domain.Domain;
import jp.sourceforge.tomoyo.core.othres.DomainTransitionTreeAsciiOrderSorter;
import jp.sourceforge.tomoyo.ui.editor.text.outline.PolicyOutlineContentProvider;

public class DomainPolicyOutlineContentProvider
extends PolicyOutlineContentProvider {
    private AbstractPolicyModel document;
    private DomainTransitionTreeAsciiOrderSorter sorter = new DomainTransitionTreeAsciiOrderSorter(true, false, false);
    private boolean includeAccessPermission = false;

    @Override
    public Object[] getChildren(Object parent) {
        ArrayList<PolicyElement> children = new ArrayList<PolicyElement>();
        PolicyElement element = (PolicyElement)parent;
        if (parent instanceof AbstractPolicyModel) {
            this.document = (AbstractPolicyModel)parent;
            int cnt = 0;
            while (cnt < element.getChildrenCount()) {
                Domain domain;
                if (element.getChild(cnt) instanceof Domain && (domain = (Domain)element.getChild(cnt)).isKernel()) {
                    children.add((PolicyElement)domain);
                }
                ++cnt;
            }
        }
        if (element instanceof Domain) {
            Domain child;
            Domain domain = (Domain)element;
            List childDomains = PolicyCacheManager.getInstance().listChildDomains(this.document.getProject(), domain);
            int cnt = 0;
            while (cnt < childDomains.size()) {
                child = (Domain)childDomains.get(cnt);
                if (child.isSkelton()) {
                    children.add((PolicyElement)child);
                } else if (!child.isDeleted()) {
                    children.add((PolicyElement)child);
                }
                ++cnt;
            }
            if (domain.hasInitializerExecutable() && !domain.isKernel()) {
                ArrayList initializerExecutables = domain.getInitializerExecutables();
                int cnt2 = 0;
                while (cnt2 < initializerExecutables.size()) {
                    children.add((PolicyElement)initializerExecutables.get(cnt2));
                    ++cnt2;
                }
            }
            if (this.includeAccessPermission) {
                cnt = 0;
                while (cnt < domain.getChildrenCount()) {
                    child = domain.getChild(cnt);
                    if (child instanceof AccessPermission && !child.isDeleted()) {
                        children.add((PolicyElement)child);
                    }
                    ++cnt;
                }
            }
        }
        Collections.sort(children, this.sorter);
        this.addIndex(children);
        return children.toArray();
    }

    public void includeAccessPermission(boolean b) {
        this.includeAccessPermission = b;
    }
}

