/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tomoyo.ui.editor.text;

import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import jp.sourceforge.tomoyo.core.local.model.domain.Domain;
import jp.sourceforge.tomoyo.core.local.parser.PolicyParserManager;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.CoreEditor;
import jp.sourceforge.tomoyo.ui.editor.ICoreEditorOutlinePageProvider;
import jp.sourceforge.tomoyo.ui.editor.ICoreEditorPage;
import jp.sourceforge.tomoyo.ui.editor.text.outline.PolicyOutlinePage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;

public abstract class PolicyEditor
extends TextEditor
implements ICoreEditorPage,
IFormPage,
ICoreEditorOutlinePageProvider {
    private PolicyOutlinePage outlinePage = null;
    private CoreEditor fEditor;
    protected PolicyOutlinePage outline;
    private PropertySheetPage propertySheet;
    private Control fControl;
    private boolean isPolicyUpdated = false;

    public PolicyEditor(CoreEditor editor) {
        this.fEditor = editor;
        PolicyParserManager.getInstance().addObserver((Observer)new PolicyUpdateObserver());
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
    }

    private boolean isDocumentReloaded() {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider != null) {
            return provider.getSynchronizationStamp((Object)this.getFile()) == provider.getModificationStamp((Object)this.getFile());
        }
        return false;
    }

    public boolean isEditable() {
        return false;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IContentOutlinePage.class)) {
            this.outlinePage = this.getContentOutline();
            return this.outlinePage;
        }
        if (adapter.equals(IPropertySheetPage.class)) {
            return this.getPropertySheet();
        }
        return super.getAdapter(adapter);
    }

    protected abstract PolicyOutlinePage getContentOutline();

    public PropertySheetPage getPropertySheet() {
        if (this.propertySheet == null) {
            this.propertySheet = new PropertySheetPage();
        }
        return this.propertySheet;
    }

    public abstract IAdaptable getDocumentModel();

    protected void handleCursorPositionChanged() {
        super.handleCursorPositionChanged();
        SourceViewer viewer = (SourceViewer)this.getSourceViewer();
        Point point = viewer.getSelectedRange();
        if (this.outline != null) {
            this.outline.updateCursor(point.x);
        }
    }

    protected IFile getFile() {
        return ((FileEditorInput)this.getEditorInput()).getFile();
    }

    public IProject getProject() {
        return this.getFile().getProject();
    }

    public abstract void updateFoldingStructure(Hashtable<Domain, Position> var1);

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        Control[] children = parent.getChildren();
        this.fControl = children[children.length - 1];
    }

    @Override
    public void notifyPageActivated() {
        if (this.isPolicyUpdated) {
            this.handleEditorInputChanged();
            if (this.isDocumentReloaded()) {
                this.getContentOutline().notifyPolicyUpdated();
                this.isPolicyUpdated = false;
            }
        }
    }

    public boolean canLeaveThePage() {
        return true;
    }

    public FormEditor getEditor() {
        return this.fEditor;
    }

    public String getId() {
        return this.getClass().getName();
    }

    public int getIndex() {
        return 6;
    }

    public IManagedForm getManagedForm() {
        return null;
    }

    public Control getPartControl() {
        return this.fControl;
    }

    public void initialize(FormEditor editor) {
        this.fEditor = (CoreEditor)editor;
    }

    public boolean isActive() {
        return this.equals(this.fEditor.getActivePageInstance());
    }

    public boolean isEditor() {
        return true;
    }

    public boolean selectReveal(Object object) {
        return false;
    }

    public void setActive(boolean active) {
    }

    public void setIndex(int index) {
    }

    @Override
    public ContentOutlinePage getContentOutlinePage() {
        return this.getContentOutline();
    }

    private class PolicyUpdateObserver
    implements Observer {
        private PolicyUpdateObserver() {
        }

        @Override
        public void update(Observable o, Object arg) {
            if (o instanceof PolicyParserManager) {
                LocalResource localResource = (LocalResource)arg;
                if (!PolicyEditor.this.getFile().equals((Object)localResource.getFile())) {
                    return;
                }
                Activator.getStandardDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (PolicyEditor.this.isActive()) {
                            PolicyEditor.this.handleEditorInputChanged();
                            if (PolicyEditor.this.isDocumentReloaded()) {
                                PolicyEditor.this.getContentOutline().notifyPolicyUpdated();
                                PolicyEditor.this.isPolicyUpdated = false;
                            }
                        } else {
                            PolicyEditor.this.isPolicyUpdated = true;
                        }
                    }
                });
            }
        }
    }
}

